c     ****************************************************************
c     *                                                              *
c     * kbchop:  primitive binary chop to find a root of a function  *
c     *                                                              *
c     ****************************************************************
c
c   /usage/
c            call kbchop(f, x1, x2, er, x, n)
c all must be double precision
c
c     f:  a double precistion function name with one argument
c    x1:  lower boundary of root to be found
c    x2:  upper //
c    er:  specifies relative accuracy of root to be found
c     x:  root found
c     n:  condition code:  no. of iteration needed to find the root
c         (>=0)  or error code (<0).  n = -1 means unconvergence after
c         30 iterations.  x may be errorneous.   n=-2 means f(x1)
c         and f(x2) have same sign.  x becomes undef.
c
c  *** note ***
c         must x1 < x2.   f(x1) and f(x2) must have different sign
c
c
c
c
      subroutine kbchop(f, x1, x2, er, x, n)
      implicit none
      external f
      real*8 f, x1, x2, er, x
      integer n

      character*160 msg
c
c
c
      real*8 a, b, fa, fb, t, ft

      real*8  td
      integer j
c
      a = x1
      b = x2
      fa=f(a)
      fb=f(b)
      td = 1.d50
      if(fa * fb .gt. 0.) then
         write(msg,*) ' a, b, fa, fb=',a, b, fa, fb, 'in kbchop'
         call cerrorMsg(msg, 1)
         n=-2
      else       
         do j = 1, 100
            if(fa*fb .le. 0.) then
               t=(a+b)*.5
               if(abs(td) .gt. er) then
                  if(abs((td-t)/td) .le. er) then
                     n = j
                     goto 100
                  endif
               else
                  if(abs(td - t) .le. er) then
                     n =  j
                     goto  100
                  endif
               endif

               td = t
               ft = f(t)
               if(fa * ft .lt. 0.)then
                  b=t
                  fb = ft
               else   
                  a = t
                  fa = ft
               endif
            else
               n = j
               goto 200
            endif    
         enddo
         n = j
      endif
 100  continue
 200  continue
      x=t
      end
