      subroutine epBrHSampP(media, Ee, prob)
      implicit none
#include "Zmedia.h"
c        Brems sampling at LPM energies.
      record /epmedia/media
      real*8 Ee
      real*8 prob  ! output probability of Brems / X0

      real*8 ale

      if(Ee .le. media.cnst.BrEe1H) then
         call cerrorMsg(
     *      'Energy is too low for LPM brems', 0)

      elseif(Ee .lt. media.cnst.BrEe2H) then
         ale=log10(Ee)
         call kintp3(media.tbl.BrTXH,
     *   1, media.cnst.BrneH, media.cnst.BrLEe1H,
     *   media.cnst.BrdEH, ale, prob) 

      else
c          use  1/sqrt(E) low
         prob = media.tbl.BrTXH(media.cnst.BrneH)/
     *         sqrt((Ee/media.cnst.BrEe2H))
      endif
      end
c     ************
      subroutine epBrHSampE(media, Ee, Eg)
c     ************
      implicit none
#include "Zglobalc.h"
#include "Zmedia.h"
#include "Zmass.h"

      record /epmedia/media
      real*8 Ee,  Eg

      real*8 u, ale, us, ans, sqrtvm

      call rndc(u)
      ale = log10(Ee)
      if(Ee .lt. media.cnst.BrEe2H2) then
         if(u .gt. media.cnst.BrU1H) then
c          region A
            call k4ptdi(media.tbl.BrSTHA, 
     *        media.cnst.Brnu1H, 
     *        media.cnst.BrneH2,
     *        media.cnst.Brnu1H, 
     *        media.cnst.BrU1H,
     *        media.cnst.BrLEe1H,
     *        media.cnst.BrdU1H,
     *        media.cnst.BrdEH2, u,  ale,  ans)  
            sqrtvm = sqrt(media.cnst.BrEgminH/Ee)
            Eg =
     *      ( (1.d0-u) * ans + sqrtvm)**2 * Ee
         else
c          region B
            us= u**(1./media.cnst.BrPow)
            call k4ptdi(media.tbl.BrSTHB, 
     *        media.cnst.Brnu2H,
     *        media.cnst.BrneH2,
     *        media.cnst.Brnu2H,
     *        media.cnst.BrU3H,
     *        media.cnst.BrLEe1H,
     *        media.cnst.BrdU2H,
     *        media.cnst.BrdEH2, us,  ale,  ans)  
            Eg= exp(- ans*u )*(Ee-masele)
         endif
      else
c           use rejection method; employ cosmos function
c           neglect  Eg/Ee< 1.e-6
         call csetLPMCnst(media.s1, media.logs1, 
     *     max(1.d-6, media.cnst.BrEgminH/Ee), media.X0g*Tokgpm2) ! X0g in kg/m^2
         call cbremErgLPM(Ee, media.rho*Tokgpm3, Eg)  ! rho in kg/m^3
      endif
      end
