      real*8 function epBrem(Eeme,  x)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
       real*8 Eeme, x
c         
c         first get
c         bremsung function per radiation length.  approximation j in
c         koch & motz notation + correction at low energy
c     Then convert it into mb/target.
c             
c          Since  sigma = alpha r0**2 f(z) g(x) 
c        and 1/X0 = alpha r0**2 f(z)  N0/A (cm2/g)
c     (N0; Abogadro no. A: mass number)
c        and epBrem first gives g(x).  So, sigma can be
c    obtained by  sigma = A/(N0X0) g(x).
c    Since the radiation length has linear A dependence
c       sigma =  g(x)/ N0 / (X0/A); X0/A has no A dependence.
c    x0g in /bpcom/  has been given by using A= 1 so that
c    we may devide g(x) by N0*X0 to get sigma in cm^2. 
c    To convert it to mb, 10^{27} is to be multiplied.
c    Hence  10^27/N0 = 1.66e3,  g(x)*1.66e3/x0g is in mb
c
c      x0g is computed by using Tsai's formula.

c
      common / bpcom /al183z, E, ccz, emass, bcoef, fz ,z333, x0g,
     *   NonScEme,  BHnorm, Z2
      real*8 NonScEme, BHnorm, Z2, emass, al183z, x0g, ccz, bcoef,
     *  fz, z333, E
c
      real*8 cmTomb, v, bigf, bcorec
      parameter (cmTomb = 1.d27/N0)
      v = x
      E = Eeme * emass
      epBrem = max( bigf(0,v)/al183z*bcorec(E)/v, 0.d0)
c          convert it to mb
      epBrem = epBrem * cmTomb /x0g
      end

c     ************
      real*8 function epPair(Egme, x)
c     ************
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"

      real*8 cmTomb
      parameter (cmTomb = 1.d27/N0)

c
      real*8 x, Egme
      real*8 epPairLowE

      common / bpcom /al183z, E, ccz, emass, bcoef, fz ,z333, x0g,
     *   NonScEme,  BHnorm, Z2
      real*8 NonScEme, BHnorm, Z2, emass, al183z, x0g, ccz, bcoef,
     *  fz, z333, E
      real*8 v, bigg, pcorec

      if(Egme .ge. NonScEme) then
         v = x
         E =  Egme * emass      ! Eg not electron E
c        pair creation function  v=e/eg
         epPair = max( bigg(v)/al183z*pcorec(E), 0.d0)
c          convert it into mb
         epPair = epPair * cmTomb /x0g
      else
c           B.H's original formulat down to threshold
         epPair = epPairLowE(Egme, x)
         epPair = epPair * BHnorm * Z2 * ar02
      endif
      end
c     ****************************************************************
c     *                                                              *
c     *  bigf:  auxliary function for brems cross-section            *
c     *  bigg:  //                    pair                           *
c     *                                                              *
c     ****************************************************************
c
c
c
      real*8 function bigf(n,v)
      implicit none
      real*8 bigg
c
c
c
c        f-function in bremsung function
c

      common / bpcom /al183z, E, ccz, emass, bcoef, fz ,z333, x0g,
     *   NonScEme,  BHnorm,  Z2
      real*8 NonScEme, BHnorm, Z2, emass, al183z, x0g, ccz, bcoef,
     *  fz, z333, E
      real*8 g, scrnfb, t0,  t1, t2, t3, v, smlf1, smlf2
      real*8 t4, t5, t6
      real*8 tmp0, tmp1, dgdv, dgdv2, dgdvs, tmp
      real*8 cscrn, scrnfp
      integer n
c
c        screening parameter
      g=scrnfb(0,v)
c
      if( g .gt. 2.d0) goto 100
      t0=1.d0-v
      t1=(1.d0+t0*t0)
c        ccz=log(z)/3+f(z); f=coulomb corection function
      t2=(0.25*smlf1(0,g)-ccz)
      t3=(0.25*smlf2(0,g)-ccz)
      tmp0=t1*t2-.666666666666d0*t0*t3
      if(n.ne.0) goto 10
      bigf=tmp0
      return
c
   10 continue
      dgdv=scrnfb(1,v)
      t4=.25* smlf1(1,g)
      t5=.25*smlf2(1,g)
      tmp1=-2.*t0*t2+t1*t4*dgdv+.66666666*(t3-t0*t5*dgdv)
      if(n.ne.1) goto 20
      bigf=tmp1
      return
c
   20 continue
      dgdv2=scrnfb(2,v)
      dgdvs=dgdv*dgdv*.25
      bigf=2.*t2-4.*t0*t4*dgdv+t1*(dgdv2*t4+dgdvs*smlf1(2,g) )+1.333333
     1*t5*dgdv-.66666666*t0*(dgdv2*t5+dgdvs*smlf2(2,g)  )
      return
c
c        almost no screening region
c
  100 continue
      t0=1.-v
      t1=t0*t0-.6666666*t0+1.
      t2=log(2.*E/emass*t0/v)-.5-cscrn(0,g)-fz
      if(n.ne.0) goto 110
      bigf=t1*t2
      return
c
  110 continue
      dgdv=scrnfb(1,v)
      t3=-2.*t0+.666666
      t4=-1./t0-1./v-dgdv*cscrn(1,g)
      if(n.ne.1) goto 120
      bigf=t3*t2+t1*t4
      return
c
  120 continue
      dgdv2=scrnfb(2,v)
      t5=2.
      t6=1./t0/t0+1./v/v-dgdv    *dgdv*cscrn(2,g)-dgdv2*cscrn(1,g)
      bigf=t5*t2+2.*t3*t4+t1*t6
      return
c
c     **********
      entry bigg(v)
c     **********
c
c     g-function in pair creation function
c
c        screening parameter
c
      g=scrnfp(v)
      tmp=1.-v
      if(g.gt.2.) goto 200
      bigf=(v*v+tmp*tmp)*(.25*smlf1(0,g)-ccz)+.666666*v*tmp*(.25*
     *  smlf2(0, g)-ccz)
      return
c
c
  200 continue
      bigf=(v*v+tmp*tmp+.666666*v*tmp)*(log(2.*e/emass*v*tmp)-.5-
     *  cscrn(0,g)-fz   )
      return
      end
c     ****************************************************************
c     *                                                              *
c     *  scrnfb:  to give screening parameter for brems              *
c     *  scrnfp:  //                              pair               *
c     *                                                              *
c     ****************************************************************
c
c
c
      real*8 function     scrnfb(n,v)
      implicit none
c
c        gives screening parameter for brems e= in gev.
c

      common / bpcom /al183z, E, ccz, emass, bcoef, fz ,z333, x0g,
     *   NonScEme,  BHnorm,  Z2
      real*8 NonScEme, BHnorm, Z2, emass, al183z, x0g, ccz, bcoef,
     *  fz, z333, E
      real*8 v
      integer n
      real*8 tmp
      real*8 scrnfp
c       0.0511 comes from 100 Me/E/Z**(1/3) 
      tmp=0.0511d0/E/z333
c
      if(n.ne.0) goto 2
      scrnfb=tmp*v/(1.d0-v)
      return
c
    2 continue
      if(n.ne.1) goto 4
      scrnfb=tmp/(1.d0-v)**2
      return
c
    4 continue
      scrnfb=tmp*2./(1.-v)**3
      return
c
c     ************
      entry scrnfp(v)
c     ************
c
c        gives screening parameter for pair creation
c
      scrnfb=.0511/E/z333/v/(1.d0-v)
      return
      end
c     ****************************************************************
c     *                                                              *
c     *  smlf1:  auxliary screening function for brems cross-section *
c     *  smlf2:   //                                                 *
c     *  bcorec: correction function for brems at low energies       *
c     *  pcorec: //                      pair  //                    *
c     *  cscrn:  screening function when g>2                         *
c     *                                                              *
c     ****************************************************************
c
c
c
c
      real*8 function smlf1(n,g)
      implicit none
c
c
c
c        screening function small f1(g)
c

      common / bpcom /al183z, E, ccz, emass, bcoef, fz ,z333, x0g,
     *   NonScEme,  BHnorm, Z2
      real*8 NonScEme, BHnorm, Z2, emass, al183z, x0g, ccz, bcoef,
     *  fz, z333, E
      real*8 EE, g, tmp
      real*8 smlf2, bcorec, pcorec, cscrn
      integer n, nn
c
      nn=n+1
      if(g.gt.1.d0) goto 100
      goto (10,20,30) ,nn
c
   10 continue
      smlf1=((-1.046117*g+2.445063)*g-4.63689)*g+20.83794
c     smlf1=(.625*g-3.24)*g+20.867
      return
c
   20 continue
      smlf1=1.25*g-3.24
      return
   30 continue
      smlf1=1.25
      return
c
c
  100 continue
      goto (110,120,130),nn
c
  110 continue
      smlf1=19.052795-3.760637*log(g+0.47155)
c     smlf1=21.12-4.184*log(g+.952)
      return
c
  120 continue
      smlf1=-4.184/(g+.952)
      return
c
  130 continue
      smlf1=4.184/(g+.952)**2
      return
c
c
c     ***********
      entry smlf2(n,g)
c     ***********
c
      nn=n+1
      if(g.gt.1.) goto 100
      goto (200,210,220),nn
c
  200 continue
      smlf1=((1.49546*g-2.33405)*g-1.73269)*g+20.171278
c     smlf1=(-.086*g-1.930)*g+20.209
      return
c
  210 continue
      smlf1=-0.172*g-1.930
      return
c
  220 continue
      smlf1=-0.172
      return
c
c     ************
      entry bcorec(EE)
c     ************
c
c        bremsung coreection function at low energy
c         ee=e
c
      smlf1=1.+bcoef/EE
      return
c
c     ************
      entry pcorec(EE)
c     ************
c
c         paircreation correction function at low energy
c       ee=e
c
      smlf1=1.+.4e-3/(EE-0.99e-3)
      return
c     ************
      entry cscrn(n,g)
c     ************
c
c        screening function when g.gt.2.
c        approximation made by c(g)=.24/g+.36/g/g
c
      tmp=1./g
      nn=n+1
      goto (510,520,530),nn
c
  510 continue
      smlf1=g**(-2.2)/(0.20322+2.11737*g**(-1.34562)  )
      return
c
  520 continue
      smlf1=(-2.*.36*tmp-.24)*tmp*tmp
      return
c
  530 continue
      smlf1=(6.*.36*tmp+2.*.24)*tmp*tmp*tmp
      end
c
c     ************
      subroutine  epBPZpart(media, zin)
c     ************
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmedia.h"
#include "Zmass.h"

      record /epmedia/media  !  input
      real*8 zin        ! input

      common / bpcom /al183z, E, ccz, emass, bcoef, fz ,z333, x0g,
     *   NonScEme,  BHnorm, Z2
      real*8 NonScEme, BHnorm, Z2, emass, al183z, x0g, ccz, bcoef,
     *  fz, z333, E

      real Z
      real*8 dz, dx0g
      real*8 xnorm, temp
      real*8 ccorec
      real*8 epPair, epPairLowE
      data xnorm/0.5d0/
      save xnorm

      NonScEme = media.cnst.PairNonSc/masele  ! non screening region
      BHnorm = 1.


      Z = zin
      dz = Z
      Z2 = Z*Z
      emass = masele

      z333=Z**(1./3.)
c        coulmb correction function f(z)
      fz=ccorec(Z)
      ccz=log(Z)/3.+fz
      al183z=log(183./z333)
c        used for bremsung correction at low energies
      bcoef=1.53e-3*sqrt(z/137.)
c       compute radation length in g/cm2 for virutual matter: A = 1 and z
c       This x0g is used to convert the prob. / X0 into mb
c    
      if(Z .lt. 11) then
         call epX01(dz, 1.d0, dx0g)
         x0g = dx0g
      else
         call epX0Old(Z, 1.d0, x0g)
      endif
      temp = epPair(NonScEme, xnorm)/
     *    (  epPairLowE(NonScEme, xnorm) * Z2 * ar02 )
      BHnorm = temp
      end
c     ****************************************************************
c     *                                                              *
c     *  ccorec: coulomb correction function f(z)                    *
c     *                                                              *
c     ****************************************************************
c
c
c        coulomb correction function  a=z/137 ccorec=a**2 sigma(1/((n**
c        +a**2) from n=1 to inf .  approx formula used.
c
c
      real*8 function ccorec(z)
      implicit none
      real*8 z
      real*8 a
c
c
      a=z/137.d0
      a=a*a
      ccorec=( ( (-0.002*a+0.0083)*a-0.0369)*a+0.20206+1./(1.+a)   )*a
      end


