      subroutine epBrLSampP(media, Ee, prob)
      implicit none
#include "Zmedia.h"
      record /epmedia/media
      real*8 Ee
      real*8 prob  ! output probability of Brems / X0

      real*8 ale
c        Ee
c           BremEemin  BremEeCS  BremEemaxL  BremEemaxH
c     ----------------------------------------------------
c                |         |            |          |
c     no brems       p.s        c.s        lpm       lpm by
c                                                    rejection
c

      if(Ee .le. media.cnst.BremEemin) then
         prob= 1.d-40
      else
         ale=log10(Ee)
         call kintp3(media.tbl.BrTXL,
     *   1, media.cnst.BremTXTL, media.cnst.BremLEemin,
     *   media.cnst.BremdETXL, ale, prob) 
      endif
      end
c     ************
      subroutine epBrLSampE(media, Ee, Eg)
c     ************
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
      record /epmedia/media
      real*8 Ee,  Eg

      real*8 u, ale, us, ans

      call rndc(u)
      ale = log10(Ee)
      if(u .gt. media.cnst.BremUminLA) then
c          region A

         call k4ptdi(media.tbl.BrSTLA, 
     *        media.cnst.BremUszLA, 
     *        media.cnst.BremEsize,
     *        media.cnst.BremUszLA, 
     *        media.cnst.BremUminLA,
     *        media.cnst.BremLEemin,
     *        media.cnst.BremdULA,
     *        media.cnst.BremdEL, u,  ale,  ans)  
         Eg= exp( ans*(1.-u))*media.cnst.BremEgmin
      else
c         region B
         us = u**0.25d0

         call k4ptdi(media.tbl.BrSTLB, 
     *        media.cnst.BremUszLB, 
     *        media.cnst.BremEsize,
     *        media.cnst.BremUszLB, 
     *        0.d0,
     *        media.cnst.BremLEemin,
     *        media.cnst.BremdULB,
     *        media.cnst.BremdEL, us,  ale,  ans)  
         Eg = exp(-ans*u)*(Ee - masele)
      endif
      end

