      subroutine epReadTab(io, media)
c
c         read sampling table  created by epCreBrTab and epCrePrTab
c
      implicit none
#include "Zmedia.h"
c
      record /epmedia/media   ! output. data is read and stored here

      integer io  ! input.  logical device

      character*10 rec

c     
c      At the top of table, it is assumed that a copy of
c    basic media table exists.
      call epReadMTbl(io, media)

c        skip to the next to the separator "#-#-#-#-#-"
      do while (.true.)
         read(io, '(a)') rec
         if(rec(1:10) .eq. '#-#-#-#-#-') goto 10
      enddo
 10   continue
c
c          media data  ; this must be computed every time as below
c         so don't read it

c       compute basic const
      call epGetEffZA(media)
c
c      
      call epExpot(media)
c    
c           Sternheimer's consts and to put them in the table
c               to give a parameter value instead of 1d-4,
c               next one is called outside of this routine
c      call epStern(1.d-4, media, media.sh)
c      call epsetUrbn(media,  media.urb)

c      (many or all of these will be reset by reading
c       the table later)
      call epSetSTblCns(media, media.cnst)
      call epSetPhotoE(media, media.pe)  ! this is also not essential
                                         ! to create sampling talbe
c          const used for muon interactions
      call epSetMu(media, media.mu)                                         

c      
c     ------------------------------  brems table 
c          Seltzer table
      call epRdBrSTblS(io, media.cnst, media.tbl)
c
c         GeV region upto LPM  brems
      call epRdBrSTbl1(io, media.cnst, media.tbl)
c        LPM region    
c           brems
      call epRdBrSTblH(io, media.cnst, media.tbl)
c     ------------------------------  pair table 
c                no LPM region
      call epRdPrSTbl1(io, media.cnst, media.tbl)
c                LPM region
      call epRdPrSTblH(io, media.cnst, media.tbl)
c    
c     *********** muon table ************
      call epRdmuTab(io, media)
      end
