c       ***************************************************************
c       *
c       *   kexpot:  compute excitation potential ep (in eV)
c       *     consisting of n different atoms.
c       *
c       ***************************** tested 87.09.19 *****************
c
c /usage/ call kexpot(za, aa, rela, n, zi, ai, ep)
c           za(i) is charge of i-th atom
c           aa(i) the mass #, and rela(i) is the relative weight
c           of them.
c           zi, ai, ep are the output. zi= weighted
c           sum of za, ai  the same for aa.  c
c           see p.r. b vol3 (1971)3681 sternheimer.  c
c     implicit none
c
c
c        example for c3h8
c     integer n
c     real*8 aa, za, rela, zi, ai, ep
c      parameter (n=2)
c      dimension aa(n), za(n), rela(n)
c      data aa/1., 12./, za/1., 6./, rela/8., 3./
c      call kexpot(za, aa, rela, n, zi, ai, ep)
c      write(*,*) ' ep=', ep
c      end
c
        subroutine kexpot(za, aa, rela, n, zi, ai, ep)
       implicit none
       integer n
       real*8 za(n), aa(n), rela(n)
       real*8 zi, ai, ep

       integer i
       real*8 sumli, expi

            ai=0.
            zi=0.
            do   i=1, n
                ai=ai + aa(i)*rela(i)
                zi=zi + za(i)*rela(i)
            enddo
c
            sumli=0.
            do   i=1, n
                if(za(i) .eq. 1) then
                    expi=18.7
                elseif(za(i) .lt. 13.) then
                    expi=13.*za(i)
                else
                    expi=za(i) *( 9.76 + 58.8*za(i)**(-1.19))
                endif
                sumli=sumli + za(i)*rela(i)/zi * log(expi)
            enddo
            ep=exp(sumli)
       end
