c     ****************************************************************
c     *                                                              *
c     * bremr:  used to solve equation for making sampling table     *
c     *         for brems                                            *
c     *                                                              *
c     * pairr: //  for pair                                          *
c     *                                                              *
c     ****************************************************************
c
c
      real*8 function bremr(v)
      implicit none
      real*8 v
c
      real*8 upsi, emain
      common /cbrem/upsi, emain

      real*8 ans

      call totcb(v, 1.d0, ans)
      bremr=ans/upsi-1.
      end
c
c     ***********
      real*8 function pairr(v)
      implicit none
      real*8 v
c
      real*8 upsi, emain
      common /cbrem/upsi, emain

      real*8 ans

      call totcp(v , 1.d0, ans)
      pairr=ans/upsi - 1.
      end
c     *****************
      subroutine totcb(vmin,vmax,ans)
c     *****************
      implicit none
      real*8 vmin, vmax, ans
c
c        integration of bremsung function from vmin to vmax.
c
      real*8 fbrem
      external fbrem
      real*8 v2, v1, ans1
c
      ans=0.
      v2=vmax

      do while(.true.)
         v1=v2/20.
         v1= max(v1, vmin)
         call k16pGaussLeg(fbrem, v1, v2, 16,  ans1)
         ans=ans+ans1
         if(v1.eq.vmin) goto 5
         v2=v1
      enddo
    5 continue
      end
c
c
c
c     ***********
      subroutine totcp(vmin,vmax,ans)
c     ***********
      implicit none
      real*8 vmin, vmax, ans
c
c
c        integralation of pair-cre function
c
c
      real*8 d, vt, fpair, ans1, ans2
      external fpair  
c
      d=(vmax-vmin)/30.
      vt=vmax-d
      call k16pGaussLeg(fpair, vmin, vt, 10, ans1)
      call k16pGaussLeg(fpair, vt, vmax, 10, ans2)
      ans=ans1+ans2
      end
