c     ****************************************************************
c     *                                                              *
c     * epShtern:  to compute coefficient which appear in sternheimers *
c     *          de/dx expression.
c     *        tested                                                 *
c
c /usage/
c
c      See sternheimer, p.r. b vol.3(1971)3681
c
c
c
      subroutine epStern(w0in, media, sh)
      implicit none
#include "Zmedia.h"
#include "Zcode.h"
#include "Zptcl.h"
#include "Zmass.h"

      real*8  w0in  !  input. kinetic energy of knock-on electrons > w0in
                    !         is not taken into account as energy loss( GeV).

      record  /epmedia/media  ! input. 
c                             media.I, media.Z,media.A,
c                             media.rho, media.gasF
c                             epExpot must have been  called.
      record  /sternh/sh    ! output. Sterhnheimer's consts

      record  /ptcl/electron
c
      real*8  hnp, cb, ep
c

      ep = media.I * 1.d9  ! ep in  eV.

      hnp = 28.8 *sqrt(  (media.rho* media.Z/media.A))
      sh.c = -2*log(ep/hnp) - 1.
      sh.a = 0.1536* (media.Z/media.A)
c          log of   (me/ep)*(ep in MeV)
      sh.b = log(masele*1.d9 / ep * 1./(ep/1.d6) )

      cb =- sh.c
      if(media.gasF .eq. 0) then
c               solid 
         if(ep  .lt. 100.) then
            if(cb .lt. 3.681) then
               sh.x0=.2
            else
               sh.x0=.326*cb -1.
            endif
            sh.x1=2.
         else
            if(cb .lt. 5.211) then
               sh.x0=.2
            else
               sh.x0=.326*cb-1.5
            endif
            sh.x1=3.
         endif
      else
c       gas 1atm 0degree
         if(cb .lt. 12.25) then
            sh.x1=4.
            if(cb .lt. 9.75) then
               sh.x0=1.6
            elseif(cb .gt. 11.75) then
               sh.x0=2.0
            else
               sh.x0=.2*cb - .35
            endif
         elseif(cb .lt. 13.804) then
            sh.x1=5.
            sh.x0=2.
         else
            sh.x1=5.
            sh.x0=.326*cb - 2.5
         endif
      endif
      sh.xa=cb/4.606
      sh.sa=4.606*(sh.xa-sh.x0)/(sh.x1-sh.x0)**3
c       some additional const relating to restriced energy loss
      sh.tcut = w0in        ! in GeV 
      sh.w0 = w0in * 1000.  ! in MeV unit. 
      sh.wlg0 = log(sh.w0) 
c         next one is used only when EdepdEdx = f.
c         for compararison with analytical calc.
c         In that case, w0in must be as large as
c         incident particle energy.
      call cmkptc(kelec, regptcl, -1, electron)
      electron.fm.p(4)= 3.162 * masele  
      call epdedxe(sh, electron, media.dEdxatp3m)
      end
