      subroutine eppush(aTrack)
      implicit none
#include  "ZepTrack.h"
#include  "ZepStack.h"

        record /epTrack/ aTrack
        character*80 msg

        integer i
       
        Stack_pos = Stack_pos + 1

        if(Stack_pos .gt. Max_stack_size) then
           write(msg, *) 'stack overflow; max=',Max_stack_size
           call cerrorMsg(msg, 1)
           call cerrorMsg(
     *     'You may enlarge EPMAX_STACK in ZepMaxdef.h',1)
           call cerrorMsg(
     *     'the last 100  stacked tracks are listed on stdout',1)
c
           write(*, *)
     *         ' #  k charge    e            x           z         wz'
           do i = Stack_pos, Stack_pos - 100, -1
              write(*, *) i, Stack(i).p.code, 
     *             Stack(i).p.charge, Stack(i).p.fm.p(4),
     *             Stack(i).pos.x,
     *             Stack(i).pos.y,
     *             Stack(i).w.z
           enddo
           stop 9999
        endif
        Stack(Stack_pos) = aTrack

        end
c       ************************
c                 put 1ptcl in the stack area (for unknown cn)
        subroutine epputTrack(aTrack)
       implicit none
#include "ZepTrack.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"

        record /epTrack/ aTrack  ! input. 

c                 find component # for pos (world coord.)
c              and  set it in aTrack.cn
        call eppos2cn(0,  aTrack,  aTrack.cn)

c         convert pos/w into  l.c
        if(aTrack.cn .le. Det.nct ) then

           call epw2l(aTrack.cn, aTrack.pos, aTrack.pos)
           call epw2ld(aTrack.cn, aTrack.w,  aTrack.w)
           call eppush(aTrack)
        else
           call
     *     cerrorMsg(' epputTrack: ptcl is not in detector', 0)
        endif
      end
c       ************************
c         put 1 ptcl in the stack disk (for unknown cn)
c   
        subroutine epputTrk2(io, aTrack)
       implicit none
#include "ZepTrack.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepStack.h"

       integer io  !  disk file number to stack the track
       record /epTrack/ aTrack  ! input. 

c                 find component # for pos (world coord.)
c              and  set it in aTrack.cn
        call eppos2cn(0,  aTrack,  aTrack.cn)

c         convert pos/w into  l.c
        if(aTrack.cn .le. Det.nct ) then
           call epw2l(aTrack.cn, aTrack.pos, aTrack.pos)
           call epw2ld(aTrack.cn, aTrack.w,  aTrack.w)
           write(io) aTrack
           StackDisk = io
        else
           call
     *     cerrorMsg(' epputTrk2: ptcl is not in detector', 0)
        endif
      end
c      ******************* 
       subroutine epempty
       implicit none
c             clear the stack
#include  "ZepTrack.h"
#include  "ZepStack.h"

           Stack_pos = 0
      end
c     ******************************
      subroutine eppop(aTrack, icon)
      implicit none
c             get 1 particle from the stack area
c              icon=0:  1 ptcl gotten
c                  -1:  no more ptcl
#include  "ZepTrackv.h"
#include  "ZepStack.h"

       
c
       record /epTrack/ aTrack
       integer icon

 10    continue
c         do 876 until (ok)
       if(Stack_pos .gt. 0) then
          icon=0
c                vectors are in local.c
          aTrack = Stack(Stack_pos)     
c                make cosmos ptcl; e may not be informed. g may  not be,
c                                  if IncGp=0.
          call ep2cosPtcl(aTrack.p)

          Stack_pos = Stack_pos - 1
          Cn = aTrack.cn   ! this may be used in epchckE
c              do business when a new component appear
          call epnewComp
          call epchckE(aTrack, icon)

          if(icon .ne. 0) goto 10

       else
          if(StackDisk .gt. 0) then
             read(StackDisk, end=100) aTrack
             call eppush(aTrack)
             goto 10
          endif
 100      continue
          StackDisk = 0
          icon=-1
       endif
 876    continue

        end
c       *************************
        subroutine epgetTrack(n, aTrack, icon)
        implicit none
c            returns a specified track in the stack
c                 
#include  "ZepTrack.h"
#include  "ZepStack.h"
#include  "Zcode.h"
c
        integer n  ! input. track in n-th stack position
        record /epTrack/ aTrack  ! output
        integer icon             ! output. 0--> ok
                                 !        non 0--> no n-th stack
        if(n .ge. 1 .and. n .le. Stack_pos) then                   
           aTrack = Stack(n)
           icon = 0
        else
           icon = 1
        endif
       end
c       *************************
        subroutine epretTrack(n, aTrack, icon)
        implicit none
c            inverse  of epgetTrack
c            returns aTrack  to the n-th pos in the stack
c                 
#include  "ZepTrack.h"
#include  "ZepStack.h"
#include  "Zcode.h"
c
        integer n  ! input. track in n-th stack position
        record /epTrack/ aTrack  ! input. 
        integer icon ! output.  0--> ok
                     !          1--> n is outside of the region
        if(n .ge. 1 .and. n .le. Stack_pos) then                   
           Stack(n)= aTrack 
           icon = 0
        else
           icon = 1
        endif
       end
