#include "Zintmodel.h"
#include "ZcosmosBD.h"
      implicit none
#include  "Zptcl.h"
#include  "Ztrackp.h"
      include "Zprivate.h"

      integer i, nev, j, ntp
      record /ptcl/ w(maxn)

      call init
      do j = 1, nevent
         call gencol(w, ntp)
         call cutbyangle(w, ntp, ntp)
         call sortbyke(w, ntp)  ! sort by kinetic energy 
         if(Trace .gt. 0) then
            call outtrace(j, w, ntp)
         endif
         call outresul(w, ntp)
      enddo
      end

      subroutine init
      implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zmass.h"
#include  "Zmanager.h"
#include  "Zmanagerp.h"
#include  "Ztrackp.h"

      include  "Zprivate.h"
      character*200 input
      character*20 uid
      integer  pjcode, pjsub, pjchg
      integer  tgcode, tgsub, tgchg
      integer klena
      real*8   pjpx, pjpy, pjpz
      real*8   tgpx, tgpy, tgpz
      real*8   roots, s
      external cblkManager
      external cblkEvhnp

      call creadParam(5)

      if(TraceDir .eq. ' ') then
         call cgetLoginN(uid)
         TraceDir = '/tmp/'//uid(1:klena(uid))
      endif

      if(DestEventNo(2) .eq. 0) then
         nevent =abs( DestEventNo(1) )
      else
         nevent = abs( DestEventNo(2) )
      endif
      call cmkSeed(InitRN(1), InitRN)
      call rnd1i(InitRN)        ! random number init.
      call cqUhookr(1, wzmin)
      call cqUhookr(2, wzmax)
      call cqUhookr(3, trackl)
      call cqUhooki(1, outzero)
c       make projectile going +z
      call cqUhookc(1, input) 
      read(input, *) 
     * pjcode, pjsub, pjchg, pjpx, pjpy, pjpz
      call cmkptc(pjcode, pjsub, pjchg,   pj)

      if(pjcode .ne. kgnuc) then
         pjmnum = 1
      else
         pjmnum = pjsub
      endif
      pj.fm.p(1) = pjpx*pjmnum
      pj.fm.p(2) = pjpy*pjmnum
      pj.fm.p(3) = pjpz*pjmnum
      pj.fm.p(4) =
     * sqrt(pj.fm.p(1)**2 + pj.fm.p(2)**2 + pj.fm.p(3)**2
     *       + pj.mass**2)

      call cqUhookc(2, input) 
      read(input, *) 
     * tgcode, tgsub, tgchg, tgpx, tgpy, tgpz
c       make taget (rest of moving -z)
      call cmkptc(tgcode, tgsub, tgchg, tg)
      if(tgcode .ne. kgnuc) then
         tgmnum = 1
      else
         tgmnum = tgsub
      endif
      tg.fm.p(1) = tgpx*tgmnum
      tg.fm.p(2) = tgpy*tgmnum
      tg.fm.p(3) = tgpz*tgmnum
      tg.fm.p(4) =
     *  sqrt(tg.fm.p(1)**2 + tg.fm.p(2)**2 + tg.fm.p(3)**2 
     *   +   tg.mass**2)
c       
      if(tgpx .eq. 0. .and. tgpy .eq. 0. .and.
     *    tgpz .eq. 0.)  then
c          target is at rest; 
         s= 2*pj.fm.p(4)*tg.mass +tg.mass**2 + pj.mass**2
      else
c         by  general formula
         s = (pj.fm.p(4)+tg.fm.p(4))**2 -
     *    (pjpx+tgpx)**2 + (pjpy+tgpy)**2+(pjpz+tgpz)**2
      endif
      roots = sqrt(s)
      write(0, *) ' roots/2=', roots/2
c           get equivalent lab energy; show it as info.
c           boost to target rest system
      call cbst1(1, tg, pj, plab)


      call cfixPrefix('configDummy')
      call csetCosOrEpi('epics')
      if( index( IntModel,'qgsjet1') .ne. 0 ) then
#ifdef QGSJET1
         call qgs01init
         ActiveMdl = 'qgsjet1'
#else
         write(0,*) 'to use qgsjet1,  define it  in Zintmodel.h'
#endif
      elseif(index (IntModel, 'sibyll') .ne. 0 )  then
#ifdef  SIBYLL
         call sibyllinit
         ActiveMdl = 'sibyll'
#else
         write(0,*) 'to use sibyll, define it in Zintmodel.h'
#endif
      else
         call cintModels('epics')
         call cfixModel( plab )
      endif

      write(0, *) 'Active int. model=',ActiveMdl
      write(0, *) ' equiv. lab E=', plab.fm.p(4)
      write(*, '(a)') '#  mulsubKEdir   '
      write(*, '(a)') '#--------------------------------'
      end
      subroutine outresul(a, ntp)
          implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zmass.h"
#include  "Zmanagerp.h"
#include  "Zmanager.h"
#include  "Ztrackp.h"
      include  "Zprivate.h"

      integer ntp
      record /ptcl/ a(ntp)
      integer  i, j
      real*8  p, wx, wy, wz 

      do j = 1, ntp
         i = indx(j)
         p= sqrt( a(i).fm.p(1)**2 + a(i).fm.p(2)**2
     *        +      a(i).fm.p(3)**2 )
         wx = a(i).fm.p(1)/p               
         wy = a(i).fm.p(2)/p               
         wz = a(i).fm.p(3)/p               
         write(*,'(3i3,g14.5,3f17.13)')
     *        a(i).code, a(i).subcode, a(i).charge,
     *        a(i).fm.p(4)-a(i).mass, wx, wy, wz
      enddo
      if(ntp .gt. 0 .or. outzero .eq. 0) then
         write(*, *) 
      endif
      end
      subroutine  gencol(a, ntp)
      implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zevhnv.h"
#include  "Zevhnp.h"
#include  "Zmanagerp.h"
      include "Zprivate.h"
      record /ptcl/  a(*)
c             projectile and target information (both befor
c             and after collision ) in different system.
c
      integer  ntp
      integer j
      integer tZ, tA
      real*8  xs
c     
      if( tg.code .eq. knuc ) then
         tA = 1
      elseif( tg.code .eq. kgnuc ) then
         tA = tg.subcode
      else
         write(0,*) ' target code=', tg.code, 'invalid'
         stop 9999
      endif
      tZ =  tg.charge
      if(ActiveMdl .eq. 'qgsjet2' ) then
         call cxsecQGS(plab, tA, xs)
      endif
      if(ActiveMdl .eq. 'qgsjet1') then
#ifdef QGSJET1
         call qgs01event(plab, tA, tZ, a, ntp)
#endif
      elseif(ActiveMdl .eq. 'sibyll') then
#ifdef SIBYLL
         call sibyllevent(plab, tA, tZ, a, ntp)
#endif
      else
         call chAcol(plab, tA, tZ,  a, ntp)
      endif
      do j = 1, ntp
c               boost to  target mooving system
         call cibst1(j, tg,  a(j), a(j))
      enddo
      end


      subroutine cutbyangle(a, ntp0,  ntp)
      implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zevhnv.h"
#include  "Zevhnp.h"
#include  "Zmanagerp.h"
      include "Zprivate.h"
      record /ptcl/  a(*)
      integer ntp0 ! input. number of ptcls. in a
      integer ntp  ! output. could be the same as ntp0
      integer j 
      integer  i
      real*8 p, wz
      j = 0
      do i = 1, ntp0
         p = a(i).fm.p(1)**2 + a(i).fm.p(2)**2 +
     *       a(i).fm.p(3)**2
         p = sqrt(p)
         wz = a(i).fm.p(3)/p 
         if( wz .ge. wzmin .and. wz .le. wzmax ) then
            j = j + 1
            a(j)=a(i)
         endif
      enddo
      ntp = j
      end
      subroutine sortbyke(a, ntp)
      implicit none
#include  "Zptcl.h"
#include  "Zcode.h"

      include "Zprivate.h"
      integer  ntp
      record /ptcl/  a(*)
c             projectile and target information (both befor
c             and after collision ) in different system.
c

      integer  i
      do i = 1, ntp
         ke(i) = a(i).fm.p(4) - a(i).mass
      enddo
      call kqsortd(ke, indx, ntp)
      call ksortinv(indx, ntp)  
c       ke( indx(1) ) is the highest energy
      end
      subroutine outtrace(nev, a, ntp)
          implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
#include  "Zmass.h"
#include  "Zmanagerp.h"
#include  "Zmanager.h"
#include  "Ztrackp.h"
      include  "Zprivate.h"

      integer ntp, nev
      record /ptcl/ a(ntp)
      integer  i, j, leng, icon, klena
      real*8  p, wx, wy, wz 
      character*100  tracefile

      write(tracefile, *) TraceDir(1:klena(TraceDir))//'/trace', nev
      call kseblk(tracefile, ' ', leng)
      call copenfw(TraceDev, tracefile(1:leng), icon)
      if(icon .ne. 0) then
         call cerrorMsg('tracefile could not be opened',0)
      endif
      do j = 1, ntp
         i = indx(j)
         p= sqrt( a(i).fm.p(1)**2 + a(i).fm.p(2)**2
     *        +      a(i).fm.p(3)**2 )
         wx = a(i).fm.p(1)/p               
         wy = a(i).fm.p(2)/p               
         wz = a(i).fm.p(3)/p               
         write(TraceDev,'(a, i3, g14.4, i3, i2)') 
     *      '0    0    0 ' ,
     *      a(i).code,  a(i).fm.p(4) - a(i).mass, a(i).charge,
     *      0
         write(TraceDev, '(3g14.5, i3, g14.4, i3, g14.4)' )
     *       wx*trackl, wy*trackl, wz*trackl,
     *      a(i).code,  a(i).fm.p(4) - a(i).mass, a(i).charge,
     *      trackl 
         write(TraceDev, *) 
         write(TraceDev, *) 
      enddo
      close(TraceDev)
      end

