      real*8 function epBrem(Eeme, x)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zbpfunc.h"
c          This is by Tsai
c          From table B.4 of  Tsai (Rev. Mod. Phys.vol.46' 74).
c          compute differentical bremstralhng cross-section
c          at low energies where no LPM effect exists.
c        Before calling this, epBPZaprt must have been called
c        to give the Z
c        epBrem(Egme,x)= dsigma/dx = mb
c           alpha * r0**2 = 0.579 mb
c
      real*8 Eeme ! input  Ee/me, i.e,  gamma factor 
      real*8 x    ! input  Eg/Ee.    x <= 1.-me/Ee

      real*8 phi1, phi2, psi1, psi2
      real*8 gamma,  epsil

      delta = x/(2*(1.-x))/Eeme
      gamma = 200.*delta/Z13
      epsil = 200.*delta/Z23


      call epBPfc(gamma, epsil, phi1, phi2, psi1, psi2)
      epBrem = ( (4.d0/3.d0 *(1.-x) + x**2) *
     * ( Z**2*(phi1-4*cf) + Z*psi1 )
     *  + 2.d0/3.d0 *(1-x) *
     * (Z**2*(phi1-phi2) + Z*(psi1-psi2)))/x

      epBrem = max(epBrem, 0.d0)
c          To mb, alpha r0**2 = 0.579 must be multiplied
      epBrem = epBrem* ar02
      end
c     *******************************
      real*8 function epPair(Egme, x)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zbpfunc.h"
c          compute differentical pair creation cross-section
c          at low energies where no LPM effect exists.
c        Before calling this, epBPZaprt must have been called
c        to give the Z
c        epPair = dsigma/dx in mb
c
      real*8 Egme ! input  Eg/me
      real*8 x    ! input  Ee/Eg.   me/Eg =< x <= 1.-me/Eg
      
      real*8 phi1, phi2, psi1, psi2
      real*8 gamma,  epsil
      real*8 epPairLowE

      delta = 1./(2*x*(1.-x))/Egme
      gamma = 200.*delta/Z13
      epsil = 200.*delta/Z23
      
      if(Egme .ge. NonScEme) then

         call epBPfc(gamma, epsil, phi1, phi2, psi1, psi2)
         epPair = max(  ( (4.d0/3.d0  *(x -1.)*x + 1) *
     *   (Z**2*(phi1-4*cf) + Z*psi1)
     *
     *    - 2.d0/3.d0 *x *(1-x)* 
     *   (Z**2* (phi1-phi2) + Z*(psi1 -psi2)) ), 0.d0)
c             alpha *r0**2 epPair = 0,579 epPair
         epPair = epPair * ar02 !  in mb
      else
c           B.H's original formula down to threshold
         epPair = epPairLowE(Egme, x)
         epPair = epPair * BHnorm * Z**2 * ar02
      endif
      end

      
      subroutine epBPfc(g, epsil, phi1, phi2, psi1, psi2)
c
c       compute phi1- 4ln(Z)/3, phi2-4ln(Z)/3
c               psi1- 8ln(Z)/3, psi2-8ln(Z)/3
      implicit none
#include "Zbpfunc.h"
      real*8 g ! input.  gamma = 200.detla/Z13
      real*8 epsil ! input  
      real*8 phi1, phi2, psi1, psi2

 
 
      if(Z .le. 2) then 
         call epBPfc1(g, phi1, phi2, psi1, psi2)
      elseif(Z .le. 4) then
         call epBPfc2(phi1, phi2, psi1, psi2)
      else
         call epBPfc3(g, epsil, phi1, phi2, psi1, psi2)
      endif
      end
c     ********************
      subroutine epBPfc1(g, phi1, phi2, psi1, psi2)
c     ********************
c        for H, He
      implicit none
#include "Zbpfunc.h"
      real*8 g, phi1, phi2, psi1, psi2

      real*8 eta, c, arctanc, ln1, lnc1, lnc2
      real*8 alpha, kSpence

      parameter (alpha = 1.d0/137.d0)

      if(Z .eq. 1) then
         eta = 1.
      else
         eta = 1.6875
      endif

      c = g*Z13/(400.d0*alpha*eta)
      arctanc = c* atan(1./c)
      ln1 = 4.*log(1./(2.*eta*alpha))
      lnc1 = 2*log(1.+c**2)
      lnc2 = c**2 * log(1.+c**(-2))

      phi1 = ln1 + 13.0/3.d0 - lnc1 - 13.d0/2.*arctanc +
     *      1./(6.*(1+1./c**2))
      phi2 =ln1 + 11.d0/3.d0 - lnc1 + 25.*c**2* 
     *       (1.-arctanc) - 14.*lnc2
      psi1 = ln1 + 23.d0/3d0 - lnc1 - 17.5*arctanc + 
     *  8*lnc2 - 1./(6.*(1+1./c**2))
      psi2 = ln1 + 21.d0/3d0 -lnc1 - 105.0*c**2*(1-arctanc) +
     *      50.0* lnc2 - 24.0*c**2 *
     *      ( -2*log(c)*log(1 + 1/c/c) +
     *        kSpence((1.d0+1/c/c))  - kSpence(1.d0))
      end
c     ********************
      subroutine epBPfc2(phi1, phi2, psi1, psi2)
c     ********************
c        for Z=3, 4
      implicit none
#include "Zbpfunc.h"
      real*8 phi1, phi2, psi1, psi2
      real*8 b, bp, lnaz, lnb, arctanb, arctanbp
      real*8 lnb2, lnbp, lnbp2, lnazp

      b = ame * delta
      bp = apme * delta
      lnaz =2* log(ame*Z13)
      lnazp = 2* log(apme*Z23)
      lnb = log(1. + b*b)
      lnb2 = log(1 + 1./b/b)
      lnbp = log(1. + bp*bp)
      lnbp2 = log(1 + 1./bp/bp)
      arctanb = atan(1./b)
      arctanbp = atan(1./bp)

      phi1 = 2.*(1. + lnaz) - 2* lnb - 4*b*arctanb
     *  - lnZ43

      phi2 = 2.*(2.d0/3.d0 + lnaz) - 2* lnb + 
     * 8*b*b*(1.-b*arctanb - 0.75*lnb2) -lnZ43

      psi1 = 2.*(1. + lnazp) - 2 * lnbp - 4*bp*arctanbp -
     *   lnZ83

      psi2 = 2.*(2.d0/3.d0 + lnazp) - 2*lnbp  + 
     * 8*bp*bp*(1.-bp*arctanbp - 0.75*lnbp2)
     * - lnZ83
      end

c     ********************
      subroutine epBPfc3(g, epsi, phi1, phi2, psi1, psi2)
c     ********************
c        for Z>=5
      implicit none
#include "Zbpfunc.h"
      real*8 g, epsi
      real*8 phi1, phi2, psi1, psi2

      phi1 = 20.863 - 2*log(1+(0.55846*g)**2) -
     *  4*(1 - 0.6* exp(-0.9*g) - 0.4*exp(-1.5*g))
     *  - lnZ43

      phi2 = phi1 - 2.d0/3.d0/(1+(6.5+ 6*g)*g )

      psi1 = 28.340 - 2*log(1 + (3.621*epsi)**2) -
     * 4*(1-0.7*exp(-8.0*epsi) - 0.3*exp(-29.2*epsi))
     *  - lnZ83
      psi2 = psi1 - 2.d0/3.d0/(1+(40 + 400*epsi)*epsi )

      end


      subroutine epBPZpart(media, zin)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zbpfunc.h"
#include "Zmedia.h"
#include "Zmass.h"

c        compute Z  part of the pair and brems diff. 
c        corss-section (single Atom)
      record /epmedia/media
      real*8 zin


c
c       The computed results are put in the common block
c       /bpzpart/

      real*8 zd
      real*8 temp, xnorm, epPair, epPairLowE, ynorm
c        y = (Ee-me)/(Eg-2me)
      data ynorm/0.9d0/

      NonScEme = media.cnst.PairNonSc/masele  ! non screening region
      BHnorm = 1.
      xnorm = ynorm * (1.-2/NonScEme) + 1./NonScEme

      Z =  zin
      zd = Z
      
      Z13 = zd**(1.d0/3.d0)
      Z23 = Z13**2
      call epGetTFM(Z)
      lnZ43 = log(zd)*4.d0/3.d0
      lnZ83 = 2* lnZ43
      temp = epPair(NonScEme, xnorm)/
     *    (  epPairLowE(NonScEme, xnorm) * Z**2 * ar02 )
      BHnorm = temp

      end


      subroutine epGetTFM(zin)
c
c        get Thomas-Fermi-Moliere atomic factor a, a'
c 
c        From table B.4 of  Tsai (Rev. Mod. Phys.vol.46' 74)
c        a*me, and a'*me are obtained 
c
c    
      implicit none
#include "Zbpfunc.h"
      

      real*8 zin
      real*8 sz, epCoulombC

      Z = zin

      if(Z .eq. 1.) then

         ame = 122.8
         apme = 282.4

      elseif( Z .eq. 2.) then

         ame = 90.8/Z13
         apme = 265.8/Z23

      elseif( Z .eq.3.) then

         ame = 100.0/Z13
         apme = 418.6/Z23

      elseif( Z .eq. 4.) then
         
         ame = 106.0/Z13
         apme = 571.4/Z23

      else
c         for all  Z>=5
         ame = 111.7 / Z13
         apme = 724.2 / Z23
      endif
c        Coulomb correction fucntion
      sz =( Z/137.d0 ) **2
      cf = epCoulombC(sz)
      end

