#include "../main.f"
      include 'sqfiber.f'
      include 'ZblockD.h'
c        **************************************************************
c        *
c        * ephook:  collection of subroutines which should be managed by
c        *      the user. 

c        **************************************************************
c         
c
c   +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c   +  Note that besides the subroutines listed below in this module,
c   +  the following inquirey subroutines are available for use:
c   +
c   +  call epqFirstI(pos);
c         #include "ZepPos.h"
c         record /epPos/ pos ; output.( pos.x, pos.y, pos.z )
c                              First interaction position. If
c
c   +  call epqmat(i, mat): i; integer input.  component number
c   +                       mat: characeter*8 output.  mediea
c   +                            such as 'Si' of  the i-th component.
c   +  call epqstn(n):  n; integer output.  get current stack depth
c
c   +  call epqsTrack(n, sTrack): inquire stacked track.
c                    n; integer input. stack depth
c                   record /epTrack/ sTrack. Energy=0 means n is invalid
c   +  call epqevn(nev):  nev; integer output. Event number already created
c                              in this run.
c   +  call epqinc(aTrack)
c                 inquire incident particle.
c   +         record /epTrack/ aTrack
c   +             if multiple particles are incident, the first one is obtained

c   +  call epqncp(ncomp) inquire the total number of components
c                   integer ncomp  output.
c
c   +  call sqtevn(nev): nev; integer output.  total number of events
c   +                                           created so far.
c   +
c   +  call sqcont(icon):  icon; integer output. 
c   +                            icon == 0 ==>  first job
c   +                            icon != 0 ==>  continued job
c   +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c        
c
c       *****************************
c       *        At this momemet, all the system level initialization 
c       *   has been ended.  Do your own initialization for all the
c       *   events.
c
        subroutine uiaev
        implicit none
        character*8 uid
        character*64  file
        integer klena

c         open file for putting trace info. 
c         In your normal job, you should not take tarce info,
c         otherwise, you need lot of disk space and computation time.
c
        call cgetLoginN(uid)  ! cosmos function
c        file = '/tmp/' // uid(1:klena(uid))// '/trace1'
c        open(21, file=file)

        end

c       **************************************************
c       *  At this moment, all the system level initialization for
c       *  an event has been ended.  Do your own initializaiton for
c       *  the event.   Note, at this moment, no incident particle
c       *  has been made yet.
c       *
        subroutine ui1ev
        implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
        include 'Ztest.h'
        integer i, j
        character*200 msg

        call epqncp(Ncomp)   ! inquire the number of components
c
c          consts for fiber are given by block data.
c     some additional changes are make here
c(((((((((((
c          Det.cmp(Det.nct).vol(boxa) = abc.x
c                should be written as
c          Volat(Det.cmp(Det.nct).vol+boxa) = abc.x
c)))))))))))
        LengX(1)=Volat(Det.cmp(1).vol+boxa)   ! top trigger scinti x length
        LengZ(1)=Volat(Det.cmp(1).vol+boxc)   ! its thickness
        LengX(trig2)=Volat(Det.cmp(trig2).vol+boxa) ! 2nd trig. scinti
        LengZ(trig2) =Volat(Det.cmp(trig2).vol+boxc) ! thickness
c               BGO
        do i = bgo1, Ncomp
           LengX(i) = Volat(Det.cmp(i).vol+boxc)
           LengZ(i) = Volat(Det.cmp(i).vol+boxc)
        enddo
c           set up NoOfBlocks in each layer
        do i = 1, Ncomp
           if(Det.cmp(i).matter .eq. 'SCIN' .and. 
     *       Volat(Det.cmp(i).vol+boxc) .lt. 0.3) then
c                should be scifi
              CalibG(i) = Calibscifi
              NoOfBlocks(i) = maxblock
           elseif( Det.cmp(i).matter .eq. 'SCIN') then
c                   trigger scinti
              NoOfBlocks(i) = 1
              CalibG(i) = Calibscin
           elseif( Det.cmp(i).matter .eq. 'BGO') then
              NoOfBlocks(i) = bgoblock
              CalibG(i) = Calibbgo
           elseif( Det.cmp(i).matter .eq. 'Pb') then
              NoOfBlocks(i) = 1
           else
              write(msg, *) ' error of media', Det.cmp(i).matter,
     *       '  for ',i,'th comp'
              call cerrorMsg(msg, 0)
           endif

        enddo
        do i = 1,  Ncomp
           do j = 1,  NoOfBlocks(i)
              Eloss(j,i) = 0.
           enddo
        enddo

        end
c       **************************************************
c       *  If the default incident particle treatment does not
c       *  suffice you, make your own incident particle here.
c       * (you can  make even multiple particles as  the incident).
c       *  If default is ok, don't touch this.
        subroutine usetip(icon)
        implicit none
        integer icon
c            
c        If you make the incident yourself.
c             make icon = 0 on return, 
c             ^^^^^^^^^^^^^^^^^^^^^^^^
c        To make the incident, you may make the next call
c           as many times as you want.
c 
c        call epputTrack(aTrack)
c           record /epTrack/ aTrack
c              
            icon=1
        end
        subroutine uafi1ev
c          this is called when all the initialization for
c         an event has been ended.  (incident particle has
c         set).  Do your own final init. for the event
        end

c       ***********************************************
c       *   This is called 
c       *     when a charged particle loses
c       *     energy in a component for which you have specifed to do
c       *     energy loss counting.
c       * Or
c       *     when a photon energy becomes lower than a given minimum
c       *     energy.  It's your decision whether you discard such 
c       *     a photon or count as energy lost here.
c  
        subroutine userde(info, aTrack, Move, media)
        implicit none
#include "ZepTrack.h"
#include "Zmove.h"
#include "Zmedia.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"

c          next is needed if you want to judge particle code.
c  #include "Zcode.h"     


        integer info             ! input. 0--> particle is still active.
                                 !        1--> particle is dying.
                                 !        (i.e, after moving Move.dl, it 
                                 !         dies) .
        record /epTrack/ aTrack  ! input. current track. before it is moved.
        record /epmove/  Move      ! input. containes info of moved track.
c                                ! output. You have to set Move.Abort
c         Move.Abort = 0 if you want to continue the simulation of
c                           this event normally.
c                    = 1 if you want to discard this particle
c                        For example, you may use this if you use
c                        formula for further development due to this
c                        particle 
c                    = 2 if you want to abort the generation of 
c                           this event, but want to execute ue1ev.
c                    = 3 if you want to abort the genration of 
c                         this event, and skip ue1ev.
        record /epmedia/media
      include 'Ztest.h'
      character*200  msg
      real*8 x, y, z, wx, wy, wz, z1, x1
      record /epPos/ firstpos
      record /epPos/ wpos 
      record /epDirec/ ww 
      integer cn

      call epqFirstI(firstpos)  ! fisrt int. pos.
      if(firstpos.z .gt. Zcut) then
         Move.Abort = 2
         return
      endif
      cn = aTrack.cn
      if(Move.dEeff .gt. 0.) then
         if(NoOfBlocks(cn) .eq. 1) then
            Eloss(1, cn) = Eloss(1, cn) +
     *          Move.dEeff
c     *          Move.dEeff * exp(-(FiberL - y)*InvAttenL)
         else
            if(CclorSq(cn) .eq. 2) then
c                 square fiber or CSI
               if(XyDirec(cn) .eq. 1) then
c                  x-direction
                  x1 = Det.cmp(cn).orgx + LengX(cn)/2
               elseif(XyDirec(cn) .eq. 2 ) then
c                          y direction
                  x1 = Det.cmp(cn).orgy + LengX(cn)/2
               else
                  write(msg,*) ' error of XyDirec or.. cn=',cn
                  call cerrorMsg(msg, 0)
               endif
               call epl2w(aTrack.cn, aTrack.pos, wpos)
               call epl2wd(aTrack.cn, aTrack.w, ww)

               x = wpos.x
               y = wpos.y
               z = wpos.z
               wx = ww.x
               wy = ww.y
               wz = ww.z
               z1 = Det.cmp(cn).orgz + LengZ(cn)/2
               if(XyDirec(cn) .eq. 1) then
                  call fiberCountSq(x1, z1, LengX(cn),
     *            LengX(cn), Volat(Det.cmp(cn).vol+boxc),
     *            NoOfBlocks(cn),
     *            x, y, z, wx, wy, wz, Move.dEeff, Move.dl,
     *            InvAttenL, FiberL, Eloss(1, cn))
               else
                  call fiberCountSq(x1, z1, LengX(cn),
     *            LengX(cn), Volat(Det.cmp(cn).vol+boxc),
     *            NoOfBlocks(cn),
     *            y, x, z, wy, wx, wz, Move.dE, Move.dl,
     *            InvAttenL, FiberL, Eloss(1, cn))
                endif
             else
                write(msg,*)
     *             'now only squrare fiber is supported'
                call cerrorMsg(msg, 0)
            endif
         endif
      endif

      Move.Abort = 0

c          You can use the following info.
c   ================================================================
c     aTrack.p         : the same particle record as Cosmos, i.e.,
c     aTrack.p.fm.p(1), p(2), p(3): momentum of the particle in GeV
c     aTrack.p.fm.p(4)            : total energy of    //
c     aTrack.p.mass               : mass  //                 
c     aTrack.p.code               : particle code 
c     aTrack.p.subcode            : particle subcode 
c     aTrack.p.charge             : charge  //.
c     aTrack.pos.x, y, z          : local coordinate of the particle in cm
c                                   If you need world coordinate, use
c                          call epl2w(aTrack.cn, aTrack.pos, wpos) 
c                    where
c                   record /epPos/ wpos is the output  world coordinate
c     aTrack.w.x, y, z            : direction cosines in the local coordinate
c                                   If you need world coordinate values, use
c                          call epl2wd(aTrack.cn, aTrack.w, ww)     
c                    where
c                   record /epDirec/ ww is the output  values in world coord.
c
c     aTrack.t                    : time in sum of (cm/beta) 
c     aTrack.wgt                  : weight of the particle when thinning is
c                                   done (normall 1.0)
c     aTrack.cn                   : component number
c
c     Move.Track      :   Info of moved track.
c     Move.boundary   :   Component boundary position when the particle crosses
c                         the boundary. (Move.Cross =T)
c                         Move.boundary.x, y, z. in cm. 
c     Move.proc       :   If the particle is going to interact, the process
c                            name is set. proc= one of
c                        'brem': bremstralhng
c                        'knoc': knock on (bhabha or moller scattering)
c                                other heavy particle knock-on
c                        'anih': positron anihilation
c                        'pair' : pair creation
c                        'comp' : compton scattering
c                        'phot' : photo electric effect
c                        'photop': photo-hadron production
c                        'coll'  : hadron's nuclear interaction
c                        'decay' : decay 
c                        '    '  : no interaction yet.
c    Move.dl          :  Path length in cm
c    Move.dE          :  Energy loss during dl. in GeV
c    Move.dEeff       :  Effective energy loss (use this for counting) GeV
c    Move.dEion       :  Energy loss due to ionization loss (GeV)
c    Move.dx          :  path length in g/cm^2
c    Move.dt          :  path length in r.l
c    Move.Cross       :  Becomes T if the ptcl crosses the boundary.
c    Move.Trunc       :  Becomes T if the ptcl track is truncated.
c    Move.Abort       :  must be set by the user.
c    
c    If you want to use a particle code, like,
c        if(aTrack.p.code .eq.  kphoton) ...
c    You have to uncomment Zcode.h above; they are the same as
c    Cosmos. Some of popular ones are:
c         kphoton:  photon             kelec  :  electron
c         kmuon  :  muon               kpion  :  pion
c         kkaon  :  kaon               knuc   :  nucleon
c         kneue  :  electron neutrino  kneumu :  muon neutrino
c         kalfa  :  He                 klibe  :  LiBeB group
c         kcno   :  CNO   group        khvy   :  Na/Mg/Si group
c         kvhvy  :  S/Cl/Ar group      kiron  :  Fe group
c         kdmes  :  D  meson           keta   :  eta  meson
c    Subcode may sometimes be needed:
c         regptcl:  particle           antip  : anti-particle
c         k0s    :  k0short            k0l    : k0 long
c 
        end
c       ************************************************
c       *  This is called when a particle passes the boundary
c       *  of a component for which you have specifed to
c       *  count particle nubmer.
c
        subroutine userbd(info, aTrack, Move, media) 
        implicit none
#include "ZepTrack.h"
#include "Zmove.h"
#include "Zmedia.h"

c          next is needed if you want to judge particle code.
c  #include "Zcode.h"     

        integer info              ! 0--> ptcl is exiting to void
                                  ! <0 --> ptcl is exiting to |info| comp.
                                  ! >0 --> ptcl is entering from info comp.
        record /epTrack/aTrack    ! input. Current track before it is moved.
                                  !  If info <=0, the track position is 
                                  !  somewhere inside the component from which
                                  !  the track is existing.
                                  !  If info >0, aTrack.pos is the position 
                                  !  just before exiting the prvious component
        record /epmove/ Move        ! input/output. 
                                  ! Move.Track is the track
                                  ! infomation of the current particle
                                  ! moved to a new position.
                                  ! Say, Move.Track.cn is the  current
                                  ! comp. number.  For other details,
                                  ! see userde.
c
c                      comp.1    comp.2
c          info<0    |  *-----x|          |        
c                                                   * is aTrack.pos
c                                                   x is Move.Track.pos
c          info>0    |        *|x         |       
c  
        record /epmedia/media       ! input.

        Move.Abort = 0
        end
c       **************************************************
c       *  This is called when all the system level "end process"
c       *  for the event has been ended.  Do your own end process
c       *  for the event.
c       *
        subroutine ue1ev
        implicit none

#include "ZepTrack.h"
        include 'Ztest.h'

        integer i, j
        record /epPos/ firstpos
        record /epTrack/ inci

        call epqFirstI(firstpos)
        call epqinc(inci)
c            if no collision, no output.        
ccc        if(firstpos.z .gt. 0. ) then
           call epqevn(i)
           write(*, *)  i, inci.p.code, inci.p.charge,
     *     sngl(inci.p.fm.p(4)),
     *     sngl(inci.w.x), sngl(inci.w.y), sngl(inci.w.z),
     *     sngl(inci.pos.x), sngl(inci.pos.y), sngl(inci.pos.z)
           do i = 1, Ncomp
              do j =1, NoOfBlocks(i)
                 if(Eloss(j,i) .gt. 0.) then
                    Eloss(j,i) = Eloss(j,i)/CalibG(i)
ccc                    write(*, *) i, j, sngl(Eloss(j,i))
                 endif
              enddo
           enddo
ccc           write(*,*) 0, 0, 0.
ccc        endif
        end
c       *************************************************
c       *  This is called when all the system level "end process"
c       * for all the events has been  ended. Do your own end
c       * process for the events

      subroutine ueaev
      implicit none
      end

