      subroutine epPrLSampP(media, Eg, prob)
      implicit none
#include "Zmedia.h"
      record /epmedia/media
      real*8 Eg
      real*8 prob  ! output probability of Pair / X0

      real*8 ale

      if(Eg .lt. media.cnst.PairEgmin) then
         prob= 1.d-40
      else
         ale=log10(Eg)
         call kintp3(media.tbl.PrTXL,
     *   1, media.cnst.PairTXTL, media.cnst.PairLEgmin,
     *   media.cnst.PairdETXL, ale, prob) 
      endif
      end
c     ************
      subroutine epPrLSampE(media, Eg, Ee)
c     ************
c          samples higher energy pair electron
      implicit none
#include "Zmedia.h"
      record /epmedia/media
      real*8 Ee,  Eg

      real*8 u, ale, us, ans, ex

      call rndc(u)
      ale = log10(Eg)
      if(u .gt. media.cnst.PairUminLA) then
c          region A
         call k4ptdi(media.tbl.PrSTLA, 
     *        media.cnst.PairUszLA, 
     *        media.cnst.PairEsize,
     *        media.cnst.PairUszLA, 
     *        media.cnst.PairUminLA,
     *        media.cnst.PairLEgmin,
     *        media.cnst.PairdULA,
     *        media.cnst.PairdELA, u,  ale,  ans)  
         Ee = (ans*(1.-u) + 0.5d0)*Eg
      else
c         region B
         us = u**0.25d0
         ex = sqrt(ale - media.cnst.PairLEgmin)
         
         call k4ptdi(media.tbl.PrSTLB, 
     *        media.cnst.PairUszLB, 
     *        media.cnst.PairEsize,
     *        media.cnst.PairUszLB, 
     *        0.d0,
     *        0.d0,
     *        media.cnst.PairdULB,
     *        media.cnst.PairdELB, us,  ex,  ans)  
         Ee = ans* Eg
      endif
      end

