      implicit none
c
c         to write data needed to draw brems function at arbitrary energies
c
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      character*50  file
      integer nerg
      integer io, i, norm, ie
      real*8  Ee, x, f, epBrgenex, xmax
      real*8  xmin, tprob

      parameter (nerg=10)
      real*8  EeA(nerg)

      io = 10
      call cerrorMsg(' ', 1)
      call cerrorMsg('1) In unit of / r.l (1)',  1)
      call cerrorMsg('2) In unit of mb/ingredient', 1) 
      call cerrorMsg('3) In unit of /(g/cm^2)', 1)
      call cerrorMsg('4) In unit of /cm', 1)
      call cerrorMsg(
     * '5) Area-normalization '//
     * ' for comparison with M.C data such as k vs xdN/dx/Nt or '//
     * ' k vs dN/dx/Nt',   1)
      
      norm = 1
      read(*, *)  norm
      do i = 1, nerg
         EeA(i) = 0.
      enddo
      call cerrorMsg(
     *  "Enter a basic media file path ( such as"//
     *    "  '../../Data/BaseM/Pb')",  1)
      file ='../../Data/BaseM/Pb'
      read(*, *) file
      call cerrorMsg(
     * '  Energy of electrons in (GeV) upto 10 (with /)', 1)
      read(*, *) EeA

      open(io, file=file, action ='read')
      call epBPgeneini(io, media)

      do ie = 1, nerg
         Ee = EeA(ie)
         Eeme = Ee/masele
         if(Ee .eq. 0.) goto 10
         if(Ee .le. media.cnst.BrEemaxS) then
            xmin = media.cnst.BrEgminS/(Ee-masele)
         else
            xmin = media.cnst.BremEgmin/Ee
         endif
         xmax = 1. - masele/Ee
         if(norm .eq. 5) then
            call epBrgeneTX(xmin, xmax, tprob)
         else
            tprob =  1.
         endif

         x = xmin
             
         do while (x .lt.  xmax)
            f = epBrgenex(x)
            if(norm .eq. 5) then
               f = f/tprob
            else
c               if(Ee .le.a media.cnst.BremEemaxL) then
                  if(norm .eq. 1) then 
                     f = f * media.mbtoPX0 ! prob/X0
                  elseif( norm .eq.  2) then
c                    nothing to do  . in mb
                  elseif(norm .eq.  3) then
                     f = f* media.mbtoPgrm
                  elseif(norm .eq. 4) then
                     f = f* media.mbtoPcm
                  else
                     call cerrorMsg('input error',0)
                  endif
            endif
c
            if(f .gt. 0.) then
               write(*, *)
     *         sngl(x*Ee/(Ee-masele)), sngl(f*x),  sngl(f), sngl(Ee)
            endif
            if(x .gt.  xmax-0.5d0 ) then
               x = x + 1.d-3
            else
               x = x * 10.**0.02
            endif
         enddo
         write(*,*)
      enddo
 10   continue
      end
