      implicit none
      integer n
       parameter (n=2)
       real*8  za, aa, rela, rho
       integer jgas
       real*8 a, b, c, x0, x1, xa, sa

       dimension za(n), aa(n), rela(n)
       data rho/4.51/     jgas/0/
       data za/55., 53./
       data aa/132.9, 126.9/
       data rela/1., 1./
       call  preded(jgas, za, aa, rela, n, rho,
     * a, b, c, x0, x1, xa, sa)
       write(*,*) ' a, b, c, x0, x1, xa, sa=', a, b, c, x0, x1, xa,
     * sa
       write(10,*) a
       write(10,*) b
       write(10,*) c
       write(10,*) x0
       write(10,*) x1
       write(10,*) sa
       end
c     ****************************************************************
c     *                                                              *
c     * prededx: to compute coefficient which appear in sternheimers *
c     *          de/dx expression.
c     *                                                              *
c
c /usage/
c       call preded(jgas, za, aa, rela, n, rho,
c    *  a, b, c, x0, x1, xa, sa)
c
c      jgas: 0===> solid else gas
c       rho: density in g/cm**3.
c       for za,aa,rela,n, see kexpot.
c       a to sa are output. see sternheimer, p.r. b vol.3(1971)3681
c
c
c          example for ch4
c       parameter (n=2)
c       dimension za(n), aa(n), rela(n)
c       data rho/1.032/
c       data za/1., 6./, aa/1., 12./, rela/4.,  1./
c       call  preded(0,    za, aa, rela, n, rho,
c    *  a, b, c, x0, x1, xa, sa)
c       write(*,*) ' a, b, c, x0, x1, xa, sa=', a, b, c, x0, x1, xa,
c    *  sa
c       end
c
        subroutine preded(jgas, za, aa, rela, n, rho,
     *  a, b, c, x0, x1, xa, sa)
       implicit none
       integer n, jgas
       real*8  za(n), aa(n), rela(n), rho, a, b, c, x0, x1, xa, sa
c
c
          real*8 emass
          real*8  hnp, cb,  ai, ep, zi
c
          parameter (emass=.511e6)

c              compute ionization potential in ev
            call kexpot(za, aa, rela, n, zi, ai, ep)
            hnp=28.8 *sqrt(  (rho*zi/ai))
            c=-2*log(ep/hnp) - 1.
            a= 0.1536* (zi/ai)
            b=log(emass*1.e6/ep**2)
            cb=-c
            if(jgas .eq. 0) then
c               solid or liquid
                if(ep  .lt. 100.) then
                    if(cb .lt. 3.681) then
                        x0=.2
                    else
                        x0=.326*cb -1.
                    endif
                    x1=2.
                else
                    if(cb .lt. 5.211) then
                        x0=.2
                    else
                        x0=.326*cb-1.5
                    endif
                    x1=3.
                endif
            else
c                   gas 1atm 0degree
                if(cb .lt. 12.25) then
                    x1=4.
                    if(cb .lt. 9.75) then
                        x0=1.6
                    elseif(cb .gt. 11.75) then
                        x0=2.0
                    else
                        x0=.2*cb - .35
                    endif
                elseif(cb .lt. 13.804) then
                    x1=5.
                    x0=2.
                else
                    x1=5.
                    x0=.326*cb - 2.5
                endif
            endif
            xa=cb/4.606
            sa=4.606*(xa-x0)/(x1-x0)**3
        end
