      subroutine epCreMuPTab(mediain, cnst)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZmuBPNgene.h"

c     *                                                             
c     *       create sampling table for brems
c     *       of muons 
c
      record /epmedia/mediain  !  media
      record /SmpCnst/ cnst  ! must be media.cnst
c
      integer ws, ws1, ws2
      parameter (ws = 3000, ws1=500, ws2=500)
c       real*8 work(ws1, ws2)
       real*8  work1(ws),  work2(ws),  work3(ws), work4(ws)
c        cp mediain into common area
      media = mediain
      call epwtmuPrCnst(cnst)

c            total x-sec.
      if( cnst.muPrTXT .gt. mxMuPrTX) then
         call cerrorMsg(
     *     'too large total X-sec.table for mu pair creation', 0)
      endif
      call epCreMuPrTXT(
     *       cnst, work1, work2,  work3, work4, cnst.muPrTXT)

c        sampling can be performed by rejection method
c        and we don't make table here
c           sampling table
c      if( cnst.muPrUsize * cnst.muPrEsize .gt. mxMuPrTbl ) then
c         call cerrorMsg('Too large Mu pair creation tab requested', 0)
c      endif
c      call  epCreMuPr(cnst, work, cnst.muPrUsize, cnst.muPrEsize)

      end

c     ****************************************
      subroutine epCreMuPrTXT(
     *       cnst, erg,  txs, tdEdx0, tdEdxt, size)
c     ****************************************
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmedia.h"
#include "Zmass.h"
#include "ZmuBPNgene.h"


      record /SmpCnst/ cnst  ! must be media.cnst
      integer size
      real*8  txs(size), erg(size), tdEdx0(size), tdEdxt(size)

      real*8  xmax, xmin,  de, tprob, epmuPairVmn, vcut
      character*160 msg
      integer i
c      integer klena

      real*8  dEdx0,  dEdxt
      real*8 pw1, pw2, pw3

      write(msg,*) ' Matter=', media.name,
     *  ': Computing the total Xsec of Mu pair cre. from E= ',
     *    cnst.muPrEmin, ' GeV'
      call cerrorMsg(msg, 1)
      Emu = cnst.muPrEmin
      de = 10.d0**cnst.muPrdETX

      do   i=1, size
         xmin = cnst.muPrVmin  ! > 2masele/Emu
         vcut = epmuPairVmn(Emu)
         xmax = 1.d0 - masmu/Emu
         call eptotcmuP(xmin, xmax, tprob)

         call epmuElossP(vcut, xmin, dEdx0)

c          total loss
         call epmuElossP(vcut, xmax, dEdxt)
         erg(i) = Emu
         txs(i) =tprob * media.mbtoPX0 ! prob/X0
c            dE/dx(v<vmin)/Emu
         tdEdx0(i) = dEdx0 * media.mbtoPgrm !  /(g/cm^2)
c            dE/dx/(all v)/Emu
         tdEdxt(i) = dEdxt * media.mbtoPgrm !  /(g/cm^2)

         Emu = Emu * de
      enddo
      write(msg, *) 'Table has been made up to  Emu=',
     *       Emu/de,' GeV'
      call cerrorMsg(msg, 1)
      write(msg, *) 
     * 'Muon pair cre. total X-sec. table (Prob./X0) upto E=',
     *     Emu/de,' GeV'
      call epwt1dTbl(msg, erg, txs, size, media.name)
c
      pw1 =( log10(txs(size-1)/txs(size-2))/cnst.muPrdETX +
     *       log10(txs(size)/txs(size-1))/cnst.muPrdETX +
     *       log10(txs(size)/txs(size-2))/cnst.muPrdETX/2)/ 3.d0
      write(msg, *) pw1,
     * ' = power of energy dependence at higher energies'
      call cerrorMsg(msg, 1)
c      write(*,*)  msg(1:klena(msg))
      
      msg= 'dE/dx(v<vmin)/Emu (/(g/cm2))by muon pair cre.'
      call epwt1dTbl(msg, erg, tdEdx0, size, media.name)
      pw2 =( log10(tdEdx0(size-1)/tdEdx0(size-2))/cnst.muPrdETX +
     *       log10(tdEdx0(size)/tdEdx0(size-1))/cnst.muPrdETX +
     *       log10(tdEdx0(size)/tdEdx0(size-2))/cnst.muPrdETX/2)/3.d0
      write(msg, *) pw2,
     * ' = power of energy dependence at higher energies'
      call cerrorMsg(msg, 1)
c      write(*,*)  msg(1:klena(msg))

      msg= 'dE/dx(v<vmax)/Emu (/(g/cm2))by muon pair cre.'
      call epwt1dTbl(msg, erg, tdEdxt, size, media.name)
      pw3 =( log10(tdEdxt(size-1)/tdEdxt(size-2))/cnst.muPrdETX +
     *       log10(tdEdxt(size)/tdEdxt(size-1))/cnst.muPrdETX +
     *       log10(tdEdxt(size)/tdEdxt(size-2))/cnst.muPrdETX/2)/3.d0
      write(msg, *) pw3,
     * ' = power of energy dependence at higher energies'
      call cerrorMsg(msg, 1)
c      write(*,*) msg(1:klena(msg))


      end

c     **********************************************
      subroutine epCreMuPr(cnst, tbl, sizeu,  sizee)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZmuBPNgene.h"
c         make 2-D sampling table for muon nuclear interaction
 
      record /SmpCnst/ cnst  ! must be media.cnst
      integer sizeu, sizee 
      real*8  tbl(sizeu,  sizee)

      real*8 de, vmin,  u, tcn,  tcnx,  v, dv, vmax, y, error
      integer nvmax
      parameter (nvmax=1000)
      real*8 uv(nvmax), va(nvmax)

      real*8 uu

      character*160 msg
      integer i, j, jmax, k, nerr



      de = 10.d0**cnst.muPrdE

      Emu = cnst.muPrEmin    

      write(msg, *)
     *  ' Creating Mu Pair cre. sampling table  E>=',
     *    cnst.muPrEmin
      call cerrorMsg(msg, 1)
      nerr = 0
      do  i = 1, sizee
         vmin= cnst.muPrVmin
         vmax=1.d0 -  masmu/Emu
         call eptotcmuP(vmin, vmax, tcn)
         v = vmin
         uv(1) = 0.
         va(1) = vmin
         dv =  10.d0**0.01d0
         j= 2
         do  while(.true.)
            v = v * dv
            va(j) = v
            if(v .ge. vmax) then
               jmax = j
               goto 10
            endif
            call eptotcmuP(vmin, v, tcnx)
            uv(j) = min(tcnx/tcn, 1.d0)
            if(uv(j-1) .ge. uv(j)) then
               nerr = nerr + 1
c               numerical error. should be uv(j-1) < uv(j) 
c               neglect this j-th value
            else
               if(uv(j) .eq. 1.) then
                  uv(j) = (uv(j) + uv(j-1))/2
               endif
c//////////
c               write(*,*) sngl(uv(j)), sngl(va(j))
c//////////
               j = j + 1
            endif
         enddo

 10      continue
         va(jmax) = vmax
         uv(jmax) = 1.0
c
c            u -> v table
c         uniform in u

c         tbl(1, i) = vmin
c         do k = 2, sizeu-1
c            u = u + cnst.muNdU
c            if(u .gt. 0.50001d0) then
c               kmax = k
c               goto 20
c            endif
c            call kpolintpFE(uv, 1,  va,  1, jmax, 4,  u, y, error)
c            tbl(k, i) = y
c         enddo
c
c 20      continue
c        
c            uniform in uu= vm**(1-u)

         uu = 0.
         tbl(1, i) = vmin
         do k = 2, sizeu-1
            uu = uu + cnst.muPrdU
c            u = 1.d0 - log( uu )* vmin 
            u = uu
            call kpolintpFE(uv, 1,  va,  1, jmax, 4,  u, y, error)
            tbl(k, i) = y
         enddo
         tbl(sizeu, i) = vmax
         Emu =Emu * de
      enddo

      call epwt2dTbl(
     *  'muon cre.  sampling table ',
     *   tbl, sizeu, sizee)
      call cerrorMsg('the table has been created', 1)
      if(nerr .gt. 0) then
         call  cerrorMsg(
     *   '              ********************************* ', 1)
         call  cerrorMsg(
     *  'warning: at making sampling tab for muon pair cre.',
     *   1)
         write(msg, *) 
     *  'The number of numerical precision errors occurred=',nerr
         call cerrorMsg(msg, 1)
         call cerrorMsg(
     *   'You should check the 2-D table if there are some'//
     *   ' irregurer part such as > 1',1)
         call cerrorMsg(
     *   'If there is, make smoothing of the tab. or'//
     *   ' try a smaller error bound in epmuAuxP.f(epsa, epsr)', 1)
      endif
      end
