      subroutine epPrHSampP(media, Eg, prob)
c        this is used for a table with LPM
      implicit none
#include "Zmedia.h"
      record /epmedia/media
      real*8 Eg
      real*8 prob  ! output probability of Pair / X0

      real*8 ale

      if(Eg .lt. media.cnst.PrEg1H) then
         call cerrorMsg('Eg is too low for epPrHSamp',0)
      elseif(Eg .lt. media.cnst.PrEg2H) then
         ale=log10(Eg)
         call kintp3(media.tbl.PrTXH,
     *   1, media.cnst.PrneH, media.cnst.PrLEg1H,
     *   media.cnst.PrdEH, ale, prob) 
      else
c        use 1/sqrt(E)
         prob =  media.tbl.PrTXH(media.cnst.PrneH)/
     *         sqrt((Eg/media.cnst.PrEg2H))
      endif
      end
c     ************
      subroutine epPrHSampE(media, Eg, Ee)
c     ************
c          samples higher energy pair electron
      implicit none
#include "Zglobalc.h"
#include "Zmedia.h"
      record /epmedia/media
      real*8 Ee,  Eg

      real*8 u, ale,  ans

      call rndc(u)
      ale = log10(Eg)
      if(Eg .lt. media.cnst.PrEg2H) then
         call k4ptdi(media.tbl.PrSTH, 
     *        media.cnst.Prnu1H,
     *        media.cnst.PrneH,
     *        media.cnst.Prnu1H,
     *        media.cnst.PrU1H,
     *        media.cnst.PrLEg1H,
     *        media.cnst.PrdU1H,
     *        media.cnst.PrdEH, u,  ale,  ans)  
         Ee = ans*Eg
      else
c           use rejection method; employ cosmos function
         call csetLPMCnst(media.s1, media.logs1,
     *       1.0d0, media.X0g*Tokgpm2) ! X0g in kg/m^2 1.0d0 is dummy
                                       ! not used for pair
         call cpairErgLPM(Eg, media.rho*Tokgpm3, Ee)   ! rho in kg/m^3
c            Ee is not nec. higher one.
c            make consistent with non LPM case.
         if(Eg - Ee .gt. Ee) then
            Ee = Eg- Ee
         endif
      endif

      end

