	subroutine ksegCutByCcl(x1, y1, x2, y2, x0, y0, r, segl)
c           suppose a given line segment. This compute the length
c           of the segment portion which is contained in 
c           the circle.
c
	implicit none
	real*8 x1, y1   ! input. one point of the line segment 
	real*8 x2, y2   ! input. another point of the line segment
	real*8 x0, y0   ! input. center of the circle
	real*8  r       ! input. radius of the circle
	real*8  segl    ! output. length of the portion of the 
                        ! segment contined in the circle..


	real*8  a, b, c,  a1, a2, d


	a = (x2-x1)**2 + (y1-y2)**2
	b = (x2-x1)* (x1-x0) + (y2- y1)* (y1-y0)
	c = (x1-x0)**2 + (y1-y0)**2 -r**2
	d = b**2 - a*c
c	write(*, *) 'a, b, c, d=', a, b, c, d
	if(d .le. 0. ) then
	   segl = 0.
	elseif( a .eq. 0.) then
	   segl = 0.
	else
	   d = sqrt(d)
	   a1 = (-b + d)/a
	   a2 = (-b - d) /a
c	   write(*,*) ' d, a1, a2=', d, a1, a2, ' sqrt(a)=', sqrt(a)
	   if(a1 .ge. 1.0 .and. a2 .le. 0.) then
	      segl = sqrt( a )
	   elseif(a1 .ge. 0. .and. a1 .le. 1.0 .and. a2 .le. 0.) then
	      segl = a1 * sqrt(a)
	   elseif(a1 .ge. 1.0 .and. a2 .ge. 0. .and. a2 .le. 1.0) then
	      segl = (1.0 -a2 )* sqrt(a)
c	      write(*, *)  segl
           elseif(a2 .ge. 0 .and. a2 .le. 1.0 .and.  a1 .le. 1.0) then
              segl = (a1 - a2)*sqrt(a)
	   else
	      segl = 0.
	   endif
	endif
  	end	
       subroutine fiberCount(x1, z1, sx, r, n, 
     *                       xs, ys, zs, wx, wy,  wz, 
     *                       de, dl, invattenl, yii, eloss)
c        SciFi of radius r (cm) is assumed to be aligned
c      along y direction on the x-y plane. The circle
c      cross-section is on the x-z plane.  
c 
c      z
c      |  1                           n 
c      |  o o o o o o o o o o o o o o o  
c      |  x1        <-> sx
c      --------------------------------> x
c      The first fiber center is at x1, z1.  
c      The i-th fiber center is at xi= x1 + (i-1)*sx
c      with the same z1.  
c      A charged particle runs dl cm from (xs, ys, zs)
c      with the direction cosine (wx, wy, wz) and
c      lose energy de (GeV).  It is assumed that the
c      track is contained in the current layer 
c      (This is guaranteed  by Epics).  
c      This subroutine computes the energy loss portion
c      of 'de' put in each fiber and adds
c      it to eloss(i).  The energy loss is assumed to 
c      be proportional to track's segment length in  each    '
c      fiber (This is not strictly correct).
c
       implicit none
        real*8 x1  !  the first fiber center x
        real*8 z1  !  fiber's center height                '  
        real*8 sx  !  step of the adjacent fiber centers
        real*8 r   !  radius of each fiber
        integer n   !  number of fibers
        real*8 xs, ys,  zs  !  track segment starting point.
                        !  ys is needed only for computing attenuation
                       ! of light from ys to yii.  
        real*8 wx, wy, wz  !  track's direction cosines               '
                           !  wy is needed.
        real*8 de          !  energy loss along dl cm
        real*8 dl          !  the track runs dl cm
        real*8 invattenl   !  1/(attenuation length of light) (/cm)
        real*8 yii         ! I.I's position. The legth to the         '
                           ! I.I is yii - ys.
        real*8 eloss(n)    !  array to count up the energy loss
                           !  in the n-th fiber 
c
        integer is, ie, i
        real*8  xe, ze  ! end point of the track
        real*8  xc, segl, deatii
c
        xe = xs + wx * dl
        ze = zs + wz * dl
c           compute fiber numbers the track may passes
        ie = min(int((max(xs, xe) - x1 - r)/sx + 2), n)
        is = max(int((min(xs, xe) - x1 + r)/sx + 1), 1)
c
        deatii =  exp( - (yii - ys)*invattenl) * de
        do i = is, ie
           xc = x1 + (i-1)*sx
           call ksegCutByCcl(xs, zs, xe, ze, xc, z1, r, segl) 
           if(segl .gt. 1.d-5) then
              eloss(i) = eloss(i) + 
     *             segl/dl *deatii/sqrt(1.-wy**2)
           elseif(1.-abs(wy) .le. 1.0d-5) then
c                  along fiber
              if( (xs-xc)**2 + (zs-z1)**2 .lt. r**2) then
                 eloss(i) = eloss(i) + deatii
              endif
           elseif(dl .eq. 0.) then
c                dead particle may come here
              eloss(i) = eloss(i) + deatii
           endif
        enddo
        end
