      subroutine epsyncp(aPtcl,  B, up, mfp, path)
      implicit none
#include "Zptcl.h"
#include "Zep3Vec.h"
c          samples path length for synchrotron emission.

      record /ptcl/aPtcl  ! input. electron (E is in GeV)
      record /ep3Vec/ B   ! input. 3 components of mag. field. in T.
      real*8 up    ! output. Upsilon value (Ee/Me * B/Bcr)
      real*8 mfp   ! output. mean free path  in cm of emission of a photon
                   !           with arbitray energy
      real*8 path  ! output. sampled path in cm. for emission


      real*8    u,  cupsilon, cmBremMFP

      up = cupsilon(aPtcl, B)
      mfp = cmBremMFP(aPtcl.fm.p(4), up, 0.d0) *1.d2 
      call rndc(u)
      path = -log(u) * mfp
      end
c    ***********
      subroutine epsynce(E, up, ephoton)
c    **************
      implicit none
      real*8 E  ! input. Electron energy in GeV
      real*8 up ! input. Upsilon value (=Ee/me *B/Bcr)
c
      real*8 ephoton ! output. sampled photon energy in GeV.

      real*8   x ! fractional energy.

      call cmBremE(up, x)
      ephoton = E* x
      end
c     ************
      subroutine epmpairp(aPtcl,  B, xai, mfp, path) 
      implicit none
#include "Zptcl.h"
#include "Zep3Vec.h"
c          samples path length for synchrotron emission.

      record /ptcl/aPtcl  ! input. photon (E is in GeV)
      record /ep3Vec/ B   ! input. 3 components of mag. field. in T.
      real*8 xai    ! output. Xai value (Eg/Me * B/Bcr)/2
      real*8 mfp   ! output. mean free path  in cm of magnetic pair creation
      real*8 path  ! output. sampled path in cm. for pair creation

      real*8    u,  cmPairMFP, cxai

      xai = cxai(aPtcl, B)
      mfp = cmPairMFP(aPtcl.fm.p(4), xai) *1.d2   ! cm
      call rndc(u)
      path = -log(u) * mfp
      end
c    ***********
      subroutine epmpaire(E, xai, e1)
c    **************
      implicit none
      real*8 E  ! input. Photon energy in GeV
      real*8 xai ! input. xai value (=Ee/me *B/Bcr/2)
c
      real*8 e1 ! output. sampled electron energy  in GeV.

      integer  nc  ! no. of trial in cmPair
      real*8   x ! fractional energy.  >=0.5 

      call cmPairE(xai, x, nc)
      e1 = E* x
      end



