#include "ZepicsBD.h"
      implicit none
c
c This is to test a complex boundary such as composed by
c  a partially contained ovlume.  The  boundary search is
c  performed for particles inside the volume.
c
c
c      
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
#include  "ZepManager.h"
#include  "Zepdebug.h"      
      real*8 ux, uy, uz
      integer icon, i, np, nc
c      integer debug
      record /epPos/ xp
c      record /epDirec/ dirl

      record /epPos/ org
      record /ep3Vec/ abc
      integer ir(2), cmpn
      logical  iso/.true./

      character*100 dsn1        ! input config data file path

      ir(1)=2222333
      ir(2)=3445679
      MsgLevel = 1
      np = 15000
      cmpn = 1
      call cerrorMsg(
     * 'Enter config file path(say, ../UserHook/NewVol/config)', 1)
      read(*,'(a)')  dsn1
      call cerrorMsg(
     * ' number of points(=15000),'//
     *  'isotropic angles(=t), Comp# to test(=1), 2ir',  1)
       
      read(*, *)  np, iso, cmpn, ir

      MediaDir(1) = '../Data/Media'
      call eprcnf(dsn1)

      call rnd1i(ir)
c
      Cn = cmpn
      call epparaphtbl(0)
      call  epqenvlper(cmpn, org, abc)
      write(0, *)  'org and abc in local'
      write(0, *)  org.x, org.y, org.z
      write(0, *)  abc.x, abc.y, abc.z
c      call epl2w(cmpn, org, org)
c      write(0, *)  ' org in world', org.x, org.y, org.z
c      write(0, *) ' comp.# to be examined =', cmpn
      do i = 1, np
         call  rndc(ux)
         call  rndc(uy)
         call  rndc(uz)
         cTrack.pos.x = abc.x * ux + org.x
         cTrack.pos.y = abc.y * uy + org.y
         cTrack.pos.z = abc.z * uz + org.z
         if(iso) then
            call episoDirec(cTrack.w) ! isotroic angle
         else
            call epvertical(cTrack.w) ! vertical to x-y plane, etc
         endif
c    
         call eppos2cn(cmpn, cTrack, nc)

         if(nc .eq. cmpn) then
c                  pos is inside.
c            call epw2l(cmpn, cTrack.pos, posl)
c            cTrack.pos = posl
c            call epw2ld(cmpn, cTrack.w, dirl)
c            cTrack.w = dirl
c            call epbndry2(cmpn, length, icon)
            call epbndry(xp, icon)
            if(icon .ne. -1) then
               write(*,*)  sngl(xp.x),
     *          sngl(xp.y),
     *          sngl(xp.z), icon
            endif
         endif
      enddo
      end
      subroutine epvertical(direc)
      implicit none
#include "ZepDirec.h"
      record /epDirec/ direc

      real*8 u, ux  

      call rndc(u)
      call rndc(ux)
      if(ux .gt. .5) then
         ux = 1.
      else
         ux = -1.
      endif

      if(u .lt. 0.3333d0) then
         direc.x = ux
         direc.y = 0.
         direc.z = 0.
      elseif(u .lt. .6666d0) then
         direc.x = 0.
         direc.y = ux
         direc.z = 0.
      else
         direc.x = 0.
         direc.y = 0.
         direc.z = ux
      endif
      end

