      implicit none
c
c         to write data needed to draw pair function at arbitrary energies
c
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"


      character*40  file
      integer io, i, norm, nerg
      parameter (nerg=10)
      real*8  Eg, x, f, xmax, xmin, EgA(nerg)
      real*8   tprob, epPrgenex
      data EgA/nerg*0./

      io = 10
      call cerrorMsg(' ', 1)
      call cerrorMsg('1) In unit of / r.l (1)',  1)
      call cerrorMsg('2) In unit of mb/ingredient', 1)
      call cerrorMsg('3) In unit of /(g/cm^2)', 1)
      call cerrorMsg('4) In unit of /cm', 1)
      call cerrorMsg(
     * '5) Area normalization for comarison with M.C'//
     * ' result such as k vs ds/dx ',    1)

      norm = 1
      read(*, *)  norm

      call cerrorMsg(
     *"Enter basic media file path( such as"//
     *  " '../../Data/BaseM/Pb' )", 1)
      file= '../../Data/BaseM/Pb'
      read(*, *) file
      call cerrorMsg(
     *'Enter energy of gamma(GeV) upto 10 (with last /)', 1)
      read(*,*) EgA

      open(io, file=file, action='read')
      call epBPgeneini(io, media)

      do i = 1,  nerg
         Eg = EgA(i)
         if(Eg .lt. 2*masele) goto 10 
         Egme = Eg/masele
         xmax = 1. - masele/Eg
         xmin = 0.5d0
         x = xmin
         if(norm .eq. 5) then
            call epPrgeneTX(xmin, xmax, tprob)
            tprob = tprob * 2
         else
            tprob =  1.
         endif
      
         x = 0.5d0
         do while (x .lt.  xmax)
            f = epPrgenex(x)
            if(norm .eq. 5) then
               f = f/tprob
            elseif(norm .eq. 1) then
               f = f * media.mbtoPX0 ! prob/X0
            elseif( norm .eq.  2) then
c                 nothing to do  . in mb
            elseif(norm .eq.  3) then
               f = f* media.mbtoPgrm
            elseif(norm .eq. 4) then
               f = f* media.mbtoPcm
            else
               call cerrorMsg('input error',0)
            endif
            write(*,*) sngl( (x*Eg-masele)/(Eg-2*masele)), sngl(f),
     *                 sngl(Eg)
            if(x .gt.  0.9d0*xmax ) then
               x = x + .001d0
            else
               x = x * 10.**0.01
            endif
         enddo
         write(*, *)
 10      continue
      enddo
      end
