      subroutine epbndry(pos, icon)
      implicit none
#include "ZepTrackp.h"
#include "ZepTrackv.h"
#include "Zcnfig.h"
c
c       get the crossing point of cTrack extending from the current
c       location with a given direction
c
      record /epPos/ pos ! output. obtained crossing point 
                         ! in the current local coord.
      integer icon ! output. 0 --> normal
                   !         1 --> boundary search error. but
                   !               particle energy is  ~ mass and
                   !               very rarely happens   so neglect this
                   !         2 --> same as 1 but energy is high
      character*120 msg
      real*8 el, tmpel, el2
      integer i, cnxx, j, cnx, jcon

c          present comp, boundary
      call epbndry2(Cn, el, jcon)
      if(jcon .ne. 0) then
c                ptcl is not in the current comp. stragne.
c         This happens if a partcle is on a boundary or 
c         very near to the boudnary.  We can adust the  position
c         etc and continue the execution.
c         However, this also happens if a wrong incident direcion is given,
c         too or by some unkown reason. So we count the occurence / event
c         issue messages.

         Bndryerr = Bndryerr + 1    ! count it
         call eppos2cn(Cn, cTrack, cnxx)
         if(Cn .ne. cnxx) then
            cTrack.cn = cnxx
            pos = cTrack.pos
         else
            pos = cTrack.pos
            cTrack.pos.x = cTrack.pos.x - EpsLeng*cTrack.w.x
            cTrack.pos.y = cTrack.pos.y - EpsLeng*cTrack.w.y
            cTrack.pos.z = cTrack.pos.z - EpsLeng*cTrack.w.z
         endif

         call cerrorMsg(
     *    'If this message comes out at the very beginning of', 1)
         call cerrorMsg(
     *    ' an event, better to suspect that your incident particle',1)
         call cerrorMsg(
     *     'direction might be wrong; check it.!!!!!', 1)
         call cerrorMsg(
     *    'If not,  a particle on or very near to a ', 1)
         call cerrorMsg(
     *    'component boundary might have buffalloed Epics.' , 1) 
         call cerrorMsg(
     *    'Epics tries to recover the matter safely.', 1)
         call cerrorMsg(
     *    'However, some unknown cause may lead to this, ', 1)
         call cerrorMsg(
     *    'so check the coordinate below, if they are very ',1)
         call cerrorMsg(
     *    'near to the boundary ', 1)
         write(msg, *) ' Cn for current pos=',Cn,
     *           ' which should be ', cnxx
         call cerrorMsg(msg, 1)
         write(msg,*) ' x y z=', cTrack.pos.x, cTrack.pos.y,
     *        cTrack.pos.z
         call cerrorMsg(msg, 1)
         write(msg,*) 'Move.Track.pos =', Move.Track.pos.x,
     *        Move.Track.pos.y, Move.Track.pos.z
         call cerrorMsg(msg, 1)
         write(msg,*) 'cTrack wx.y,z=',cTrack.w.x,
     *        cTrack.w.y, cTrack.w.z
         call cerrorMsg(msg, 1)
         write(msg,*) ' cTrack E=',cTrack.p.fm.p(4), ' Move E=',
     *        Move.Track.p.fm.p(4),  ' code=',cTrack.p.code,
     *        ' chg=',cTrack.p.charge
         call cerrorMsg(msg,1)
         call cerrorMsg('-------------------------------',1)
         if( Bndryerr  .gt. 100 ) then
            call cerrorMsg('too many boundary error', 0)
         endif
         icon = 0
         jcon = 0
      else
c          partial  container's boundary, if any, may be closer
        do j = 1, Det.cmp(Cn).NPContainer
c((((((((((
c           cnx = Det.cmp(Cn).PContained(j)
           cnx = CnArea(Det.cmp(Cn).PContained+j)
c))))))))))))
           call  epbndry2(cnx,  el2, jcon)
           if(jcon  .eq. 0) then
              if(el2 .lt.  el) then
                 el = el2
              endif
           endif
        enddo
c          Matreska may be in between
        do i = 1, Det.cmp(Cn).NMatreska
c((((((((((((((((
c           call epbndry2(Det.cmp(Cn).Contains(i),  tmpel, jcon)
          call epbndry2(CnArea( Det.cmp(Cn).Contains+i),  tmpel, jcon)
c))))))))))
           if(jcon .eq. 1 .and. tmpel .lt. el) then
              el = tmpel
           endif
        enddo
        pos.x = cTrack.pos.x + el*cTrack.w.x
        pos.y = cTrack.pos.y + el*cTrack.w.y
        pos.z = cTrack.pos.z + el*cTrack.w.z
        icon = 0
      endif
      end
      subroutine epbndry2(cnx, el, icon)
       implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
c
c          get the length to the nearest crossing point of cTrack
c          and the specified component
c
        integer cnx   ! input. cnx-th component is examined
        real*8  el    ! output. length to the boundary of the cnx-th  comp
                      !         from cTrack.
        integer icon  ! output. 0, x,y,z is inside
                      !         1  outside,
                      !        -1  no Xssing

        record /epPos/ posw, posl
        record /epDirec/ dirw, dirl


        character*80 msg
        character*8  epparaphrase, tempph

        if(Cn .eq. cnx) then
c            no need to conv. to local.coor.
           posl =cTrack.pos
           dirl =cTrack.w 
        else
           call epl2w(Cn, cTrack.pos, posw)
           call epw2l(cnx, posw, posl)
           call epl2wd(Cn, cTrack.w, dirw)
           call epw2ld(cnx, dirw, dirl)
        endif

        if(Det.cmp(cnx).struc(1:3) .eq. 'box') then
           call epbbox(Det.cmp(cnx), posl, dirl, el, icon)
        elseif(Det.cmp(cnx).struc(1:3) .eq. 'cyl') then
           call epbcyl(Det.cmp(cnx), posl, dirl, el, icon)
        elseif(Det.cmp(cnx).struc(1:4) .eq. 'pipe') then
           call epbpip(Det.cmp(cnx), posl, dirl, el, icon)
        elseif(Det.cmp(cnx).struc(1:5) .eq. 'prism') then
           call epbprs(Det.cmp(cnx), posl, dirl,  el, icon)
        elseif(Det.cmp(cnx).struc(1:6) .eq. 'sphere') then
           call epbsph(Det.cmp(cnx), posl, dirl, el, icon)
        elseif(Det.cmp(cnx).struc(1:4) .eq. 'new-') then
           call epbNew(Det.cmp(cnx), posl, dirl, el, icon)
        else
           tempph = epparaphrase(Det.cmp(cnx).struc(1:8))
           if(tempph(1:4) .eq. 'new-') then
              call epbNew(Det.cmp(cnx), posl, dirl, el, icon)
           else
c                   
              write(msg, *) ' strange structure=',
     *             Det.cmp(cnx).struc
              call cerrorMsg(msg, 0)
           endif
        endif
        end
c       ***************************
        subroutine epbbox(comp, posl, dirl, el, jcon)
        implicit none
#include  "ZepTrackv.h"
#include  "Zcnfig.h"
c           find length to the boundary of comp component
c           from posl with direc cos dirl in local coord.
        record /Component/comp
        integer jcon
        real*8 el, el2
c
        integer icon, icon2, icon3, icon4
        record /epPos/  posl
        record /epDirec/ dirl
        integer base
        
        base = comp.vol

        call kxplbx(
     *       posl.x, posl.y, posl.z, dirl.x, dirl.y, dirl.z,
     *       Volat( base+boxa), Volat(base+boxb), 
     *       Volat( base+boxc), el, jcon)
        return
c      ***********
       entry epbcyl(comp, posl, dirl,  el, jcon)
c      ***********
c
       call kxplcy(posl.x,  posl.y, posl.z, dirl.x,  dirl.y,
     *    dirl.z, Volat( comp.vol+cylr), Volat(comp.vol+cylh), 
     *    el, jcon, icon2)
        return
c      **********
       entry epbpip(comp, posl, dirl, el, jcon)
c

       call kxplcy(posl.x, posl.y, posl.z, dirl.x, dirl.y, dirl.z, 
     *   Volat(comp.vol+pipeor), Volat( comp.vol+pipeh), 
     *    el, icon, icon2)
       if(icon .eq. 0)  then
          call kxplcy(posl.x, posl.y, posl.z, dirl.x, dirl.y, dirl.z, 
     *      Volat( comp.vol+pipeir), Volat(comp.vol+pipeh),
     *         el2, icon3, icon4)
          if(icon3 .eq. 1) then
             jcon = 0
             el = el2
          elseif(icon3  .eq. 0) then
             el = el2
             jcon = 1           ! inner  cyl. regarded as outside
          else 
             jcon = 0
          endif
       elseif(icon .eq. 1) then
          jcon = 1
       else
          jcon = -1
       endif
       
       return
c      **********
       entry epbsph(comp, posl, dirl, el, jcon)
c          compute  current pos to  comp sphere
c               current  pos is assumed to be inside the sphere
c     
       call kxplsph(posl.x, posl.y, posl.z,
     *      dirl.x, dirl.y, dirl.z, 
     *      Volat(comp.vol+sphr), el, jcon)
       return
c      ***************
       entry epbprs(comp, posl, dirl, el, jcon)
c            prism
c
       
       call kxplPrism(posl.x, posl.y, posl.z,
     *      dirl.x, dirl.y, dirl.z,
     *      Volat(comp.vol+prisma), Volat(comp.vol+prismb),
     *      Volat(comp.vol+prismc), Volat(comp.vol+prismh),
     *      el, jcon)
        end




