c     ****************************************************************
c     *
c     * epphotoEp: Photo electric effect prob. per r.l
c     * epphotoEe: samples energy of Photo-electron 
c     *
c     ****************************************************************
c
c
c
c       subroutine epphotoEp(pe, eg, prob, path)
       subroutine epphotoEp(media, eg, prob, path)
       implicit none
#include "Zmedia.h"
#include "Zmass.h"

c       record /photoE/pe  ! input. p.e const
       record  /epmedia/ media   ! from v.8.00

       real*8 eg    ! input. gamma energy in GeV 
       real*8 prob  ! output. prob. per r.l 
       real*8 path  ! output. sampled path in r.l 

       real*8  eout  ! output.  energy of photo electron in GeV
       real*8 ep, tp
c

       real*8 epi, u



c

       ep=eg/masele

c       if(pe.a + eg .le. masele ) then
c          prob = 1.d-35
c       else
          epi=1./ep
          tp= ( (media.pe.b2*epi + media.pe.b1)*epi + 
     *      media.pe.b0 ) *
     *      media.pe.fa* media.pe.p * epi
          if(eg .lt. media.pe.ek ) then
             tp=tp/media.pe.l
          endif
          prob = tp*media.pe.cr
c       endif
       if(media.Zeff .gt. 65.) then
          if(eg .lt.1.e-3) then
c              //////////// this is for Pb
             prob = prob*(1. + (1.e-3/eg)*0.07)
          endif
       endif
       call rndc(u)
       path = -log(u) / prob

       return

c      ************
       entry epphotoEe(media,  eg, eout)
c      ************
c
       eout=eg + media.pe.a
       if( eout .le. masele ) then
          eout =max( eg + media.pe.b, masele )
       endif
       end
