BEGIN {xr[0]=-200; 
       xr[1]=-85;xr[2]=-55;xr[3]=-35;xr[4]=-12;xr[5]=10; xr[6]=34; xr[7]=55;
       xr[8]=80; xr[9]=200;
       nx=8;
       yr[0]=-200;
       yr[1]=-100;yr[2]=-70;yr[3]=-56;yr[4]=-42; yr[5]=-26;yr[6]=-12;yr[7]=3;
       yr[8]=19;yr[9]=34;yr[10]=48;yr[11]=63;yr[12]=78; yr[13]=95;yr[14]=200;
       ny=13;
#          detector width/2 (m)
       w=0.365;
     }

#              ok is to contain live or dead detetor flag (>=0 is live)

NF>3  {$1=$1*1; x[$1]=$2; y[$1]=$3; z[$1]=$4; ok[$1]=$7; n=$1}
END {
  for(iy =0; iy<=ny; iy++) {
    y1=yr[iy]; y2=yr[iy+1];
    for(ix=0; ix<=nx; ix++) {
      x1=xr[ix]; x2=xr[ix+1];
      det=0;
      for(ch=0; ch<=n; ch++) {
	if(ok[ch]>=0 && x[ch] > x1 && x[ch] < x2) {
	  if(y[ch] > y1 && y[ch] < y2) {
#              check if the mesh dose not cross the detector
	    if( x[ch]-w < x1 || x[ch]+w > x2 || y[ch]-w < y1 || y[ch]+w > y2) {
	      printf("some of the lines cross the detector of channel=%d\n", ch);
	      printf("Lines are at x=%f or%f or y=%f or %f\n", x1,x2,y1, y2);
	      exit
	    }

	    det++;
	    if(det == 1){
	      printf("#subd  a%d-%d\n", ix, iy);	
	      ixs= ix; iys=iy;
	    }
	    printf("#        channel %d\n", ch);
            print det,  "  unit sp 0 0 0 ",ch, " / ", x[ch]*100, y[ch]*100, z[ch]*100;
	  }
	}
      }
      if(det > 1) {
	det++; print det, " box_w YBAir 0 0 0 / 0 0  0";
      }
      if(det >0){
	printf("#end   a%d-%d\n", ixs, iys);	
	print " " ;
	print " ";
      }
    }
  }
}

