c             gaussian density beam
       subroutine epGaussb(hwhm, rcut, x, y)
       implicit none
       real*8 hwhm  ! input. half width at half max (cm)
       real*8 rcut  ! input. discard if radius is > rcut (cm)
       real*8 x, y  ! ouput.  sampled  position (cm)

       real*8 alg2, a, tmp, ome, u, r, cs, sn, omu
       
c               ln(2)
           data alg2/.69314718/
c             density is: f(r)=* exp(-(r/rh)**2 * ln(2))
c             distribution is f(r)*r*dr where rh is half
c             width at half
c             max of f(r) = hwhm
           a=alg2/hwhm**2
           tmp=a* rcut**2
           if(tmp .lt. 1.e-4) then
               ome= tmp*(1. - tmp/2)
           else
               ome= 1. -exp(-tmp)
           endif
           call rndc(u)
           tmp= u* ome
           if(tmp .lt. 1.e-4) then
                omu=tmp*(tmp - 1.)
           else
                omu=log(1. - tmp)
           endif
           r=sqrt(-omu/a)
c             sample (x,y)
           call kcossn(cs,sn)
           x=r*cs
           y=r*sn
       end
c     *********************************************************
      subroutine epgonSphere(ini, hwhm, rin, teta, phi, oa, pos)
      implicit none
#include "ZepTrackp.h"
#include "ZepPos.h"     
#include "Zptcl.h"
#include "Zglobalc.h"
c            generate a random point distributed on the
c            surface of a sphere with a Gaussian density.(Note below)
c            Points are distributed around
c            given polar angles (teta, phi) within a given opening angle
c            (oa).  Actually, the point is put little bit inside of
c            the exact surface so that the point is guaranteed inside
c            or on the surface of the sphere.
c                 
c Note:   Gaussian means that the beam has a Gaussian density if it is
c    projected to the plane which is tangent to the sphere at the
c    Gaussian center.
c    The rcut used for epGaussb is related to oa here as
c    rcut = r sin( oa ).
c
      integer ini               ! input
                      !  1-->  teta and phi are different from
                      !        previous call or this is the first call.
                      !  != 1 -->  teta, and phi are the same as
                      !        the previous call.
      real*8  hwhm      ! input.  half width at half maximum of the
                        !      Gaussian density beam.
      real*8  rin       ! input.  radius of the sphere
      real*8  teta      ! input.  polar angle in degree
      real*8  phi       ! input.  azimutal angle in degree
      real*8  oa        ! input.  opnening angle in degree. has meaning
                        !         if os <= 90.
      record /epPos/ pos  ! output. an  obtained random point

      record /fmom/ xyz, xyz2
      real*8  a(4, 4), b(4, 4), ba(4, 4)

      real*8  rcut, x, y, z, z2, r
      save ba

      r = rin - EpsLeng
      if(ini .eq. 1) then
         call cgetRotMat4(2, -teta*Torad, a)
         call cgetRotMat4(3, -phi*Torad, b)
         call cmultRotMat4(b, a, ba)
      endif
      rcut = r *sin(oa*Torad)
      call epGaussb(hwhm, rcut, x, y)
      z2= r**2 - (x**2 + y**2)
      if(z2 .lt. 0.) then
         call cerrorMsg(
     *  'opening angle for epgonShpere should be checked', 0)
      endif
      z = sqrt(z2)
      xyz.p(1) = x
      xyz.p(2) = y
      xyz.p(3) = z
      xyz.p(4) = 1.
      call capplyRot4(ba, xyz, xyz2)
      pos.x = xyz2.p(1)
      pos.y = xyz2.p(2)
      pos.z = xyz2.p(3)
      end
c     **************************************************
      subroutine epuonSphere(ini, rin, teta, phi, oa, pos)
      implicit none
#include "ZepTrackp.h"
#include "ZepPos.h"     
#include "Zptcl.h"
#include "Zglobalc.h"
c          generate a random point uniformly distributed on the
c          surface of a sphere.  Points are distributed around
c          given polar angles (teta, phi) within a given opening angle
c          (oa). (Actually, the point is put little bit inside of
c          the sphere by an amount of EpsLeng so that it can be
c          judged on or inside the sphere safely even with some
c          numerical error). 
c    By uniform  is meant that the points are uniformly distributed on
c    the surface of the sphere but not on a projected plane.
c
      integer ini               ! input
                      !  1-->  teta and phi are different from
                      !        previous call or this is the first call.
                      !  != 1 -->  teta, and phi are the same as
                      !        the previous call.
      real*8  rin               ! input.  radius of the sphere
      real*8  teta              ! input.  polar angle in degree
      real*8  phi               ! input.  azimutal angle in degree
      real*8  oa                ! input.  opnening angle in degree
      record /epPos/ pos        ! output. an  obtained random point

      record /fmom/ xyz, xyz2
      real*8  a(4, 4), b(4, 4), ba(4, 4)
      real*8  u, r
      real*8 fcos,  fsin
      save ba

      r = rin - EpsLeng
      if(ini .eq. 1) then
         call cgetRotMat4(2, -teta*Torad, a)
         call cgetRotMat4(3, -phi*Torad, b)
         call cmultRotMat4(b, a, ba)
      endif

      call rndc(u)
      fcos = cos(oa*Torad)
      fcos = (1.d0- fcos) * u +  fcos
      fsin = sqrt(1.d0- fcos**2)
      call rndc(u)
      u = u*pi*2
      xyz.p(1) = r * (fsin * cos(u))
      xyz.p(2) = r * (fsin * sin(u))
      xyz.p(3) = r * fcos 
      xyz.p(4) = 1.
      call capplyRot4(ba, xyz, xyz2)
      pos.x = xyz2.p(1)
      pos.y = xyz2.p(2)
      pos.z = xyz2.p(3)
      end


       subroutine afsep(io)
       implicit none
       integer io
          character* 10  sep
c             *** until loop*** 
             do while (.true.)
               read(io, '(a)') sep
             if         (sep .eq. '----------')
     *                          goto 10
             enddo
   10        continue
       end
c        ************************* real*8 data
       subroutine arprmr(io, vname, x)
        implicit none
        integer io
        character*(*) vname
        real*8 x

        character*120 dat
        integer lc
c          skip comment lines and get a data line. 
        call epgetdatline(io, dat, 0)
        lc = index(dat(2:120), ' ') 
        read(dat(lc+1:120), *)   x, x
        call anamec(vname, dat(2:lc))
        end

c     *******************************
      subroutine epgetdatline(io, dat, j)
      implicit none
      integer io  ! input. read device logical number
      character*120  dat  ! output. data line
c       null lines or the lines which have two or more blank characters
c       at head is neglected
      integer j  ! input/output input. 0--> If  EOF,stop
                 !                     1--> If  Eof, 2 is returned.
                 !                          if not eof, 1 is unchanged   
      character*1 tab

      tab = char(9)

      dat ='  '
      do while ( dat(1:2) .eq. '  ' .or. dat(1:1) .eq. tab) 
         read(io, '(a)', end=80) dat
      enddo
c         check if "/" exists for safety
      if( index(dat, "/") .eq. 0 .and. j .eq. 0 ) then
         call cerrorMsg(dat, 1)
         call cerrorMsg(' has no "/" in the data line', 0)
      endif
      return
 80   continue
      if(j .eq.  0) then
         call cerrorMsg('EOF while reading input data', 1)
         call cerrorMsg(
     *   'Some of new parameters may be missing: see epicsfile'//
     *   ' or sepicsfile in FirstKiss', 0)
      else
         j=2
      endif
         
      end   
c     ************************* complex data
      subroutine arprmm(io, vname, c)
      implicit none
      integer io
      character*(*) vname
      complex*16 c
          
      character*120 dat
      integer lc, eof 

      if(vname(2:6) .eq. 'range') then
         eof =1
         call epgetdatline(io, dat, eof)
         if(eof .eq. 2) then
            dat =' '//vname(1:1)//'range (0., 0.) /'
         endif
      else
         call epgetdatline(io, dat, 0)
      endif
      lc = index(dat(2:120), ' ')
      read(dat(lc+1:120), *)   c, c
      call anamec(vname, dat(2:lc))
      end
c     ************************ integer data
      subroutine arprmi(io, vname, i)
      implicit none
      integer io
      character*(*) vname
      integer i
          
      character*120 dat
      integer lc

      call epgetdatline(io, dat, 0)
      lc = index(dat(2:120), ' ')  
      read(dat(lc+1:120), *)   i,i
      call anamec(vname, dat(2:lc))
      end
c        ************************* character data
      subroutine arprmc(io, vname, cha)
      implicit none
      integer io
      character*(*) vname
      character*(*) cha
          
      character*120 dat
      integer lc, eof

      if(vname .eq. 'epHooks') then
c                     this should be  the last part
c            may not be given
         eof = 1
         call epgetdatline(io, dat, eof)
         if(eof .eq. 2) then
            dat = " epHooks '0 0 0' /"
         endif
      else
         call epgetdatline(io, dat, 0)
      endif
      lc = index(dat(2:120), ' ') 
      read(dat(lc+1:120), *)  cha, cha
      call anamec(vname, dat(2:lc))
      end
c        ***************************** logical data
      subroutine arprml(io, vname, logi)
      implicit none
      integer io
      character*(*) vname
      logical logi
          
      character*120 dat
      integer lc

      call epgetdatline(io, dat, 0)
      lc = index(dat(2:120), ' ') 
      read(dat(lc+1:120), *)  logi, logi
      call anamec(vname, dat(2:lc))
      end     
c        ---------------------------------------------
      subroutine awprmr(io, vname, x)
      implicit none
      integer io
      character*(*) vname
      real*8  x
      
      write(io, *) ' ', vname,' ', x,' /'
      end
      subroutine awprmm(io, vname, c)
      implicit none
      integer io
      character*(*) vname
      complex*16  c
      write(io,  *) ' ', vname,' ', c,' /'
      end
      subroutine awprmi(io, vname, i)
      implicit none
      integer io
      character*(*) vname
      integer i
      
      write(io,  *) ' ', vname,' ', i,' /'
      end
      subroutine awprmc(io, vname, cha)
      implicit none
      integer io
      character*(*) vname
      character*(*) cha
      integer klena
      character*2 qmk/" '"/             ! ' 
      if(klena(cha) .gt. 0) then
         write(io,  *) ' ', vname, qmk, cha(1:klena(cha)),
     *        qmk,' /'
      else
         write(io, *) ' ', vname, qmk, ' ', qmk, ' /'
      endif
      end
      subroutine awprml(io, vname, logi)
      implicit none
      integer io
      character*(*) vname
      logical  logi

      write(io,  *) ' ', vname,' ', logi,' /'
      end
      subroutine anamec(vn, dt)
      implicit none
c      
c            check variable name
c
      character*(*) vn, dt
      character*90 msg
      if(vn .ne.  dt) then
         write(msg,*) ' data name should be ',vn,
     *        ' but it is ',dt
         call cerrorMsg(msg, 0)
      endif
      end
c      ********************
      subroutine epqHookc(i, cv)
      implicit none
#include "ZepManager.h"
      integer i  ! input. i-th user defined char vairable is requested
      character*(*) cv  ! output. requested variable value

      integer klena
      if(i .le.  0 .or. i .gt. epHooks(1))  then
c         call cerrorMsg('out of range request to epqHookc',2)
         cv = ' '
      else
         cv = epHookc(i)(1:klena(epHookc(i)))
      endif
      end

      subroutine epqHooki(i, iv)
      implicit none
#include "ZepManager.h"
      integer i  ! input. i-th user defined integer vairable is requested
      integer iv  ! output. requested variable value


      if(i .le.  0 .or. i .gt. epHooks(2))  then
c         call cerrorMsg('out of range request to epqHooki',0)
         iv = -9999999
      else
         iv = epHooki(i)
      endif
      end


      subroutine epqHookr(i, rv)
      implicit none
#include "ZepManager.h"
      integer i  ! input. i-th user defined real vairable is requested
      real*8 rv  ! output. requested variable value


      if(i .le.  0 .or. i .gt. epHooks(3))  then
c         call cerrorMsg('out of range request to epqHookr',0)
         rv = -1.d-60
      else
         rv = epHookr(i)
      endif
      end

