c     ****************************************************************
c     *                                                              *
c     * epdedxNone: gives -de/dx  (gev/(g/cm2)) of non e+/e-
c     *                                                              *
c
c
c
      subroutine epdedxNone(sh, aPtcl, dedt)
      implicit none
#include "Zmedia.h"
#include "Zptcl.h"
#include "Zmass.h"
      real*8 emass, emass2 
      include "ZdEdxSpec.h"
c       MeV unit electron mass.
      parameter(emass = masele*1000., emass2=emass**2)

      record /sternh/sh         ! input. Sternheimer's consts 
      record /ptcl/aPtcl        ! input. a particle

      real*8 dedt               ! output. Energy loss rate.   GeV / (g/cm2). 

 
      real*8  E,  mass,  Beta2, x,  cb
      real*8 dltx,  wm, wlg
      real*8 bbbeta2, lindbeta2, truebeta2
      real*8 bbbeta, lindbeta 
      real*8 logbbbeta, loglindbeta
      real*8 a, b, c, xx, gra, gb2, g, integ
      parameter (bbbeta = 0.1d0,  lindbeta = 0.005d0, gra=5.d0/3.d0)
      parameter (bbbeta2 = bbbeta**2, lindbeta2=lindbeta**2)
      parameter (logbbbeta =-2.302585093E+00,
c     *           loglindbeta =-4.605170186E+00)
     *           loglindbeta =-5.298317367E+00)
      parameter (a = (1.+gra)/2.d0/(logbbbeta-loglindbeta),
     *           b = 2*a*loglindbeta + 1.) 

c////////////
c      real*8  em
c      integer iii
c      data iii /0/
c      save iii
c      if(iii .eq. 0) then
c         write(*,*) ' sh.sa=',sh.sa, ' c=',sh.c,  ' x1=',sh.x1,
c     *   ' sh.x0=', sh.x0
c
c      sh.sa =0.3755
c      sh.c = -4.435
c      sh.x1 = 2.5
c      sh.x0 = 0.0966
c      em = 2.72
c         write(*,*) ' sh.sa=',sh.sa, ' c=',sh.c,  ' x1=',sh.x1,
c     *   ' sh.x0=', sh.x0
c      iii = 1
c      endif   
c////////////


c///////////
c      real*8 betac, gbetac, norm, gbetac2
c      logical first/.true./
c      save first, gbetac2, norm
c      if(first) then
c         gbetac = 0.35
c         gbetac2 = gbetac**2
c         betac = sqrt( gbetac2/(1.0d0+gbetac2) )
c         norm =1.d0/ betac**0.33333
c         first = .false.
c      endif
c////////////////
c
c               energy in MeV unit
      E = aPtcl.fm.p(4)*1000.
      mass= aPtcl.mass*1000.
      g = E/mass
      truebeta2 = 1. -(1.0d0/g)**2
      if(truebeta2 .lt. bbbeta2) then
c            fix at beta=0.1
         Beta2 = bbbeta2
         E = mass*(1. + Beta2/2)
         g = E/mass
      else
         Beta2 = truebeta2
      endif
c     
      gb2 = Beta2 * g**2   !  g^2 b^2

c          x=log10(p/mc)  = log10(g*beta)
         x=log10( gb2 ) / 2
         cb=-sh.c
         if(x .lt. sh.x0 ) then
c                  4.605x - dlt
            dltx=4.605*x
         elseif(x .lt. sh.x1) then
c//////////
            dltx=cb - (sh.x1-x)**3 * sh.sa
c            dltx=cb - (sh.x1-x)**em * sh.sa
c///////////
         else
            dltx=cb
         endif

c             max kinetic energy of knock-on
         wm = 2* emass * gb2
     *        /(1.0 + 2.0*g*(emass/mass) +(emass/mass)**2)
         Tupper = wm/1000.      !  in GeV; used in Urban
c          first compute full average dE/dx
c 
         dedt=sh.a/Beta2 *( sh.b + 0.69315 +  log(wm)
     *        -2.0*Beta2 + dltx)
c             see if restriceted energy is requested
         if(wm .gt. sh.w0) then
c              yes. requested
c                subtract average loss rate due to Ek>Tcut
            integ = log(wm/sh.w0) - Beta2*(1.0-sh.w0/wm)
c            assume spin 0 particle is only pi, K
            if(aPtcl.mass .lt. 0.11 .or. aPtcl.mass .gt. 0.9) then
c               mu, p, etc. spin = 1/2
               integ = integ + 
     *            (wm - sh.w0)*(wm+sh.w0)/4.0/E/E
            endif
            integ = integ*sh.a/Beta2
            dedt = dedt - integ
         endif
c///////////////
c         if( gb2 .lt. gbetac2 ) then
c                  assume at gb < gbetac, 1/beta**(5/3) dependence
c            dedt = dedt*norm*(Beta2**0.1667)
c         endif
c////////////
      if(truebeta2 .lt. bbbeta2) then
         c = log(dedt) + ( a* logbbbeta - b )*logbbbeta
         if( truebeta2 .gt.  lindbeta2) then
            xx = log( truebeta2 )/2.
            dedt =exp( (-a*xx + b)*xx + c)
         else
            dedt = exp( (-a*loglindbeta + b)* loglindbeta + c) *
     *             sqrt(truebeta2)/lindbeta
         endif
      endif
c         x  Z**2 and to GeV unit
      dedt=dedt * aPtcl.charge**2 * 1.d-3
c///////////////
c      write(22,*) sngl( aPtcl.fm.p(4)  - aPtcl.mass), sngl(dedt),
c     *            sngl(sqrt(truebeta2))
c///////////////
      end
c     *********************
c        For the organic scintillator, the energy loss by
c      heavy particles or slow particles is not converted to
c      photons  as efficiently as the one by relativistic electrons.
c      This subroutine gives a correction factor for the energy loss,
c      so that you can get effective energy loss by multiplying
c      cf by the true energy loss.
      subroutine epOrgCorrec(media, aPtcl, dedx, cf)
      implicit none
#include "Zmedia.h"
#include "Zptcl.h"
#include "Zmass.h"

      record /epmedia/ media  ! input.
      record /ptcl/ aPtcl   ! input.
      real*8  dedx   ! input.  dE/dx (GeV/(g/cm^2) for the partcle
      real*8  cf     ! output. correction factor. dE_eff = cf x dE_true

      real*8 c1
      c1 = media.BirksC1
c      if( abs( aPtcl.charge ) .gt. 1)  then
c        c1 = c1 * media.BirksCC
c      endif
c      cf = 1./(1. + c1 * dedx + media.BirksC2 * dedx**2)
c        at present, we don't use above two factors
c 
      cf = 1./(1. + c1 * dedx)
      end


