c     ****************************************************************
c     *                                                              *
c     * dpdedxe:  gives -de/dx  (gev/(g/cm2) of   e-/e+
c     *                                                              *
c
c  GEANT style.
c
      subroutine epdedxe(sh,  aPtcl, dedt)
      implicit none
#include "Zstern.h"
#include "Zptcl.h"
#include "Zmass.h"

	include "ZdEdxSpec.h"

      record /sternh/sh    !  input. Sternheimer's consts
      record /ptcl/ aPtcl  !  input. a Particle (e- or e+) 
      real*8  dedt ! output.  dE/dt GeV/(g/cm^2)

      real*8 emass
      real*8 E, gi, Beta2, x, cb
c      real*8 dltx, wm, wlg, g, D, u, F, y
      real*8 dltx, g, D, u, F, y


      real*8 bbbeta2, lindbeta2, truebeta2
      real*8 bbbeta, lindbeta
      real*8 logbbbeta, loglindbeta
      real*8 a, b, c, xx, gra
      parameter (bbbeta = 0.1d0,  lindbeta = 0.01d0, gra=4.0d0/3.d0)
      parameter (bbbeta2 = bbbeta**2, lindbeta2=lindbeta**2)
      parameter (logbbbeta =-2.302585093E+00,
     *           loglindbeta = -4.605170186E+00)
      parameter (a = (1.+gra)/2.d0/(logbbbeta-loglindbeta),
     *           b = 2*a*loglindbeta + 1.) 
c

      parameter (emass = masele*1000.d0)



c       Energy, mass=emass  in MeV unit
      E = aPtcl.fm.p(4)*1000.d0
      g = E/emass
      gi= 1.d0/g
      truebeta2= 1. - gi**2
      if(truebeta2 .lt. bbbeta2) then
         Beta2 = bbbeta2
c         wm = emass*Beta2/2
         g = (1.+Beta2/2)
         E = emass*g
      else
         Beta2 = truebeta2
c         wm=E- emass
      endif
      u = g -1.0
c       x=log10(p/mc)
c      x=log10( (E/emass)**2 - 1. ) / 2  ! = log10(gbeta) = 0.4343log(gbeta)
      x=log10( g**2 - 1. ) / 2  ! = log10(gbeta) = 0.4343log(gbeta)
      cb=-sh.c
c
c        we define deltx = -delta + 4.605x = -delta + log(g+1)(g-1)
c                          -delta + log(g^2beta^2)
c
      if(x .lt. sh.x0) then
c        4.605x - dlt  
         dltx=4.605*x
      elseif(x .lt. sh.x1) then
         dltx=cb - (sh.x1-x)**3 * sh.sa
      else
         dltx=cb
      endif
c      Geant formulat = sh.a/Beta2* (sh.b +log(2(g+1)) + F -delta)
c     () =  sh.b + log2(g+1) + F + deltx - log(g+1)(g-1) 
c        =  sh.b + log2 + F-log(g-1) + deltx
c        =  sh.b + 0.69315 + F - log(u)
c
      if(aPtcl.charge .eq. -1) then
c          electron
         D = min(sh.w0/emass, u/2.0)
c         original F = -1.-Beta2 +log((u-D)*D) + u/(u-D) +
c         so -logu becomes
         F = -1.-Beta2 +log((1.0-D/u)*D) + u/(u-D) +
     *        (D*D/2 +(2*g+1) * log(1.d0-D/u))/(g*g)
      else
c         positron
         D = min(sh.w0/emass, u)
         y = 1.d0/(g+1.d0)
c         origianl F = log(uD) - D/u/u  .. so F-logu= log(D) -...
         F = log(D) - D/u/u * 
     *        ( u + 2*D - 3.0/2.0*D*D*y - (1.-D*D/3.0d0)*D*y*y
     *        -(0.5d0-u*D/3.0d0+D*D/4.0d0)*D*D*y*y*y )
      endif

      Tupper = D*emass*1000.  ! in GeV; used in Urban

      dedt =sh.a/Beta2 *( sh.b + 0.69315 + F + dltx)


      if(truebeta2 .lt. bbbeta2) then
         c = log(dedt) + ( a* logbbbeta - b )*logbbbeta
         if( truebeta2 .gt.  lindbeta2) then
            xx = log( truebeta2 )/2.
            dedt =exp( (-a*xx + b)*xx + c)
         else
            dedt = exp( (-a*loglindbeta + b)* loglindbeta + c) *
     *             sqrt(truebeta2)/lindbeta
         endif
      endif
c///////////////
c      write(23,*) sngl( aPtcl.fm.p(4)  - aPtcl.mass), sngl(dedt),
c     *      sngl(sqrt(truebeta2)), aPtcl.code, aPtcl.charge
c
c///////////////
c          convert it to gev/(g/cm2)
       dedt=dedt *1.d-3
       end





