      subroutine epRdmuPrSTbl(io, cnst, tbl)
      implicit none
#include "ZbpSample.h"
#include "ZbpTbl.h"
c     read muon  pair ceation sampling table.
c     This table must be read first (earlier than 
c     Br, N).  If the table is not found,
c     muon energy loss is only by dE/dx due to
c     ionization.
c
      integer io
      record /bpTbl/tbl   !    must be media.tbl
      record /SmpCnst/ cnst  ! must be media.cnst
c

      call epRdmuPrCnst(io, cnst)
c            total x-sec. v> vmin
      if(cnst.muPrTXT .gt. mxMuPrTX) then
         call cerrorMsg(
     *      'mu pair cre. total X-sec table too large',0)
      endif
c        total x-sec
      call epRd1dTbl(io,  tbl.MuPrTX, cnst.muPrTXT)
c          dE/dx/E (/(g/cm2)
      call epRd1dTbl(io,  tbl.MuPrdEdx0, cnst.muPrTXT)

c          dE/dx/E (/(g/cm2))
      call epRd1dTbl(io,  tbl.MuPrdEdxt, cnst.muPrTXT)
c

c           sampling table
c      if( cnst.muPrUsize * cnst.muPrEsize .gt. mxMuPrTbl) then
c         call cerrorMsg(
c     *     'muon pair cre. sampling table too large', 0)
c      endif
c      call  epRd2dTbl(io,  tbl.MuPrTbl, 
c     *     cnst.muPrUsize, cnst.muPrEsize)
      end

      subroutine epRdmuBrSTbl(io, cnst, tbl)
      implicit none
#include "ZbpSample.h"
#include "ZbpTbl.h"

c
      integer io
      record /bpTbl/tbl   !    must be media.tbl
      record /SmpCnst/ cnst  ! must be media.cnst

c

      call epRdmuBrCnst(io, cnst)

c            total x-sec. v> vmin
      if(cnst.muBrTXT .gt. mxMuBrTX) then
         call cerrorMsg(
     *   'mu pair cre. total X-sec table too large',0)
      endif
c        total x-sec
      call epRd1dTbl(io,  tbl.MuBrTX, cnst.muBrTXT)
c        dE/dx/E (/(g/cm2)
      call epRd1dTbl(io,  tbl.MuBrdEdx0, cnst.muBrTXT)
c        dE/dx/E (/(g/cm2))
      call epRd1dTbl(io,  tbl.MuBrdEdxt, cnst.muBrTXT)
c
c         sampling table
c      if( cnst.muBrUsize * cnst.muBrEsize .gt. mxMuBrTbl) then
c         call cerrorMsg(
c     *   'muon pair cre. sampling table too large', 0)
c      endif
c      call  epRd2dTbl(io,  tbl.MuBrTbl, 
c     *       cnst.muBrUsize, cnst.muBrEsize)
c
      end
      subroutine epRdmuNSTbl(io, cnst, tbl)
      implicit none
#include "ZbpSample.h"
#include "ZbpTbl.h"

c
      integer io
      record /bpTbl/tbl   !    must be media.tbl
      record /SmpCnst/ cnst  ! must be media.cnst

c

      call epRdmuNCnst(io, cnst)

c            total x-sec. v> vmin
      if(cnst.muNTXT .gt. mxMuNTX) then
         call cerrorMsg(
     *    'mu Nuc.int Total X-sec table too large',0)
      endif
c        total x-sec
      call epRd1dTbl(io,  tbl.MuNTX, cnst.muNTXT)
c        energy dependence
      read(io, *) cnst.muNpwtx
c        dE/dx/E (/(g/cm2)
      call epRd1dTbl(io,  tbl.MuNdEdx0, cnst.muNTXT)
c         energy dependence
      read(io, *) cnst.muNpwdEdx0
c        dE/dx/E (/(g/cm2))
      call epRd1dTbl(io,  tbl.MuNdEdxt, cnst.muNTXT)
c         energy dependence
      read(io, *) cnst.muNpwdEdxt
c
c         sampling table
      if( cnst.muNUsize * cnst.muNEsize .gt. mxMuNTbl) then
         call cerrorMsg(
     *   'muon nuc. int sampling table too large', 0)
      endif
      call  epRd2dTbl(io,  tbl.MuNTbl, 
     *       cnst.muNUsize, cnst.muNEsize)

      end

      subroutine epRdmuPrCnst(io, cnst)
      implicit none
#include  "ZbpSample.h"
#include  "ZepManager.h"
      record /SmpCnst/ cnst

      integer io
      character*160 msg
 
      read(io, '(a)') msg
      if(MsgLevel -1 .ge. 0) then
         call cerrorMsg(msg, 1)
      endif
      read(io, *)  
     *  cnst.muPrVmin, cnst.muPrdETX, cnst.muPrdE, cnst.muPrEmin,
     *  cnst.muPrEmax, cnst.muPrdU, cnst.muPrUsize, cnst.muPrEsize,
     *  cnst.muPrTXT, cnst.muPrEmax1

      read(io, *)
      end

      subroutine epRdmuBrCnst(io, cnst)
      implicit none
#include  "ZbpSample.h"
#include  "ZepManager.h"
      record /SmpCnst/ cnst

      integer io
      character*160 msg
 
      read(io, '(a)') msg
      if(MsgLevel -1 .ge. 0) then
         call cerrorMsg(msg, 1)
      endif
      read(io, *)  
     *   cnst.muBrVmin, cnst.muBrdETX, cnst.muBrdE, cnst.muBrEmin,
     *   cnst.muBrEmax,  cnst.muBrdU, cnst.muBrUsize, cnst.muBrEsize,
     *   cnst.muBrTXT, cnst.muBrEmax1

      read(io, *)
      end


      subroutine epRdmuNCnst(io, cnst)
      implicit none
#include  "ZbpSample.h"
#include  "ZepManager.h"
      record /SmpCnst/ cnst

      integer io
      character*160 msg
 
      read(io, '(a)') msg
      if(MsgLevel -1 .ge. 0) then
         call cerrorMsg(msg, 1)
      endif
      read(io, *)  
     *   cnst.muNVmin,  cnst.muNdETX, cnst.muNdE,  cnst.muNEmin,
     *   cnst.muNEmax,  cnst.muNdU, cnst.muNUsize, cnst.muNEsize,
     *   cnst.muNTXT, cnst.muNEmax1

      read(io, *)
      end
