c     ****************************************************************
c     *
c     * epphotoEp: Photo electric effect prob. per r.l
c     * epphotoEe: samples energy of Photo-electron 
c     *
c     ****************************************************************
c
c
c
       subroutine epphotoEp(pe, eg, prob, path)
       implicit none
#include "ZbpPE.h"
#include "Zmass.h"

       record /photoE/pe  ! input. p.e const

       real*8 eg    ! input. gamma energy in GeV 
       real*8 prob  ! output. prob. per r.l 
       real*8 path  ! output. sampled path in r.l 

       real*8  eout  ! output.  energy of photo electron in GeV
       real*8 ep, tp
c

       real*8 epi, u



c

       ep=eg/masele

       if(pe.a + eg .le. masele ) then
          prob = 1.d-35
       else
          epi=1./ep
          tp= ( (pe.b2*epi + pe.b1)*epi + pe.b0 ) *
     *       pe.fa* pe.p * epi
          if(eg .lt. pe.ek ) then
             tp=tp/pe.l
          endif
          prob = tp
       endif
       call rndc(u)
       path = -log(u) / prob

       return

c      ************
       entry epphotoEe(pe,  eg, eout)
c      ************
c
       eout=eg + pe.a
       end
