c     ****************************************************************
c     *                                                              *
c     * dpdedxe:  gives -de/dx  (gev/(g/cm2) of   e-/e+
c     *                                                              *
c
c
c
      subroutine epdedxe(sh,  aPtcl, dedt)
      implicit none
#include "Zstern.h"
#include "Zptcl.h"
#include "Zmass.h"

      record /sternh/sh    !  input. Sternheimer's consts
      record /ptcl/ aPtcl  !  input. a Particle (e- or e+) 
      real*8  dedt ! output.  dE/dt GeV/(g/cm^2)

      real*8 emass
      real*8 E, gi, Beta2, x, cb
      real*8 dltx, wm, wlg


      real*8 bbbeta2, lindbeta2, truebeta2
      real*8 bbbeta, lindbeta
      real*8 logbbbeta, loglindbeta
      real*8 a, b, c, xx, gra
      parameter (bbbeta = 0.1d0,  lindbeta = 0.01d0, gra=4.0d0/3.d0)
      parameter (bbbeta2 = bbbeta**2, lindbeta2=lindbeta**2)
      parameter (logbbbeta =-2.302585093E+00,
     *           loglindbeta = -4.605170186E+00)
      parameter (a = (1.+gra)/2.d0/(logbbbeta-loglindbeta),
     *           b = 2*a*loglindbeta + 1.) 
c

      parameter (emass = masele*1000.d0)


c       Energy, mass=emass  in MeV unit
      E = aPtcl.fm.p(4)*1000.d0
      gi= emass/E
      truebeta2= 1. - gi**2
      if(truebeta2 .lt. bbbeta2) then
         Beta2 = bbbeta2
         wm = emass*Beta2/2
         E = emass*(1.+Beta2/2)
      else
         Beta2 = truebeta2
         wm=E- emass
      endif
c       x=log10(p/mc)
      x=log10( (E/emass)**2 - 1. ) / 2
      cb=-sh.c
      if(x .lt. sh.x0) then
c        4.605x - dlt
         dltx=4.605*x
      elseif(x .lt. sh.x1) then
         dltx=cb - (sh.x1-x)**3 * sh.sa
      else
         dltx=cb
      endif

c      if(Knckon) then 
c              Now we dont used Knckon, since big wm can
c            do the equivalent
         if(wm .gt. sh.w0) then
            wlg =sh.wlg0
         else
            wlg = log(wm)
         endif
c      else
c         wlg=log(wm)
c      endif

       if(aPtcl.charge .eq. -1) then
          dedt=sh.a/Beta2 * (sh.b + 1.12 + wlg-Beta2 + dltx)
       else
          dedt=sh.a/Beta2 *( sh.b+.693+wlg -2*Beta2 + dltx)
       endif

      if(truebeta2 .lt. bbbeta2) then
         c = log(dedt) + ( a* logbbbeta - b )*logbbbeta
         if( truebeta2 .gt.  lindbeta2) then
            xx = log( truebeta2 )/2.
            dedt =exp( (-a*xx + b)*xx + c)
         else
            dedt = exp( (-a*loglindbeta + b)* loglindbeta + c) *
     *             sqrt(truebeta2)/lindbeta
         endif
      endif
c///////////////
c      write(23,*) sngl( aPtcl.fm.p(4)  - aPtcl.mass), sngl(dedt),
c     *      sngl(sqrt(truebeta2)), aPtcl.code, aPtcl.charge
c
c///////////////
c          convert it to gev/(g/cm2)
       dedt=dedt *1.d-3

       end




