c     ****************************************************************
c     *                                                              *
c     * epdedxNone: gives -de/dx  (gev/(g/cm2)) of non e+/e-
c     *                                                              *
c
c
c
      subroutine epdedxNone(sh, aPtcl, dedt)
      implicit none
#include "Zmedia.h"
#include "Zptcl.h"
#include "Zmass.h"
      real*8 emass, emass2 

c       MeV unit electron mass.
      parameter(emass = masele*1000., emass2=emass**2)

      record /sternh/sh         ! input. Sternheimer's consts 
      record /ptcl/aPtcl        ! input. a particle

      real*8 dedt               ! output. Energy loss rate.   GeV / (g/cm2). 

 
      real*8  E,  mass, gi, Beta2, x,  cb
      real*8 dltx, p2, wm, wlg
      real*8 bbbeta2, lindbeta2, truebeta2
      real*8 bbbeta, lindbeta
      real*8 logbbbeta, loglindbeta
      real*8 a, b, c, xx, gra
      parameter (bbbeta = 0.1d0,  lindbeta = 0.005d0, gra=5.d0/3.d0)
      parameter (bbbeta2 = bbbeta**2, lindbeta2=lindbeta**2)
      parameter (logbbbeta =-2.302585093E+00,
c     *           loglindbeta =-4.605170186E+00)
     *           loglindbeta =-5.298317367E+00)
      parameter (a = (1.+gra)/2.d0/(logbbbeta-loglindbeta),
     *           b = 2*a*loglindbeta + 1.) 
c
c               energy in MeV unit
      E = aPtcl.fm.p(4)*1000.
      mass= aPtcl.mass*1000.
      gi=mass/E
      truebeta2 = 1. - gi**2
      if(truebeta2 .lt. bbbeta2) then
         Beta2 = bbbeta2
         E = mass*(1. + Beta2/2)
      else
         Beta2 = truebeta2
      endif

c          x=log10(p/mc)
         x=log10((E/mass)**2 - 1.) / 2
         cb=-sh.c
         if(x .lt. sh.x0 ) then
c                  4.605x - dlt
            dltx=4.605*x
         elseif(x .lt. sh.x1) then
            dltx=cb - (sh.x1-x)**3 * sh.sa
         else
            dltx=cb
         endif
         p2=E**2 -mass**2
         wm = 2* emass * p2 /(  mass**2+ emass2 + emass*E*2)
c        if(Knckon) then  
c              Knckon is not used now, since knckon=f can be
c              realized by putting very large w0
            if(wm .gt. sh.w0) then
               wlg = sh.wlg0
            else
               wlg=log(wm)
            endif
c         else
c           wlg=log(wm)
c         endif
         
         dedt=sh.a/Beta2 *( sh.b+.693+wlg -2*Beta2 + dltx)

      if(truebeta2 .lt. bbbeta2) then
         c = log(dedt) + ( a* logbbbeta - b )*logbbbeta
         if( truebeta2 .gt.  lindbeta2) then
            xx = log( truebeta2 )/2.
            dedt =exp( (-a*xx + b)*xx + c)
         else
            dedt = exp( (-a*loglindbeta + b)* loglindbeta + c) *
     *             sqrt(truebeta2)/lindbeta
         endif
      endif
c         x  Z**2 and to GeV unit
      dedt=dedt * aPtcl.charge**2 * 1.d-3
c///////////////
c      write(22,*) sngl( aPtcl.fm.p(4)  - aPtcl.mass), sngl(dedt),
c     *            sngl(sqrt(truebeta2))
c///////////////
      end
c     *********************
c        For the organic scintillator, the energy loss by
c      heavy particles or slow particles is not converted to
c      photons  as efficiently as the one by relativistic electrons.
c      This subroutine gives a correction factor for the energy loss,
c      so that you can get effective energy loss by multiplying
c      cf by the true energy loss.
      subroutine epOrgCorrec(media, aPtcl, dedx, cf)
      implicit none
#include "Zmedia.h"
#include "Zptcl.h"
#include "Zmass.h"

      record /epmedia/ media  ! input.
      record /ptcl/ aPtcl   ! input.
      real*8  dedx   ! input.  dE/dx (GeV/(g/cm^2) for the partcle
      real*8  cf     ! output. correction factor. dE_eff = cf x dE_true

      real*8 c1
      c1 = media.BirksC1
      if( abs( aPtcl.charge ) .gt. 1)  then
        c1 = c1 * media.BirksCC
      endif
      cf = 1./(1. + c1 * dedx + media.BirksC2 * dedx**2)
      end



       

