c     ****************************************************************
c     *                                                              *
c     * epX0Old:  compute radiation length of given matter            *
c     *                                                              *
c     *********************** tested 80.07.11 ************************
c
c   /usage/
c            call epX0Old(z, a, x0g)
c
c    z:  charge of the matter
c    a:  mass no.
c  x0g:  //                           g/cm**2
c
c
c     *** note ***
c
c         correction to born approximation is not included in this
c         r.l so it must be included in the cross-section.
c
c
c
      subroutine epX0Old(z, a, x0g)
c
c         cnst=
c         4/137* r0**2 * n  where r0 is the classical electron radius
c                           n the avogadro number
c                           r0=2.8176e-13 cm
c                           n=6.0247
c
      data  cnst/1.396e-3/
c
      z3=z**(-0.3333333)
      alogz3=alog( 183.* z3 )
      gzai=alog(1440. * z3**2 ) /  alogz3
c        inverse of r.l in g/cm**2
      t0inv=cnst / a  *  z*( z + gzai ) * alogz3
c
      x0g=1. / t0inv
      end



