      subroutine epSetSTblCns(media, cnst)
      implicit none
#include "Zmedia.h"

      record /epmedia/media  ! input. 
      record /SmpCnst/ cnst   ! output. must be media.cnst



c         Energy above which we can use complete screening 
c       cross-sections. evaluate at Eg/Ee=x= 0.99.
c       30 is marging.  This can be applied to pair creation, too.

      cnst.CompScrE =  !  30.0*( 0.05*0.99/0.01/media.Zeff**0.333)
     *              150.0/media.Zeff**0.333
c
c
      cnst.BremEgmin = 100.d-6  ! Eg min  100 keV
      cnst.BrEgminS = 10.d-6    ! Eg min for Seltzer case 10 keV
c
c       For Seltzer data
c
      cnst.BrEeminS = 711.d-6  ! below this, brems is neglected 
      cnst.BrLEeminS = log10(cnst.BrEeminS)
      cnst.BrEemaxS  = 0.1d0   ! 100 MeV; use Seltzer data at < this E
c          table size for Energy
      cnst.BrTXTS = 
     *   log10(cnst.BrEemaxS/cnst.BrEeminS)*10
      cnst.BrES = cnst.BrTXTS

      cnst.BrUminSA = 0.1d0
      cnst.BrUmaxSA = 1.0
      cnst.BrUszSA = 20
      cnst.BrdUSA =
     *    (cnst.BrUmaxSA-cnst.BrUminSA)/
     *      (cnst.BrUszSA-1)

      cnst.BrdETXS = 
     *  log10(cnst.BrEemaxS/cnst.BrEeminS)/
     *                (cnst.BrTXTS-1)
      cnst.BrdES =
     *   log10(cnst.BrEemaxS/cnst.BrEeminS)/
     *    ( cnst.BrES-1)
      cnst.BrUszSB = 21
      cnst.BrUminSB = 0.
      cnst.BrUmaxSB = cnst.BrUminSA**0.25d0
      cnst.BrdUSB =
     *   (cnst.BrUmaxSB-cnst.BrUminSB)/
     *     (cnst.BrUszSB-1) 
c
c   +++++++++++++++++++++++++++++++Old version++(before release; 1998.Nov.14)
c
c             100MeV     CompScrE       EemaxL          BrEe2H
c                        BrScrE
c     <--------|-----------|--------------|---------------|--------->
c     Seltzer    Partial       Comp.Scr     CompScr+LPM    CompScr+LPM
c                Screening     rejection    by Table       by rejection
c                Table 
c
c
c            if CompScrE > EemaxL (say, Pb)
c       
c             100MeV     EemaxL     CompScrE         BrEe2H
c                        BrScrE
c     <--------|-----------|----------|---------------|--------->
c     Seltzer    Partial           CompScr+LPM          CompScr+LPM
c               Screening           by Table            by rejection
c               Table 
c    ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

c    ====================New version========================(1998/Nov.15)
c
c            100MeV    BrScrE    EemaxL             BrEe2H
c                                CompScrE
c     <--------|---------|---------|-----------------|-------->
c     Seltzer    Partial   Partial      CompScr+LPM    CompScr+LPM
c                Screening  +LPM        by Table       by rejection
c                Table     Table
c
c    Note:  if  BrScrE < 100 MeV, pure partial scr. by table is not used.

c
c
c   In somecase (say for Air, or very thin matter)
c
c                          ~75GeV          ~100GeV  <-- Air
c            100MeV     CompScrE           EemaxL    BrEe2H
c                         BrScrE
c     <--------|------------|------------------|-----------|-------->
c     Seltzer    Partial      Comp.Scr          CompScr+LPM    CompScr+LPM
c                Screening    rejection         by Table       by rejection
c                Table 
c
c   3 Sampling tables will be created:

c     Seltzer region  (possibly with LPM)  Ee < BrEemaxS          T
c     Partial screening region (possibly with LPM)  Ee <CompScrE  T
c     complete screening region       CompScrE < Ee < EemaxL      R
c     (may not exist)
c     LPM region                      EemaxL  <  Ee BrEe2H        T

c
c     BrScrE is determined by min(ComScrE, EemaxL)
c     EemaxL is the energy below which the LPM works 
c     only for Eg/Ee < 10^-5, so that we may neglect the effect.
c
c      combining both, we may judge as follows:
c 
c     Ee < EemaxS    ==> Seltzer table (normally <100 MeV)
c     Ee < ScrE      ==> partial screening only (may not exits)
c     Ee < CompScrE  ===>partial sc.+LPM        (may not exits)
c     Ee < EemaxL    ===> complete sc. only by rejection (may not exits)
c     Ee < Ee2H      ===> complete sc.+ LPM  table
c     Ee > Ee2H      ===> comp. + LPM  by rejection
c===================================================================
c


c           ordinary brems region
c
      cnst.BremEemin = 10.d-3  ! 10 MeV. below this, don't make table
      cnst.BremLEemin = log10(cnst.BremEemin)
c         LPM effect at small x=Eg/Ee appears at this Ee
c         so that cross section without LPM should not be
c         used above this.
c      cnst.BremEemaxL  = 5 * 11.35/media.rho === old version
c           below this, LPM works only for Eg/Ee < 10^-5 and 
c           we can safely neglect the effect.
      cnst.BremEemaxL  = 0.01 * 11.35/media.rho     
c         we may use screened brems cross-section below BrScrE
c         without LPM correction
      cnst.BrScrE = min(cnst.CompScrE,  cnst.BremEemaxL)
c         redefine EemaxL; at BrScrE < Ee < CompSceR, we must use
c         partial screening + LPM
      cnst.BremEemaxL = max(cnst.BremEemaxL, cnst.CompScrE)
c          table size for Energy
c      cnst.BremTXTL = 
c     *   log10(cnst.BrScrE/cnst.BremEemin)*10
      cnst.BremTXTL = 
     *   log10(cnst.CompScrE/cnst.BremEemin)*10
      cnst.BremEsize = cnst.BremTXTL

      cnst.BremUminLA = 0.1d0
      cnst.BremUmaxLA = 1.0
      cnst.BremUszLA = 20
      cnst.BremdULA =
     *    (cnst.BremUmaxLA-cnst.BremUminLA)/
     *      (cnst.BremUszLA-1)

c      cnst.BremdETXL = 
c     *  log10(cnst.BrScrE/cnst.BremEemin)/
c     *                (cnst.BremTXTL-1)
      cnst.BremdETXL = 
     *  log10(cnst.CompScrE/cnst.BremEemin)/
     *                (cnst.BremTXTL-1)
c      cnst.BremdEL =
c     *   log10(cnst.BrScrE/cnst.BremEemin)/
c     *    ( cnst.BremEsize-1)
      cnst.BremdEL =
     *   log10(cnst.CompScrE/cnst.BremEemin)/
     *    ( cnst.BremEsize-1)
      cnst.BremUszLB = 21
      cnst.BremUminLB = 0.
      cnst.BremUmaxLB = cnst.BremUminLA**0.25d0
      cnst.BremdULB =
     *   (cnst.BremUmaxLB-cnst.BremUminLB)/
     *     (cnst.BremUszLB-1) 
c      ------------------------------------
      cnst.PairEgmin =  1.1d-3
      cnst.PairNonSc = 8.d-3

      cnst.PairLEgmin = log10(cnst.PairEgmin) 

c         LPM effect  appears at this Eg
c         so that cross section without LPM should not be
c         used above this.
      cnst.PairEgmaxL = 3000.*11.35/media.rho

c         we should use screened pair cross-section below this
      cnst.PrScrE = min(cnst.CompScrE,  cnst.PairEgmaxL)

      cnst.PairTXTL = 
     *   log10(cnst.PrScrE/cnst.PairEgmin)*10
      cnst.PairEsize = cnst.PairTXTL
      cnst.PairUminLA  = 0.05d0
      cnst.PairUmaxLA = 1.
      cnst.PairUszLA = 21
      cnst.PairdULA = 
     *  (cnst.PairUmaxLA-cnst.PairUminLA)/
     *  (cnst.PairUszLA-1) 
      cnst.PairdETXL =
     *  log10(cnst.PrScrE/cnst.PairEgmin)/
     *   (cnst.PairTXTL-1)
      cnst.PairUminLB = 0.
      cnst.PairUmaxLB =   cnst.PairUminLA**0.25d0
      cnst.PairUszLB = 21
      cnst.PairdULB =
     * (cnst.PairUmaxLB-cnst.PairUminLB)/
     *   (cnst.PairUszLB-1)
      cnst.PairdELA = 
     * log10(cnst.PrScrE/ cnst.PairEgmin) /
     *  (cnst.PairEsize-1)
      cnst.PairdELB=
     *      sqrt( log10(cnst.PrScrE/cnst.PairEgmin) )
     *     /( cnst.PairEsize-1)
c      --------------------------------------------------

c              LPM region; Brems

      cnst.BrEe1H =  cnst.BremEemaxL 
      cnst.BrEgminH =max( 1.d-4, cnst.BrEe1H*1.d-5) ! x< 1.d-5 is neglected
      cnst.BrLEe1H = log10( cnst.BrEe1H )
      cnst.BrneH = 50

      cnst.BrdEH = .10d0  ! log E step
c              last 2  means  for 2D table
      cnst.BrneH2 = 50
      cnst.BrdEH2 = 0.075d0
c       cnst.BrdEH= log10(cnst.BrEe2H/cnst.BrEe1H)/(cnst.BrneH-1)
c       inverse of the above
      cnst.BrEe2H =10.d0**( cnst.BrdEH *(cnst.BrneH-1)) *
     * cnst.BrEe1H

      cnst.BrEe2H2 =10.d0**( cnst.BrdEH2 *(cnst.BrneH2-1)) *
     * cnst.BrEe1H


      cnst.BrdU1H= 0.05d0


      cnst.BrU1H=0.2d0
      cnst.BrU2H=1.0d0
      cnst.Brnu1H=(cnst.BrU2H-cnst.BrU1H+0.00001d0)/cnst.BrdU1H+1
c           ....................
c                                 
      cnst.BrPow = 4.0
      cnst.BrU3H = .0
      cnst.BrU4H = cnst.BrU1H**(1.d0/cnst.BrPow)
      cnst.Brnu2H = 16
      cnst.BrdVU2H = cnst.Brnu2H-1
      cnst.BrdU2H =  (cnst.BrU4H - cnst.BrU3H)/cnst.BrdVU2H

c           LPM region, pair

      cnst.PrEg1H =  cnst.PairEgmaxL 
      cnst.PrLEg1H = log10( cnst.PrEg1H )
      cnst.PrneH = 25
      cnst.PrdU1H= 0.025d0
      cnst.PrdEH = .1d0  ! log E step

      cnst.PrU1H=0.
      cnst.PrU2H=1.0
      cnst.Prnu1H=(cnst.PrU2H-cnst.PrU1H+0.00001d0)/cnst.PrdU1H+1
      cnst.PrEg2H =10.d0**( cnst.PrdEH *(cnst.PrneH-1)) *  
     * cnst.PrEg1H
c            for muon 
      call epSetmuSTab(media, cnst)
      end
