c       ***************************************************************
c       *
c       *  epExpot:  compute excitation potential (in eV)
c       *            consisting of n different atoms.
c          
c         ---------------------------------
c          must be called after epGetEffZA
c         ---------------------------------
c       *
c
c /usage/ call epExpot(media)
c      
c           see p.r. b vol3 (1971)3681 sternheimer.  c

       subroutine epExpot(media)
       implicit none
#include "Zmedia.h"

       record /epmedia/media  !  input.  data  given by basic table must
                            !          be ready
                            !  output. media.I. ionization potential in GeV

       integer n

       integer i
       real*8 sumli, expi

       sumli=0.



       n = media.noOfElem

       do  i = 1, n
          if(media.elem(i).Z .eq. 1) then
             expi=18.7
          elseif(media.elem(i).Z .lt. 13.0) then
             expi=13.*media.elem(i).Z
          else
             expi=media.elem(i).Z *( 9.76 + 58.8*
     *            media.elem(i).Z**(-1.19))
          endif
          sumli=sumli + 
     *       media.elem(i).Z* media.No(i)/media.Z * log(expi)
       enddo
       media.I = exp(sumli)*1.d-9
       end
