      subroutine epBrSampP(media, Ee, prob, path)
c          generic brems sampling routine
      implicit none
#include "Zmedia.h"

      record /epmedia/media  ! input.
      real*8 Ee            ! input. Electron/positron energy in GeV
      real*8 prob          ! output. Brems prob. per r.l
      real*8 path          ! ouptut. sampled path in r.l

      real*8 u

      if(Ee .le. media.cnst.BrEemaxS) then
c            Seltzer region
         call epBrSSampP(media, Ee,  prob)

c      elseif(Ee .le. media.cnst.BrScrE) then
      elseif(Ee .le. media.cnst.CompScrE) then
c            screeinig region
         call epBrLSampP(media, Ee,  prob)

      elseif(Ee .le. media.cnst.BremEemaxL) then
c            complete screeing region
         call epBrCSampP(media, Ee, prob)

      else
c            LPM region
         call epBrHSampP(media, Ee, prob)

      endif
      call rndc(u)
      path = - log(u)/prob
      end
c     *********************************** 
      subroutine epBrSampE(media, Ee, Eg)
      implicit none
#include "Zmedia.h"

      record /epmedia/media  ! input.
      real*8 Ee            ! input. e-/e+ energy in GeV
      real*8 Eg            ! output. sampled Eg in GeV



      if(Ee .le. media.cnst.BrEemaxS) then
c            Seltzer region
         call epBrSSampE(media, Ee,  Eg)

      elseif(Ee .le. media.cnst.CompScrE) then
c            screeinig region
         call epBrLSampE(media, Ee,  Eg)

      elseif(Ee .le. media.cnst.BremEemaxL) then
c            complete screeing region
         call epBrCSampE(media, Ee, Eg)

      else
c            LPM region
         call epBrHSampE(media, Ee, Eg)

      endif
      end
