      subroutine epBrSSampP(media, Ee, prob)
c          brems prob. sampling by Seltzer data.
      implicit none
#include "Zmedia.h"
      record /epmedia/media
      real*8 Ee
      real*8 prob  ! output probability of Brems / X0

      real*8 ale


      if(Ee .le. media.cnst.BrEeminS) then
         prob= 1.d-40
      else
         ale=log10(Ee)
         call kintp3(media.tbl.BrTXS,
     *   1, media.cnst.BrTXTS, media.cnst.BrLEeminS,
     *   media.cnst.BrdETXS, ale, prob) 
      endif
      end
c     ************
      subroutine epBrSSampE(media, Ee, Eg)
c     ************
c         brems energy by Seltzer
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
      record /epmedia/media
      real*8 Ee,  Eg

      real*8 u, ale, us, ans

      call rndc(u)
      ale = log10(Ee)
      if(u .gt. media.cnst.BrUminSA) then
c          region A

         call k4ptdi(media.tbl.BrSTSA, 
     *        media.cnst.BrUszSA, 
     *        media.cnst.BrES,
     *        media.cnst.BrUszSA, 
     *        media.cnst.BrUminSA,
     *        media.cnst.BrLEeminS,
     *        media.cnst.BrdUSA,
     *        media.cnst.BrdES, u,  ale,  ans)  
         Eg= exp( ans*(1.-u))*media.cnst.BrEgminS
      else
c         region B
         us = u**0.25d0

         call k4ptdi(media.tbl.BrSTSB, 
     *        media.cnst.BrUszSB, 
     *        media.cnst.BrES,
     *        media.cnst.BrUszSB, 
     *        0.d0,
     *        media.cnst.BrLEeminS,
     *        media.cnst.BrdUSB,
     *        media.cnst.BrdES, us,  ale,  ans)  
         Eg = exp(-ans*u)*(Ee-masele)
c           above sould be correct. below was used 
c           <= uv6.50
c         Eg = exp(-ans*u)*Ee
      endif
      end

