#include "ZepMaxdef.h"
#include "Zelement.h"
#include "ZbpTbl.h"
#include "Zstern.h"         
#include "ZbpSample.h"
#include "ZbpPE.h"
#include "Zurban.h"
#include "Zmubpn.h"


         integer maxElements
         parameter (maxElements=MAX_ELEMENTS)
         structure /epmedia/
            integer noOfElem          ! actual number of elements
            record /element/elem(maxElements)
            real*8  No(maxElements)  ! number of each element
                                         ! in the molecule; if a mixture of
               ! molecules/atoms,(volume fraction of each molecule/atom) times 
               ! number of each element  in the molecule.
               ! E.g:  H2O --> 2, 1 .  Air, say,  79% N2, 20% O2 and 1% Ar
               ! by volume, 0.79x2, 0.20x2, 0.01
               ! This is later normalized so that the sum be 1.0
            real*8  w(maxElements)  !  No(i)A(i)/sum(No(i)A(i))
            real*8  sigma(nxsec)     !  sum No(j)*elem(j).sigma(i), i=1,nxsec
            real*8  cumsigma(maxElements, nxsec) !
                 !      cumulative  sum(j) of 
                 !      No(j).elem(j).sigma(i)/sigma(i) for j=1, nxsec
                 !
            integer mbindex     ! Let hp xsec at a gvien energy be shp
                        ! shp can be converted into hA Xsec for the media.
                        ! mbindex is such that 
                        ! meida.sigma(j) <= hAxsec<meida < media.sigam(j+1)
            real*8  ndensity         !  effective number density /cm^3
            real*8  wp    ! plasma frequency  x hbar (GeV)
            real*8  n     ! reflactive index
            real*8  nd    ! number of ingredients / cm^3 
            real*8  A     ! sum No x  Ai
            real*8  Z     ! sum No x  Zi
            real*8  Z2    ! sum No x  Zi**2
            real*8  mbtoPgrm ! 10^-27 x N0/A. If multiplied to sigma in mb,
                           !  we obtain probability / (g/cm2).
            real*8  mbtoPcm  ! rho x mbtoPgrm. If multiplied to sigma in mb, 
                           ! we obtaind probability / cm
            real*8  mbtoPX0  ! mbtoPgrm x X0g.  If multiplied to sigma in mb, 
                             !  we obtain probability /radation length.
c                            next ones are used when we approximate
c               a compound /molecule as an atom
            real*8  mbtoPgrm2
            real*8  mbtoPcm2
            real*8  mbtoPX02 

            real*8  Z2byAeff !  sum wi x  Zi**2/Ai
            real*8  Z5byAeff !  sum wi x  Zi**5/Ai
            real*8  Aeff  ! sum wi x Ai
            real*8  Z2eff ! Z2byAeff x Aeff
            real*8  Zeff  ! sqrt(Z2eff)
            real*8  Zeff3 ! Zeff**(1/3)
            real*8  LogZ  ! log(Zeff) 
            real*8  A2eff ! sum wi x Ai^2
            real*8  ZbyAeff ! sum wi x Zi/Ai
            real*8  I     !  average ionization potential energy in GeV.
            real*8  rho   ! density in g/cm^3
            real*8  X0    ! radiation length.  in cm
            real*8  X0g   ! radiation length.  in g/cm^2
            real*8  gtocm ! g/cm^2 to cm. 
            real*8  dEdxatp3m ! dE/dx at p=3me for electron. ~ Ecrit
            integer gasF  ! flag for gas. If  1, media is gas,  0 -->solid
            character*8  name  ! name of media
            integer  format    ! format of the  basic table. (1 or 2)
            real*8  s1         ! Migdal's s1
            real*8  logs1      ! log(s1) 
            real*8  basearea   ! pi x Re**2 * N* Z /A *X0g  = 0.15 Z/A*X0g
            real*8  cScrC1     ! const which appears in the complete screening
                               ! crossection
            real*8  cScrC2     ! the other such one
            real*8  cScrMain   ! (4/3C1 + C2)
            real*8  BirksC1    ! Birks' C1 (13 g/GeV/ cm2) for organic scinit.
            real*8  BirksC2    ! //     C2 (9.6 (g/GeV/cm2)^2 ..
            real*8  BirksCC    ! // correction factor for C1 for heavy particles (0.5714)
            record /bpTbl/  tbl
            record /sternh/ sh
            record /SmpCnst/ cnst
            record /photoE/ pe
            record /urban/ urb
            record /mubpn/ mu 
         end structure

