c  
c     *******************************************
c
      subroutine epCreBrSTblS(mediain, cnst)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"
c     *                                                             
c     *       create sampling table for Bremstrahlung 
c     *       at low energies using Seltzer's data

c
      record /epmedia/mediain  !  media
      record /SmpCnst/ cnst  ! must be media.cnst
c

c
      integer ws
      parameter (ws = 10000)
      real*8 work(ws), work2(ws)
c        cp mediain into common area
      media = mediain
      call epwtBrCnstS(cnst)

c            total x-sec.
      if( cnst.BrTXTS  .gt. mxBrTXS) then
         call cerrorMsg(
     *     'too large total X-sec.table for Seltzer bresm', 0)
      endif
      call epCreBrTXTS(cnst, work, work2, cnst.BrTXTS)

c           sampling table in A region
      if( cnst.BrUszSA * cnst.BrES .gt. mxBrTblSA) then
         call cerrorMsg('brem table for SA is too large', 0)
      endif
      call  epCreBrSA(cnst, work, cnst.BrUszSA, cnst.BrES)

c           sampling table in B region
      if( cnst.BrUszSB * cnst.BrES  .gt. mxBrTblSB) then
         call cerrorMsg('brem table for SB is too large', 0)
      endif
      call  epCreBrSB(cnst, work, cnst.BrUszSB, cnst.BrES)
      end

c     ****************************************
      subroutine epCreBrTXTS(cnst,  erg, tbl, size)
c     ****************************************
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      record /SmpCnst/ cnst  ! must be media.cnst
      integer size
      real*8  tbl(size), erg(size)

      real*8 E,  vmax, vmin,  tcb, de
      character*160 msg
      integer i



      write(msg,*) ' Matter=', media.name,
     *  ': Computing the total Xsec of Seltzer Brems from Ee= ',
     *    cnst.BrEeminS, ' GeV'
      call cerrorMsg(msg, 1)
      E = cnst.BrEeminS
      de = 10.d0**cnst.BrdETXS
      do   i=1, size
         Eeme = E/masele
c         vmax=1.d0
c         vmin=cnst.BrEgminS/(E-masele)
         vmax = 1.d0 - masele/E
         vmin=cnst.BrEgminS/E
         if(vmin .ge.  vmax) then
            call cerrorMsg('Eg/E <= vmin', 0)
         endif
c         call eptotcbS(vmin,  vmax,  tcb)
         call epBrgeneTX(vmin,  vmax,  tcb)
         tbl(i) = tcb* media.mbtoPX0  ! prob. per radiation length.
         erg(i) = E
         E = E * de
      enddo
      write(msg, *) 'Table has been made up to  E=', E/de,' GeV'
      call cerrorMsg(msg, 1)
      write(msg, *) 'Seltzer Brems total X-sec. table upto E=',
     *     E/de,' GeV'
      call epwt1dTbl(msg, erg,  tbl, size, media.name)

      end

c     **********************************************
      subroutine epCreBrSA(cnst, bla, sizeu,  sizee)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      record /SmpCnst/ cnst  ! must be media.cnst
      integer sizeu, sizee 
      real*8  bla(sizeu,  sizee)

      real*8 de1, E, vmin, vl, vr, u, tcb, vx, tcbx,
     *  eps, v

      external epBrgeneSolv
      real*8  epBrgeneSolv

      real*8  epBrSfs

      character*160 msg
      integer i, iu, j


      common/upsic/upsi, vmax
      real*8 vmax, upsi

      data eps/1.d-5/


      de1 = 10.d0**cnst.BrdES

      E = cnst.BrEeminS    

      write(msg, *) ' Creating Seltzer Brem sampling table: E>=',
     *    cnst.BrEeminS
      call cerrorMsg(msg, 1)
      call cerrorMsg('for small Eg region',1)

      do  i = 1, sizee
         Eeme = E/masele
c         vmin=cnst.BrEgminS/(E-masele)
c         vmax=1.d0
         vmin=cnst.BrEgminS/E
         vmax=1.d0 - masele/E
         
c         call eptotcbS(vmin, vmax, tcb)
         call epBrgeneTX(vmin, vmax, tcb)
         vl=vmin
         vr=vmax
         
         u=cnst.BrUminSA
         
         do  iu=1, sizeu -1
            
            upsi=u*tcb
            call kbchop(epBrgeneSolv, vl, vr, eps, v, j)
            
            if(j.le.0) then
               
               write(0, *) ' cond, E, u=', j, E, u
               do vx = vmin, vmax, (vmax-vmin)/100.d0
c                  call eptotcbS(vx, vmax, tcbx)
                  call epBrgeneTX(vx, vmax, tcbx)
                  write(0, *) vx, tcbx
               enddo
               write(0,*) 'u upsi, vl, vr', u,
     *              upsi, vl, vr,
     *              ' vmin=', vmin, ' tcb=', tcb
               

            endif
            bla(iu,i)= log(v/vmin)/(1.-u)
            u=u + cnst.BrdUSA
            vr = v
         enddo
         bla(sizeu, i)=tcb/vmin/epBrSfs(vmin)
         E =E* de1
      enddo

      call epwt2dTbl(
     *  'Selzter Brems sampling table; log(v/vmin)/(1-u)',
     *   bla, sizeu, sizee)
      call cerrorMsg('the table has been created', 1)
      end

c     ***********************************************
      subroutine epCreBrSB(cnst, blb, sizeu,  sizee)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      record /SmpCnst/ cnst  ! must be media.cnst
      integer sizeu, sizee 
      real*8  blb(sizeu, sizee)

      real*8 de1, E, vmin, vl, vr, u, tcb, 
     *   eps, us, v

      external epBrgeneSolv
      real*8  epBrgeneSolv
      real*8  epBrSfs

      integer  iu, j, ie


      common/upsic/upsi, vmax
      real*8 vmax, upsi

c      data eps/1.d-5/


      call cerrorMsg(
     * 'Creating brems sampling table by Seltzer data for',1)
      call cerrorMsg(' large Eg ',1)

      E = cnst.BrEeminS
      de1 = 10.d0**cnst.BrdES
      do ie = 1, sizee
          Eeme = E/masele
c          vmin=cnst.BrEgminS/(E-masele)
c          vmax=1.d0
          vmin=cnst.BrEgminS/E
          vmax=1.d0- masele/E
c          call eptotcbS(vmin, vmax, tcb)
          call epBrgeneTX(vmin, vmax, tcb)
          vl=vmin
          vr=vmax
          us=cnst.BrUminSB + cnst.BrdUSB
          do   iu = 2,  sizeu
             u=us**4
             upsi=u*tcb
             if(iu .le .6) then
                eps = 1.d-7
             else
                eps = 1.d-5
             endif

             call kbchop(epBrgeneSolv, vl, vr, eps, v, j)
             if(j .le. 0) then
                write(0,'('' E,u='',2g12.3)') E, u
             endif
             blb(iu,ie) = log(vmax/v)/u
             us=us + cnst.BrdUSB
             vr = v
          enddo
          blb(1, ie) = tcb/vmax/epBrSfs(vmax)
          E= E*de1
       enddo
       
       call epwt2dTbl('Seltzer Brems sampling tbl in B; log(v/vmin)',
     *  blb, sizeu, sizee)
       call cerrorMsg('the table has been created', 1)
       end
