c     ****************************************************************
c     *                                                              *
c     * epCreBrSTbH:   create sampling table for brems
c     *            with landau effect at high energies               *
c     *                                                              *
c     ****************************************************************
      subroutine epCreBrSTbH(mediain, cnst)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"
c     *
c
      record /epmedia/mediain  !  media
      record /SmpCnst/ cnst  ! must be media.cnst
c

c
      integer ws
      parameter (ws = 10000)
      real*8 work(ws), work2(ws)
c        cp mediain into common area
      media = mediain
c         print brem const. at high energies
      call epwtBrCnstH(cnst)

c            total x-sec.
      if( cnst.BrneH .gt. mxBrTXH) then
         call cerrorMsg(
     *    'too large LPM Brem total X-section tbl',0)
      endif
      call epCreBrTXTH(cnst, work, work2, cnst.BrneH)
c           sampling table in A region

      if( cnst.Brnu1H*cnst.BrneH2 .gt. mxBrTblHA) then
         call cerrorMsg('brem table for HA is too large', 0)
      endif
      call  epCreBrHA(cnst, work,  cnst.Brnu1H, cnst.BrneH2)


c           sampling table in B region
      if( cnst.Brnu2H*cnst.BrneH2 .gt. mxBrTblHB) then
         call cerrorMsg('brem table for HB is too large', 0)
      endif
      call  epCreBrHB(cnst, work, cnst.Brnu2H, cnst.BrneH2)
      end
c     ****************************************
      subroutine epCreBrTXTH(cnst, erg,  tbl, size)
c     ****************************************
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      record /SmpCnst/ cnst  ! must be media.cnst
      integer size
      real*8  tbl(size), erg(size)

      real*8 E,  vmax, vmin,  tcb, de
      character*160 msg
      integer i


      E = cnst.BrEe1H
      de = 10.**cnst.BrdEH
      do i = 1, size
         Eeme = E/masele
         vmax=1.d0 - masele/ E
         vmin=cnst.BrEgminH/E
         if(vmin .ge.  vmax) then
            call cerrorMsg('Eg/E <= vmin', 0)
         endif
c         call eptotcbH(vmin,  vmax,  tcb)
         call epBrgeneTX(vmin,  vmax,  tcb)
c         tbl(i) = tcb* media.mbtoPX02  ! this is wrong since tcb has been
c                                  normalized already
         tbl(i) = tcb* media.mbtoPX0  ! prob. per radiation length.
         erg(i) = E
         E = E * de
      enddo
      write(msg, *) 
     * 'Matter=',media.name,
     * ' Brems total X-sec. table with C.S+LPM has'//
     * ' been made up to  E=', E/de, ' GeV'
      call cerrorMsg(msg, 1)

      write(msg, *) 'Brems total X-sec. table with C.S+LPM upto E=',
     *  E/de, ' GeV' 
      call epwt1dTbl(msg,  erg, tbl, size, media.name)
      end
c     **********************************************
      subroutine epCreBrHA(cnst, bla, sizeu,  sizee)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      record /SmpCnst/ cnst  ! must be media.cnst
      integer sizeu, sizee
      real*8  bla(sizeu,  sizee)

      real*8 de1, E, vmin, vl, vr, u, tcb, vx, tcbx,
     *   eps, v

      external epBrgeneSolv
      real*8  epBrgeneSolv


      character*160 msg
      integer i, iu, j


      common/upsic/upsi, vmax
      real*8 vmax, upsi

      real*8 sqrtv
      real*8  epBrgenex

      data eps/1.d-5/


      de1 = 10.**cnst.BrdEH2

      E = cnst.BrEe1H

      write(msg, *) ' Creating Brems sampling table with C.S+LPM: E>=',
     *    cnst.BrEe1H
      call cerrorMsg(msg, 1)
      call cerrorMsg('for small Eg region', 1)
      
      do  i = 1, sizee
         Eeme = E/masele
         vmin=cnst.BremEgmin/E
         vmax=1.d0 - masele/E
         sqrtv = sqrt(vmin)
c         call eptotcbH(vmin, vmax, tcb)
         call epBrgeneTX(vmin, vmax, tcb)
         vl=vmin
         vr=vmax

         u=cnst.BrU1H
         do   iu = 1, cnst.Brnu1H-1
            upsi=u*tcb
            call kbchop(epBrgeneSolv, vl, vr, eps, v, j)
            if(j.le.0) then

               write(0, *) ' cond, E, u=', j, E, u
               do vx = vmin, vmax, (vmax-vmin)/100.d0
c                  call eptotcbH(vx, vmax, tcbx)
                  call epBrgeneTX(vx, vmax, tcbx)
                  write(0, *) vx, tcbx
               enddo

            endif
            bla(iu,i)=( sqrt(v) - sqrtv)/(1.d0 -u)
            u=u+cnst.BrdU1H
            vr = v
         enddo
         bla(sizeu ,i)=  tcb/sqrtv/epBrgenex(vmin)/2.0d0
         E =E* de1
      enddo

      call epwt2dTbl('Brems with LPM sampling tbl for small Eg',
     *                bla, sizeu, sizee)
      call cerrorMsg('the table has been created',1)
      end
c     ***********************************************
      subroutine epCreBrHB(cnst, blb, sizeu,  sizee)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      record /SmpCnst/ cnst  ! must be media.cnst
      integer sizeu, sizee
      real*8  blb(sizeu, sizee)

      real*8 de1, E, vmin, vl, vr, u, tcb,
     *   eps, us, v

      external epBrgeneSolv
      real*8  epBrgeneSolv
      


      integer  iu, j, ie


      common/upsic/upsi, vmax
      real*8 vmax, upsi          
      real*8 aa/4.d0/

      real*8  epBrgenex

      call cerrorMsg(
     * 'Creating C.S+LPM brems table for large Eg',1)
      E = cnst.BrEe1H*1.00001d0
      de1 = 10.d0**cnst.BrdEH2
      do ie = 1, sizee
          Eeme = E/masele
          vmin=cnst.BrEgminH/E
          vmax=1.d0 - masele/E

c          call eptotcbH(vmin, vmax, tcb)
          call epBrgeneTX(vmin, vmax, tcb)
          vl=vmin
          vr=vmax
          us= cnst.BrU3H
          do  iu = 2, sizeu
             us = us + cnst.BrdU2H
             u = us**aa
             upsi=u*tcb
             if(iu .le. 3) then
                eps = 1.d-7
             else
                 eps = 1.d-5
             endif
             call kbchop(epBrgeneSolv, vl, vr, eps, v, j)
             if(j .le. 0) then
                write(0,'('' E,u='',2g12.3)') E, u
             endif
             blb(iu,ie) = log(vmax/v)/u
             vr =  v
          enddo
          blb(1, ie) = tcb/epBrgenex(vmax)/vmax
          E= E*de1
       enddo

       call epwt2dTbl(
     * 'Brems with LPM smp tbl; (sqrt(v)-sqrt(vmin)/(1-u)',
     *  blb, sizeu, sizee)
       call cerrorMsg('the talbe has been created', 1)
       end
