	subroutine ksegCutBySq(x1, y1, x2, y2, xc, yc, xL, yL, segp)
c           suppose a given line segment. This compute the length
c           of the segment portion which is contained in 
c           the square
c
	implicit none
	real*8 x1, y1   ! input. one point of the line segment 
	real*8 x2, y2   ! input. another point of the line segment
	real*8 xc, yc   ! input. center of the square
	real*8 xL      ! input.  the x edge length
        real*8 yL	! input  the y edge length
	real*8  segp    ! output. the portion of the 
                        ! segment contined in the square (0~1).


	complex*16 zz1, zz2, zz0, expa
	real*8 eps/1.d-8/, p, q, x0, y0
	integer nc, icon
	real*8 px(2)

	nc= 0
	zz1 = cmplx(x1, y1)
	zz2 = cmplx(x2, y2)

	if(abs(zz1 - zz2) .lt. 1.d-7) then
c	     this may happen if dl is very small
	   segp = 0.
	   return   ! ******
	endif

c   
	x0 = xc - xL/2
	y0 = yc - yL/2
c                 | line
	zz0 = cmplx(x0,y0)
	expa = cmplx(0.d0,  1.d0)
	call kxplsl(zz0, expa, zz1, zz2, eps, p, q, icon)

	if(icon .eq. 0)  then
	   if(q .le. yL .and.  q .ge. 0.) then
	      nc = nc + 1
	      px(nc) = p
	   endif
	endif
c          ___ line  
c          |        
c
	zz0 = cmplx(x0, y0+yL)
	expa = cmplx(1.d0, 0.d0)
	call kxplsl(zz0, expa, zz1, zz2, eps, p, q, icon)
c ////////////
c	write(*, *) '2  icon=', icon, ' p	=',p, ' q=',q
c /////////////// 

	if(icon .eq. 0)  then
	   if(q .le. xL .and.  q .ge. 0.) then
	      nc = nc + 1
	      px(nc) = p
	      if(nc .eq. 2) goto 100
	   endif
	endif
c         _____   
c         |   | line
c
	zz0 = cmplx(x0+xL, y0)
	expa = cmplx(0.d0, 1.d0)
	call kxplsl(zz0, expa, zz1, zz2, eps, p, q, icon)
c ////////////
c	write(*, *) '3  icon=', icon, ' p	=',p, ' q=',q
c /////////////// 

	if(icon .eq. 0)  then
	   if(q .le. yL .and.  q .ge. 0.) then
	      nc = nc + 1
	      px(nc) = p
	      if(nc .eq. 2) goto 100
	   endif
	endif
c            
c         _____   
c         |   | 
c         _____ line   
c
	zz0 = cmplx(x0, x0)
	expa = cmplx(1.d0, 0.d0)
	call kxplsl(zz0, expa, zz1, zz2, eps, p, q, icon)

c ////////////
c	write(*, *) '4  icon=', icon, ' p	=',p, ' q=',q
c /////////////// 
	if(icon .eq. 0)  then
	   if(q .le. xL .and.  q .ge. 0.) then
	      nc = nc + 1
	      px(nc) = p
	      if(nc .eq. 2) goto 100
	   endif
	endif
 100	continue
	if(nc .eq. 2) then
	   segp = abs(px(1) - px(2)) 	
	elseif(nc .eq. 1) then
	   if(x1 .ge. x0 .and. x1 .le. x0+xL .and.
     *           y1 .ge. y0 .and. y1 .le. y0+yL) then
	      segp = px(1)
	   else
	      segp = 1.- px(1)
	   endif
	else
	   if(x1 .ge. x0 .and. x1 .le. x0+xL .and.
     *           y1 .ge. y0 .and. y1 .le. y0+yL) then
	     if(x2 .ge. x0 .and. x2 .le. x0+xL .and.
     *           y2 .ge. y0 .and. y2 .le. y0+yL) then
c                fully contained
	        segp = 1.
	     endif
	  endif
	endif	
c/////////////
	if( segp .gt. 1.) then
	   write(*,*) ' ************************* segp=', segp
	endif
c////////////////
  	end	
	subroutine  fiberCountSq(x1, z1, sx, xL, zL, n, 
     *                       xs, ys, zs, wx, wy,  wz, 
     *                       de, dl, invattnl, yii, eloss)
c        SciFi of xL x yL (cm x cm) is assumed to be aligned
c      along y direction on the x-y plane. The fiber 
c      cross-section is on the x-z plane.  
c 
c      z
c      |  1                           n 
c      |  [] [] [] [] [] []...       [] 
c      |  x1        <-> sx
c      --------------------------------> x
c      The first fiber center is at x1, z1.  
c      The i-th fiber center is at xi= x1 + (i-1)*sx
c      with the same z1.  
c      A charged particle runs dl cm from (xs, ys, zs)
c      with the direction cosine (wx, wy, wz) and
c      lose energy de (GeV).  It is assumed that the
c      track is contained in the current layer 
c      (This is garanteed  by Epics).  
c      This subroutine computes the energy loss portion
c      of 'de' put in each fiber and adds
c      it to eloss(i).  The energy loss is assumed to 
c      be proportional to track's segment length in  each          '
c      fiber (This is not strictly correct).
c
       implicit none
        real*8 x1  !  the first fiber center x
        real*8 z1  !  fiber's center height                        '
        real*8 sx  !  step of the adjacent fiber centers
        real*8 xL  !  x edge length of fiber 
        real*8 zL  !  z edge length of fiber 
        integer n   !  number of fibers
        real*8 xs, ys,  zs  !  track segment starting point.
                        !  ys is needed only for computing attenuation
                       ! of light from ys to yii.  
        real*8 wx, wy, wz  !  track's direction cosines            '
                           !  wy is needed.
        real*8 de          !  energy loss along dl cm
        real*8 dl          !  the track runs dl cm
        real*8 invattnl    ! 1/attenuation length of light (1/cm)
        real*8 yii         ! I.I's position. The legth to the          '
                           ! I.I is yii - ys.
        real*8 eloss(n)    !  array to count up the energy loss
                           !  in the n-th fiber 
c
        integer is, ie, i
        real*8  xe, ze  ! end point of the track
        real*8  xc, segl, deatii, segp
c
	if(dl .le. 0.) return
c
        xe = xs + wx * dl
        ze = zs + wz * dl

c           compute fiber numbers the track may passes
        ie = min(int((max(xs, xe) - x1 - xL/2)/sx + 2), n)
        is = max(int((min(xs, xe) - x1 + xL/2)/sx + 1), 1)
c
        deatii =  exp( - (yii - ys)*invattnl) * de
        do i = is, ie
           xc = x1 + (i-1)*sx
           call ksegCutBySq(xs, zs, xe, ze, xc, z1, xL, zL, segp) 
	   segl = dl * segp
           if(segl .gt. 1.d-5) then
	      eloss(i) = eloss(i) +  segp *deatii
           elseif(1.d0-abs(wy) .le. 1.0d-5) then
c                  along fiber
              if( abs(xs-xc) .le. xL/2 .and.
     *            abs(zs-z1) .le. zL/2) then
                 eloss(i) = eloss(i) + deatii
              endif
           elseif(dl .eq. 0.) then
c                dead particle may come here
              eloss(i) = eloss(i) + deatii
           endif
        enddo
        end
