c      ***************************************************************
c      *                                                             *
c      * Sepics: A  Standard program which uses EPICS
c      *                                                             *
c      ***************************************************************
c
       subroutine sepics(ngen)
       implicit none
       integer ngen  ! output. # of events generated in this run

       integer icon

c             init sepics, epics
       call sopen
c             generate showers until required # or
c             time lack
c          *** until loop*** 
       do while (.true.)
          call s1set(icon)
          if         (icon .ne. 0)
     *                       goto 10
       enddo
 10    continue
c             end of all events or time lacks
       call epeaev
       call sclose(ngen)
       end
c      ****************
       subroutine sopen
       implicit none
c              read control parameters
#include  "ZsepManager.h"
#include  "ZepDirec.h"
#include  "ZepTrackp.h"
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "Zsparm.h"
#include  "Zswk.h"

        character*150 msg
        character*100 cosmosparam
c
        cosmosparam  = ' '
        read(*, *, end=100) EpicsFile, ConfigFile, SepicsFile, cont,
     *   cosmosparam

        call sparmr(SepicsFile)
c
c                   init epics
        if(cosmosparam .ne. ' ') then
           call epicosmos(cosmosparam)
        endif

        call epiaev(EpicsFile, ConfigFile)
        if(Trace .and. Nevent .gt. 20) then
           call cerrorMsg('********* Warning **********',1)
           call cerrorMsg(
     *     'Do you really want to take trace on so many events ?',
     *     1)
           call cerrorMsg(
     *     'If not, make "Trace f" in epicsfile', 1)
        endif
c              incident energy sampling. initializaiton 
        call ciniSPrim(PrimaryFile)
c
c            inquire form
        call epqfrm(formx)
        if(formx .eq. 'cyl') then
           call epqcyl(rcyl)
        elseif(formx .eq. 'pipe' ) then
           call epqpip(rpipi, rpipo)
        endif
c        call epqcnf(orgw, abcw)

c        call epqworld(nwld, wstruct) 
c
        if(.not. cont) then
c               to keep first exEcution date: get date & time
c             call kqymd(pdatE0)
c             call kqhms(ptimE0)
        endif
c
c                initialize random no.
ccc          if(cont) then
ccc              call scontr(IoCont)
ccc         else
              if(Ir1(2) .ge. 0) then
                 call rnd1i(Ir1)
              else
                 call cmkSeed(0, Ir1)
                 call rnd1i(Ir1)
              endif
ccc          endif
          return
c         ---------------- Error -----------------
 100      continue
          write(msg, *) 'EpicsFile=',EpicsFile
          call cerrorMsg(msg, 1)
          write(msg, *) 'ConfigFile=', ConfigFile
          call cerrorMsg(msg, 1)
          write(msg, *) ' SepicsFile=',  SepicsFile
          call cerrorMsg(msg, 1)
          write(msg, *) ' cont info=', cont
          call cerrorMsg(msg, 1)
          write(msg,*) ' no control parameters'
          call cerrorMsg(msg, 0)
       end
       subroutine  s1set(icon)
       implicit none
#include  "ZsepManager.h"
#include  "ZepPos.h"
#include  "ZepDirec.h"
#include  "Zep3Vec.h"
#include  "Zsparm.h"
#include  "Zswk.h"
      integer icon
      character*80 msg

      integer jcon

      if(nevc .ge. Nevent) then
         icon=1
      else
c                 get random no. for this event
         call rnd1s(Ir1st)
         if(LogIr) then
c             record Seed in err out
            write(msg, *) Ir1st, nevc + 1
            call cerrorMsg(msg, 1)
         endif
c                 init 1 event. (clear arrays etc)
         call epi1ev(jcon)
         if(jcon .ne. 0) then
c                    jcon=0-->user set the incident
c                    set incident ptcl(s) by sepics
            call ssetip
         endif
         call stimec(icon)
c                  check time using stack area data
         if(icon .eq. 0) then
c                     time is available for the generation
c                     generate 1 event
            call epgen
c              end of 1 event
            call epe1ev
            call se1ev
         endif
      endif
      end
c     ****************
      subroutine se1ev
      implicit none
c             end of 1 event
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "Zswk.h"
          nevc=nevc+1
       end
c     ***************
       subroutine sqtevn(nev)
       implicit none
#include  "ZepPos.h"
#include  "Zep3Vec.h"
#include  "ZepDirec.h"
#include  "Zsparm.h"
#include  "Zswk.h"

      integer nev, icon

c           inquire total # of events created
          nev=nevc
          return
c      *****************
       entry sqcont(icon)
          if(cont) then
             icon=1
          else
             icon=0
          endif
       end
      subroutine ssetip
      implicit none
#include  "ZsepManager.h"
#include  "ZepTrack.h"
#include  "Zep3Vec.h"
#include  "Zswk.h"
#include  "Zsparm.h"

      record /epTrack/ aTrack
      record /epTrack/InciTrack, bTrack
      integer ns, i, j, icon
      real*8 sume

c             set incident ptcl
c               fix energy (momentum yet)
      call sfixe(aTrack)

c               fix position
      call sfixp(aTrack)
c               fix angle
      call sfixa(aTrack)
c               fix others
      call sfixo(aTrack)
c               set them
      call epputTrack(aTrack)
      InciTrack = aTrack
      return
c      *****************
       entry stimec(icon)
c      *****************
c         icon=0---> time available
c             ^=1---> no //
c              inquire current stack index
       call epqstn(ns)
c              inquire energy
       sume=0.
       do   i=1, ns
          call epqstt(i, aTrack)
          sume=sume+aTrack.p.fm.p(4)
       enddo
c             estimate time for energy:   BaseTime=time for 1gev
           j=sume* BaseTime
c             see if more cpu time available
c           call timec(j, icon)
           icon = 0
       return
c      ***************
       entry epqInci(bTrack)
       bTrack = InciTrack
       end
       subroutine sclose(nev)
       implicit none
#include  "ZepManager.h"
#include  "ZsepManager.h"
#include  "ZepPos.h"
#include  "ZepDirec.h"
#include  "Zep3Vec.h"
#include  "Zsparm.h"
#include  "Zswk.h"

      integer nev
      character*150 msg

c               end of all events
cc          call scontw(IoCont)
cc          call timepc(6)
c              inquire # of events created in this run
          call epqevn(nev)
c              print message
c             get  current random no.
          call rnd1s(Ir1)
          write(msg,*) ' # created in this run=',nev,
     *     ' current total #=',nevc,
     *     ' destination #=',Nevent,
     *     ' next ir=', Ir1
          if(MsgLevel -1 .ge. 0) then
             call cerrorMsg(msg, 1)
          endif
       end
      subroutine sfixe(aTrack)
       implicit none
#include  "Zglobalc.h"
#include  "ZepTrack.h"
#include  "ZepTrackp.h"
#include  "Zep3Vec.h"
#include  "Zcnfig.h"
#include  "Zswk.h"
#include  "Zsparm.h"
#if defined NEXT486
#define IMAG_P dimag
#elif defined PCLinux 
#define IMAG_P dimag
#else
#define IMAG_P imag
#endif


       record /epTrack/ aTrack
       real*8 u, r,   dx, dy, cs, sn
       real*8 st, pw
       record /epPos/ org, rxyz

       character*70 msg


c           sample incident particle
       call epsampPtcl(aTrack.p)
       return
c      *******************
       entry sfixp(aTrack)
c      *******************
c          sample incident x,y,z position;  world coord.
       if(InputP .eq. 'fix') then
#if defined IBMAIX
          call epsubpos(PosInp, aTrack.pos)
#else
          aTrack.pos = PosInp
#endif
       elseif(InputP(1:2) .eq. 'u-' .or.
     *        InputP(1:2) .eq. 'u+' ) then
c            uniform in Xrange, Yrange,  Zrange        
          call rndc(u)
          aTrack.pos.x
     *        = ( IMAG_P(Xrange) - real(Xrange) )* u
     *          + real(Xrange)
          call rndc(u)          
          aTrack.pos.y
     *        = ( IMAG_P(Yrange) - real(Yrange) )* u
     *          + real(Yrange)
          call rndc(u)           
          aTrack.pos.z
     *        = ( IMAG_P(Zrange) - real(Zrange) )* u
     *          + real(Zrange)

       elseif(InputP .eq. 'usph') then
c                 InputP = 'usph'
          call epqwcoord(org, rxyz)
                         ! rxyz.x= should be the radius of the sphere
          r = rxyz.x -EpsLeng
c                                  teta       phi      o.a
          call epuonSphere(1, r, PosInp.x, PosInp.y, PosInp.z,
     *       aTrack.pos)
          aTrack.pos.x = aTrack.pos.x + org.x
          aTrack.pos.y = aTrack.pos.y + org.y
          aTrack.pos.z = aTrack.pos.z + org.z
       elseif(InputP .eq. 'gsph') then
c
c           PosInp.x = teta, PosInp.y = phi, PosInp.z = opening angl
c           ProfR should be  R * sin(O.A), but not referred.
c
          call epqwcoord(org, rxyz)
                            ! rxyz.x= should be the radius of the sphere
          r = rxyz.x -EpsLeng

          call epgonSphere(1, Hwhm, r, PosInp.x, PosInp.y, PosInp.z,
     *       aTrack.pos)

          aTrack.pos.x = aTrack.pos.x + org.x
          aTrack.pos.y = aTrack.pos.y + org.y
          aTrack.pos.z = aTrack.pos.z + org.z
       elseif(InputP(1:1) .eq. 'g') then
c                  gaussian density beam
          call epGaussb(Hwhm, ProfR, dx, dy)
          if(InputP(3:3) .eq.  'z') then
c                 around Xinp, Yinp
             aTrack.pos.x = PosInp.x + dx
             aTrack.pos.y = PosInp.y + dy
             aTrack.pos.z = PosInp.z
          elseif(InputP(3:3) .eq. 'y') then
             aTrack.pos.x = PosInp.x + dx
             aTrack.pos.y = PosInp.y
             aTrack.pos.z = PosInp.z + dy
          elseif(InputP(3:3) .eq. 'x') then
             aTrack.pos.x = PosInp.x
             aTrack.pos.y = PosInp.y + dx
             aTrack.pos.z = PosInp.z + dy
          else
             write(msg,*) ' InputP=',InputP, ' invalid'
             call cerrorMsg(msg,  0)
          endif
       else
          write(msg,*) ' InputP=',InputP, ' invalid'
          call cerrorMsg(msg,  0)
       endif
       return
c       ****************************************
        entry sfixa(aTrack)
c          
        if(InputA .eq. 'fix') then
           aTrack.w.x = DCInp.x
           aTrack.w.y = DCInp.y
           aTrack.w.z = DCInp.z
           if(abs( DCInp.x**2 + DCInp.y**2 + DCInp.z**2 - 1.d0)
     *        .gt. 1.d-3) then
              call cerrorMsg('sum of DCInp**2 is far from 1', 0)
           else
c              normalize so
              call epadjdir(aTrack.w)
           endif
        else
           if(InputA .eq. 'is') then
              call rndc(u)
              DCInp.z= ( IMAG_P(CosNormal) - real(CosNormal) )* u
     *          + real(CosNormal)
           elseif(InputA(1:3) .eq. 'cos') then
              read(InputA(4:12), *) pw
              call rndc(u)
              if(pw .ne. 1.d0) then
                 DCInp.z=
     *          ( (IMAG_P(CosNormal)**(pw+1.d0) - 
     *                  real(CosNormal)**(pw+1.d0))* u
     *           + real(CosNormal)**(pw+1.d0))**(1.d0/(pw+1.d0))
              else
                 DCInp.z =(IMAG_P(CosNormal)/real(CosNormal))**u *
     *                  real(CosNormal)
              endif
           else
              write(msg,*) ' InputA=',InputA, ' not supported'
              call cerrorMsg(msg, 0)
           endif
           call kcossn(cs,sn)
           st= sqrt( 1.d0 - DCInp.z**2)
           DCInp.x = st * cs
           DCInp.y = st * sn

           if(InputP .eq. 'fix') then
              aTrack.w.x = DCInp.x
              aTrack.w.y = DCInp.y
              aTrack.w.z = DCInp.z
           elseif(InputP .eq. 'usph' .or.
     *            InputP .eq. 'gsph' ) then
              if( DCInp.x*(aTrack.pos.x -org.x)+ 
     *            DCInp.y*(aTrack.pos.y -org.y)+ 
     *            DCInp.z*(aTrack.pos.z -org.z) .lt. 0.) then
                 aTrack.w.x = DCInp.x
                 aTrack.w.y = DCInp.y
                 aTrack.w.z = DCInp.z
              else
                 aTrack.w.x = -DCInp.x
                 aTrack.w.y = -DCInp.y
                 aTrack.w.z = -DCInp.z
              endif                 

c              direct the angle around the normal vector
           elseif(InputP(2:3) .eq. '+z') then
              aTrack.w.x = DCInp.x
              aTrack.w.y = DCInp.y
              aTrack.w.z = DCInp.z
           elseif(InputP(2:3) .eq. '-z') then
              aTrack.w.x = DCInp.x
              aTrack.w.y = DCInp.y
              aTrack.w.z = -DCInp.z
           elseif(InputP(2:3) .eq. '+y') then              
              aTrack.w.x = DCInp.x
              aTrack.w.y = DCInp.z
              aTrack.w.z = DCInp.y
           elseif(InputP(2:3) .eq. '-y') then              
              aTrack.w.x = DCInp.x
              aTrack.w.y = -DCInp.z
              aTrack.w.z = DCInp.y
           elseif(InputP(2:3) .eq. '+x') then              
              aTrack.w.x = DCInp.z
              aTrack.w.y = DCInp.x
              aTrack.w.z = DCInp.y
           elseif(InputP(2:3) .eq. '-x') then              
              aTrack.w.x = -DCInp.z
              aTrack.w.y = DCInp.x
              aTrack.w.z = DCInp.y
           else
              write(msg,*)' InputP=',InputP, ' and ',
     *             InputA,' incompatible'
              call cerrorMsg(msg, 0)
           endif
        endif
        return
c        ***************************
      entry sfixo(aTrack)
c              fix time of incidence
        aTrack.t = 0.d0
c           fix momentum 
        call epe2p(aTrack)  ! direction & e--> px,py,pz
       end
c           for ibm
       subroutine epsubpos(inp, out)
       implicit none
#include "ZepPos.h"
       record /epPos/ inp, out
       out =inp
       end
      
c      *********************
       subroutine scontw(io)
       implicit none
#include  "ZsepManager.h"
#include  "ZepPos.h"
#include  "ZepDirec.h"
#include  "Zep3Vec.h"
#include  "Zsparm.h"
#include  "Zswk.h"
      integer io

      character*2 qmk1/" '"/, qmk2/"',"/

c
               write(io, *) nevc, Ir1st,
     *         qmk1,pdatE0,qmk2, qmk1, ptimE0,qmk2
               call sparmw(io)
               return
c
c      ******************
       entry scontr(io)
               read(io, *, end=100) nevc, Ir1, pdatE0,
     *               ptimE0
               call rnd1r(Ir1)
               rewind io
               return
  100      continue
           stop 'no cont information'
       end
