      subroutine eprcap(comp)
       implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"

       record /Component/ comp  ! output. to recieve the config data.
       character*120 msg
 
       integer ir, or, w1, h
       parameter( ir=1, or=2, w1=3, h=4)

       real*8 r1, r2, w
c
c           read Cap configuration data as 'new-1'
c            cap has 3 volume  attributes, its z-axis direction cos
c            (7-9) are to be read.
        call eprpst(comp, 3, 4, 7, 9)

c           check some values
c((((((((((((
        r1 = Volat( comp.vol +ir )
        r2 = Volat( comp.vol +or )
        w  = Volat( comp.vol +w1 )
c))))))))))))
        if(r1 .ge. r2) then
           write(msg, *) comp.cn, '-th component: r1=', r1,
     *    ' >= r2 =', r2, ' for Cap'
           call cerrorMsg(msg, 0)
        endif
        if(abs(w) .gt. r1 ) then
c               |w1| > r1
           write(msg, *) comp.cn,'-th component: w1=',w,
     *    ' >= r1 =', r1, ' for Cap'

           call cerrorMsg(msg, 0)
        endif
c           compute h for later use and embed it in
c           vol(4) which is not used yet.
c           vol(1) = r1, vol(2)=r2, vol(3)=w1
c           vol(4)= h  
c                           *   *    
c                       *   .   .    *
c                    *   .         .    *
c                  *   .              .   *   
c                 <-----------x------->
c                 \     w2    | w1=w /
c                    \       h|    /
c                       \     |  / r1
c                     r2   \  |/
c                            \x origin
c 
c((((((((((9
       Volat( comp.vol+h ) =  sqrt( r1**2 -w**2)
c         if w1 <= 0, it means, h < 0
       if(w .le.  0.) then
          Volat( comp.vol+h ) = - Volat( comp.vol+h ) 
       endif
c))))))))))))
       end
c   ***************************************
      subroutine epbcap(comp, pos, dir, length, icon)
       implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
#include "ZepDirec.h"
#include "Zepdebug.h"
       integer ir, or, w1, h
       parameter( ir=1, or=2, w1=3, h=4)
c
c          find length to the boundary of 'comp' from 'pos'
c        with direction cos 'dir'
c     'pos' and 'dir' are given in this 'comp' local coordinate
c      in the canonical form.
c 

       record /Component/comp  ! input. you can extract volume parameters
                               !  by comp.vol(1), etc
       record /epPos/ pos   ! input.  position.
       record /epDirec/ dir  ! input. direction cosinse

       real*8  length !  output length cm from pos to the boundary
       integer icon  ! output 0: length obtained. cTrack is inside
                     !        1:  //                        outside
                     !       -1: the line dose not cross the volume
c
       real*8 lout, lin, sp
       integer  jcon1, jcon2

#ifdef DEBUG
       debug = -1
#endif
c          get crossing point with the outer sphere
c(((((((((((
       call kxplsph(pos.x, pos.y, pos.z, dir.x, dir.y, dir.z, 
     *       Volat( comp.vol+or ), lout, jcon1)
c)))))))))
c           jcon =0; pos is inside
c                 1:        outside
c                -1; no cross
       if(jcon1 .ne. -1) then
c           get scaler product for later use
          sp = pos.x*dir.x + pos.y*dir.y +  pos.z*dir.z

c          get crossing point with the inner sphere
c(((((((((((
          call kxplsph(pos.x, pos.y, pos.z, dir.x, dir.y, dir.z,
     *        Volat( comp.vol+ir ), lin, jcon2)
c))))))))))))
          if(jcon1 .eq. 1 .and. jcon2 .eq. -1 ) then
c
c             cross only with outer sphere
c
c(((((((((
             if(lout*dir.z + pos.z .ge. Volat( comp.vol+h ) )  then
c))))))))))
c                    lout should be the solution
                length = lout
                icon = 1
#ifdef DEBUG
                debug = 1
#endif
c((((((((
             elseif( (-lout -2*sp)*dir.z + pos.z  .ge.
     *              Volat( comp.vol+h) ) then
c))))))))
c                should cross at h
c(((((((((
                length =( Volat( comp.vol+h )- pos.z )/dir.z
c))))))))
                icon = 1
#ifdef DEBUG
                debug = 2
#endif
             else
                icon = -1
             endif


          elseif(jcon1 .eq. 1 .and. jcon2 .eq. 1) then

c               penetrate two sphers from  outside
c(((((((((
             if(lout*dir.z + pos.z .ge. Volat( comp.vol+h )) then
c)))))))))
                length = lout
                icon = 1
#ifdef DEBUG
                debug = 3
#endif
             elseif(dir.z .le. 0.) then
                icon = -1
c((((((((((
             elseif((-lout - sp*2)*dir.z + pos.z .lt. 
     *                             Volat( comp.vol+ h)) then
c                      |  this is length to further cross point
                icon =-1
             elseif(lin*dir.z + pos.z .ge. Volat(comp.vol+h)) then
c                cross at h
                length =( Volat(comp.vol+h)- pos.z ) / dir.z
c)))))))))
                icon = 1                
#ifdef DEBUG
                debug = 4
#endif
             elseif((-lin - sp*2)*dir.z + pos.z  .ge.
     &          Volat( comp.vol+h)) then
c                cross with inner sphere
                length = -lin -sp*2
                icon = 1
#ifdef DEBUG
                debug = 5
#endif
             elseif((-lout-2*sp)*dir.z + pos.z .ge. 
     *              Volat( comp.vol+h)) then
c                should cross at h
                length =( Volat( comp.vol+h)- pos.z ) / dir.z
                icon = 1
#ifdef DEBUG
                debug = 6
#endif
             else
                icon = -1
             endif


          elseif(jcon1 .eq. 0 .and. jcon2 .eq. -1) then

c              
c              inside outer sphere and not cross with inner sphere
c
             if(lout*dir.z + pos.z .ge. Volat( comp.vol+h)) then
c                   cross at > h
                if(pos.z .ge. Volat( comp.vol+h)) then
c                     pos > h
                   length = lout
                   icon = 0
#ifdef DEBUG
                   debug = 7
#endif
                else
c                    pos < h; should cross at h                   
                   length =( Volat( comp.vol+h)- pos.z ) / dir.z
                   icon = 1
#ifdef DEBUG
                   debug = 8
#endif
                endif
             else
c                    cross at < h
                if(pos.z .le. Volat( comp.vol+h) ) then
c                       pos < h
                   icon = -1
                else
c                   pos> h; should cross at h
                   length =( Volat( comp.vol+h)- pos.z ) / dir.z
                   icon = 0
#ifdef DEBUG
                   debug = 9
#endif
                endif
             endif
             
          elseif(jcon1 .eq. 0  .and.  jcon2 .eq. 1)  then
c 
c              inside outer sphere and outside inner sphere
c              and crosses the inner spere
c
             if(pos.z .ge. Volat( comp.vol+h)) then
c                     pos > h
                if(lin*dir.z + pos.z .ge. Volat( comp.vol+h)) then
                   length = lin
                   icon = 0
#ifdef DEBUG
                   debug = 10
#endif 
                else
c                    should cross at h
                   length =( Volat( comp.vol+h)- pos.z ) / dir.z
                   icon = 0
#ifdef DEBUG
                   debug = 11
#endif
                endif
             else
c                   pos < h
                if(lout * dir.z + pos.z .lt. Volat( comp.vol+h)) then
                   icon = -1
                elseif( lin*dir.z + pos.z .lt. Volat( comp.vol+h) .and.
     *              ( (-lin -2*sp)*dir.z + pos.z .ge.
     *                     Volat( comp.vol+h)))  then
                   length = (-lin -2*sp)
                   icon = 1
#ifdef DEBUG
                   debug = 12
#endif
                else
c                    should cross at h
                   length =( Volat( comp.vol+h)- pos.z ) / dir.z
                   icon = 1
#ifdef DEBUG
                   debug = 13
#endif
                endif
             endif


          else
c
c                should be inside inner sphere
c
             if(lin*dir.z +  pos.z .ge. Volat( comp.vol+h)) then
c                    cross > h
                length = lin
                icon = 1
#ifdef DEBUG
                debug = 14
#endif
             elseif(lout *dir.z + pos.z  .ge. Volat( comp.vol+h)) then
c                 should cross at h
                length =( Volat( comp.vol+h)- pos.z ) / dir.z
                icon = 1
#ifdef DEBUG
                debug = 15
#endif
             else
                icon = -1
             endif
          endif      
       else
          icon = -1
       endif
       end
c      **********************************
      subroutine epscap(comp, pos, icon)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"

       integer ir, or, w1, h
       parameter( ir=1, or=2, w1=3, h=4)

c                judges if pos is inside the comp component      
      record /Component/ comp !input component
      record /epPos/ pos  ! input. position in  local coord. of ncx-th comp.
      integer icon  ! output. 0--> pos is inside
                    !         1-->        outside

      real*8 temp
      if(pos.z .lt. Volat( comp.vol+h)) then
         icon = 1
      elseif(pos.z .gt. Volat( comp.vol+or)) then
         icon = 1
      elseif(abs(pos.x) .gt. Volat( comp.vol+or)) then
         icon =1 
      elseif(abs(pos.y) .gt. Volat( comp.vol+or)) then
         icon =1 
      else
         temp = pos.x**2 + pos.y**2 + pos.z**2 
         if(temp .ge. Volat( comp.vol+ir)**2 .and.
     *      temp .le. Volat( comp.vol+or)**2 ) then
            icon = 0
         else
            icon = 1
         endif
      endif
      end
c     **************************************
      subroutine epenvlpcap(comp, org, abc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"

c
c        give the envloping box of the component
      record /Component/ comp  ! input component.
      record /epPos/ org       ! output.  origin of the enveloping box
      record /ep3Vec/ abc      ! output.  a,b,c of the box

      integer ir, or, w1, h
      parameter( ir=1, or=2, w1=3, h=4)
c
      
      if(Volat( comp.vol+w1) .gt. 0.) then
         org.x = 
     *   - sqrt( Volat( comp.vol+or)**2 - Volat( comp.vol+h)**2)
      else
         org.x = - Volat( comp.vol+or)
      endif
      org.y = org.x
      org.z = Volat( comp.vol+h)
      abc.x = abs(org.x)*2
      abc.y = abc.x
      abc.z = Volat( comp.vol+or) - Volat( comp.vol+h)
      end
c     *************************************
      subroutine epatloccap(comp, loc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"

      record /Component/ comp ! input.
      integer loc(*)   ! output. Volat(comp.vol+loc(i)) is the
                      !  the vlaue of the i-th original
                      !  attribute in the config file.

      integer i

      do i = 1, 4
         loc(i) = i
      enddo

      end

