c     ****************************************************************
c     *                                                              *
c     * epdedxNone: gives -de/dx  (gev/(g/cm2)) of non e+/e-
c     *                                                              *
c
c
c
      subroutine epdedxNone(media, aPtcl, dedt, dedtfull )
      implicit none
#include "Zmedia.h"
#include "Zcode.h"
#include "Zptcl.h"
#include "Zmass.h"
      real*8 emass, emass2 
      include "ZdEdxSpec.h"
c       MeV unit electron mass.
      parameter(emass = masele*1000., emass2=emass**2)

      record /epmedia/media         ! input. 
      record /ptcl/aPtcl        ! input. a particle

      real*8 dedt      ! output. restricted Energy loss rate.   GeV / (g/cm2). 
      real*8 dedtfull  ! output full dE/dx
 
      real*8  E,  mass,  Beta2, x, full, restricted, temp, tempsqrt
      real*8  wm, wlg, u, delta, atomicEbrem, atomicEbremCut
      real*8 bbbeta2, lindbeta2, truebeta2
      real*8 bbbeta, lindbeta 
      real*8 logbbbeta, loglindbeta
      real*8 a, b, c, xx, gra, gb2, g, integ
c//      parameter (bbbeta = 0.1d0,  lindbeta = 0.005d0, gra=5.d0/3.d0)
c**      parameter (bbbeta = 0.01d0,  lindbeta = 0.005d0, gra=5.d0/3.d0)
c      parameter (bbbeta = 0.05d0,  lindbeta = 0.0045d0, gra=5.d0/3.d0)
      parameter (bbbeta = 0.045d0,  lindbeta = 0.0045d0, gra=5.d0/3.d0)
      parameter (bbbeta2 = bbbeta**2, lindbeta2=lindbeta**2)
c//     parameter (logbbbeta =-2.302585093E+00,
c**      parameter (logbbbeta =-9.210340371976,
      parameter (logbbbeta =log(bbbeta),
c     *           loglindbeta =-4.605170186E+00)
     *           loglindbeta =log(lindbeta))
      parameter (a = (1.+gra)/2.d0/(logbbbeta-loglindbeta),
     *           b = 2*a*loglindbeta + 1.) 
      real(8):: F, cF  
c
c               energy in MeV unit
      E = aPtcl.fm.p(4)*1000.
      mass= aPtcl.mass*1000.
      g = E/mass
      truebeta2 = 1. -(1.0d0/g)**2
      if(truebeta2 .lt. bbbeta2) then
c            fix at beta=0.1
         Beta2 = bbbeta2
         E = mass*(1. + Beta2/2)
         g = E/mass
      else
         Beta2 = truebeta2
      endif
c     
      gb2 = Beta2 * g**2   !  g^2 b^2

c          x=log10(p/mc)  = log10(g*beta)
      x=log10( gb2 ) / 2


c             max kinetic energy of knock-on
      wm = 2* emass * gb2
     *     /(1.0 + 2.0*g*(emass/mass) +(emass/mass)**2)
      Tupper = wm/1000.         !  in GeV; used in Urban
c        wm in unit of Me
      u = wm/emass 
c          first compute full average dE/dx
c           sh.a/Beta2( sh.b +ln(2*g^2b^2wm/m) -2Beta^2 -delta
c                 +spin_term )
c 
      full = media.sh.b +  log(2*u*gb2) -2.0*Beta2 
      atomicEbrem = 0.
c            assume spin 0 particle is only pi, K
      if(aPtcl.code .ne. kpion .and. aPtcl.code .ne. kkaon) then
c          spin 1/2 term; (almost negligible)
         full = full +  (wm/E)**2/4.
         if(aPtcl.code .eq. kmuon .and. E .gt. 5000. ) then
c            atomic electron brems term.  at 5GeV, ~0.4 % 100GeV 2%
c            so we neglect below 5GeV
c               sh.a*alpha/(2pi) (log(2g)-1/3 log(2u)log^2(2u)
c                assuming sh.a/Beta2 = sh.a at E>5GeV
c                compute effect without sh.a and add later to full
            temp = log(2*u)
            atomicEbrem = 
     *       0.00116*(log(2*g)-0.3333*temp)*temp*temp
         endif
      endif
c             see if restricted energy is requested
      atomicEbremCut = 0.
      if(wm .gt. media.sh.w0) then
c             yes. requested
c                subtract average loss rate from  Ek>w0 region
c                loss for Ek>w0
         integ = log(wm/media.sh.w0) - Beta2*(1.0-media.sh.w0/wm)
c            assume spin 0 particle is only pi, K
         if(aPtcl.code .ne. kpion .and. aPtcl.code .ne. kkaon) then
c               mu, p, etc. spin = 1/2
            integ = integ + ((wm/E)**2-(media.sh.w0/E)**2)/4.
            if(aPtcl.code .eq. kmuon  .and. E .gt. 5000. ) then
c                 Integ(0~wm) =Integ(0~w0) + Integ(w0~wm)
c             so  Integ(w0~wm) = Ineg(0~wm)-Integ(0~w0)
               temp = log(2*media.sh.w0/emass)
               atomicEbremCut = atomicEbrem-
     *          0.00116*(log(2*g)-0.3333*temp)*temp*temp
            endif               
         endif
      else
         integ = 0.
      endif
      call epdEdxDenC(media, g, delta)
      full = full -delta + atomicEbrem

      F =  integ  + atomicEbremCut
      restricted = full - F

      dedt = media.sh.a/Beta2*restricted  
      full = full*  media.sh.a/Beta2

      if(truebeta2 .lt. bbbeta2) then
         cF  = ( a* logbbbeta - b )*logbbbeta
         c = log(dedt) + cF
         if(F > 0. ) then
            cF = log(full) + cF
         else
            cF = c
         endif
         if( truebeta2 .gt.  lindbeta2) then
            xx = log( truebeta2 )/2.
            dedt =exp( (-a*xx + b)*xx + c)
            if( F > 0.) then
               full = exp( (-a*xx + b)*xx + cF)
            else
               full = dedt
            endif
               
         else
            tempsqrt = sqrt(truebeta2)/lindbeta

            dedt = exp( (-a*loglindbeta + b)* loglindbeta + c) *
     *             tempsqrt
            if(F> 0.) then
               full = exp( (-a*loglindbeta + b)* loglindbeta + cF) *
     *             tempsqrt
            else
               full = dedt
            endif
         endif
      endif
c         x  Z**2 and to GeV unit
      dedt=dedt * aPtcl.charge**2 * 1.d-3
      dedtfull = full * aPtcl.charge**2 * 1.d-3
c///////////////
c      write(22,*) sngl( aPtcl.fm.p(4)  - aPtcl.mass), sngl(dedt),
c     *            sngl(sqrt(truebeta2))
c///////////////
      end
c     *********************
c        For the organic scintillator, the energy loss by
c      heavy particles or slow particles is not converted to
c      photons  as efficiently as the one by relativistic electrons.
c      This subroutine gives a correction factor for the energy loss,
c      so that you can get effective energy loss by multiplying
c      cf by the true energy loss. 
c         NOTE: this is used for non organic scinti too.
c         called only if quenching terms are given in media data
      subroutine epOrgCorrec(modi, media, aPtcl, dedx, cf)
      use epModify
      implicit none
#include "Zmedia.h"
#include "Zptcl.h"
#include "Zmass.h"
      integer,intent(in):: modi ! modifier index of the component
                 ! where current ptcl is.
      record /epmedia/ media  ! input.
      record /ptcl/ aPtcl   ! input.
      real*8  dedx   ! input.  dE/dx (GeV/(g/cm^2) for the partcle
      real*8  cf     ! output. correction factor. dE_eff = cf x dE_true
      character*1 id
      real(8)::  c1, xx
      real(8)::c2=0. ! dummy
      real(8)::cc=0.     ! dummy

      call epQuenchCoeff(modi, media, aPtcl, dedx, c1, c2, cc,id)
      if( id == "n") then
         cf = 1.
      elseif( id == "T" ) then
         cf = (1.-c2)/(1.+(1.-c2)*c1*dedx) + c2
      elseif( id == "L") then
         xx = c1*dedx + 1.
         cf = xx**( -c2*log(cc*xx))
      elseif( id == "B") then
         cf = 1./(1. + c1 * dedx)
      else
c           should not come but for safety
         write(0,*)' modifyid =', modify(modi)%q%id, 'undef '
         write(0,*) ' ModifyFile index =', modi
         stop 2222
      endif
      end
      subroutine epQuenchCoeff(modi, media, aPtcl, dedx, a,b,c,id)
      use epModify
      implicit none
#include "Zmedia.h"
#include "Zptcl.h"
#include "Zmass.h"
      integer,intent(in):: modi ! modifier index of the component
                 ! where current ptcl is.
      record /epmedia/ media  ! input.
      record /ptcl/ aPtcl   ! input.
      real*8  dedx   ! input.  dE/dx (GeV/(g/cm^2) for the partcle
      real*8  a,b,c  ! output.  quench coef.
      character*1 id ! output.  one of T,B,L,n for Talre, Birks, LOg
c                               n is for no quenching

      if( .not. allocated ( modify )) then
         id ='n'
      elseif( modi > 0 ) then
         if( modi > maxModifyNum) then
            write(0,*) 'modifier =', modi, 'for media =',media.name
            write(0,*) ' > ', maxModifyNum, ' i.e. max # in ModifyFile'
            write(0,*) 'To run prg., correct data or give blank '
            write(0,*) ' to ModifyFile in epicsfile'
            stop
         endif
         if( IBITS(modify( modi )%kind, bitQuench, 1) > 0  ) then
            if( modify(modi)%q%id == "T") then
               a = modify(modi)%q%a
               b = modify(modi)%q%b
               id = "T"
            elseif( modify(modi)%q%id == "L") then
               a = modify(modi)%q%a
               b = modify(modi)%q%b
               c =  modify(modi)%q%c
               id = "L"
            elseif( modify(modi)%q%id == "B") then
               a = modify(modi)%q%a
               id = "B"
            else
               write(0,*)' modifyid =', modify(modi)%q%id, 'undef '
               write(0,*) ' ModifyFile index =', modi
               stop 2222
            endif
         elseif( media.Birks /= ' ') then  ! not nec. Birks
c             use defualt for this media
            a = media.BirksC1
            if( media.Birks == "B" ) then 
c            Birks formula without Chou's 2nd term(c2) or heavy correction
c            term(cc )
c      if( abs( aPtcl.charge ) .gt. 1)  then
c        c1 = c1 * media.BirksCC
c      endif
c      cf = 1./(1. + c1 * dedx + media.BirksC2 * dedx**2)
c        at present, we don't use above two factors
c 
               id = "B"
            elseif(media.Birks == "T" ) then 
               b = media.BirksC2
c               Tarle's formla 
               id = "T"
            elseif( media.Birks == "L" ) then 
c                typcal values c1,c2,cc; 23.53 0.0868 4.611
               b = media.BirksC2
               c = media.BirksCC
               id ="L"
            else
               write(0,*) ' media.Birks =', media.Birks, ' undef'
               stop 1111
            endif
         else
            id = "n"
         endif
      else
         if( media.Birks /= ' ') then
c             use defualt for this media
            a = media.BirksC1
            if( media.Birks == "B" ) then 

c            Birks formula without Chou's 2nd term(c2) or heavy correction
c            term(cc )
c      if( abs( aPtcl.charge ) .gt. 1)  then
c        c1 = c1 * media.BirksCC
c      endif
c      cf = 1./(1. + c1 * dedx + media.BirksC2 * dedx**2)
c        at present, we don't use above two factors
c 

               id = "B"
            elseif(media.Birks == "T" ) then 
               b = media.BirksC2
c               Tarle's formla 
               id = "T"
            elseif( media.Birks == "L" ) then 
c                typcal values c1,c2,cc;   23.53 0.0868 4.611
               b = media.BirksC2
               c = media.BirksCC
               id = "L"
            else
               write(0,*) ' media.Birks =', media.Birks, ' undef'
               stop 1111
            endif
         else
            id = "n"
         endif
      endif
      end
