      subroutine epBrSSampP(media, Ee, prob)
c          brems prob. sampling by Seltzer data.
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
      record /epmedia/media
      real*8 Ee
      real*8 prob  ! output probability of Brems / X0

      real*8 ale, Ek


      if(Ee .le. media.cnst.BrEeminS) then
         prob= 1.d-40
      else
         Ek = Ee - masele
         ale=log10(Ek)

         call kintp3(media.tbl.BrTXS,
     *   1, media.cnst.BrTXTS, media.cnst.BrLEeminS,
     *   media.cnst.BrdETXS, ale, prob) 


      endif
      end
c     ************
      subroutine epBrSSampE(media, Eein, Eg)
c     ************
c         brems energy by Seltzer
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
      record /epmedia/media
      real*8 Eein,  Eg

      real*8 Ee, Ek 

      real*8 u, ale, us, ans, vmax
      integer count
      logical ok
c&&&&&&&
      real*8 dummy(1)
      real*8 error
      data dummy/0.d0/
      save
c&&&&&&&&&&&

c      if(Eein-masele .le. media.cnst.BrEgminS ) then
      Ek = Eein-masele
      if(Eein .lt. media.cnst.BrEeminS) then
c         this  happne when electron loses energy    
c         after sampling of processes
         Ee = media.cnst.BrEeminS
      else
         Ee = Eein
      endif
      Ek = Ee - masele
      vmax = 1.-masele/Ee
      ale = log10(Ek)

      count = 0      
 10   continue
      call rndc(u)
      if(u .gt. media.cnst.BrUminSA) then
c          region A
c&&&&&&&&&&&&&
c         call k4ptdi(media.tbl.BrSTSA, 
c     *        media.cnst.BrUszSA, 
c     *        media.cnst.BrES,
c     *        media.cnst.BrUszSA, 
c     *        media.cnst.BrUminSA,
c     *        media.cnst.BrLEeminS,
c     *        media.cnst.BrdUSA,
c     *        media.cnst.BrdES, u,  ale,  ans)  
c         Eg= exp( ans*(1.-u))*media.cnst.BrEgminS
         call kpolintp2(media.cnst.BrUminSA, 1,  media.cnst.BrdUSA,
     *            media.cnst.BrLEeminS, 1, media.cnst.BrdES,
     *            media.tbl.BrSTSA,  media.cnst.BrUszSA, 
     *            media.cnst.BrUszSA,  media.cnst.BrES,
     *             3, 3,  u, ale, ans, error)
c&&&&&&&&
         Eg= exp( ans*(1.-u))*media.cnst.BrEgminS*Ee
      else
c         region B
         us = u**0.25d0
c&&&&&&&&&&&&&&&
c         call k4ptdi(media.tbl.BrSTSB, 
c     *        media.cnst.BrUszSB, 
c     *        media.cnst.BrES,
c     *        media.cnst.BrUszSB, 
c     *        0.d0,
c     *        media.cnst.BrLEeminS,
c     *        media.cnst.BrdUSB,
c     *        media.cnst.BrdES, us,  ale,  ans)  
c&&&&&&&&&&&&&&&
         call kpolintp2(dummy, 1, media.cnst.BrdUSB,  
     *            media.cnst.BrLEeminS, 1, media.cnst.BrdES,
     *            media.tbl.BrSTSB,  media.cnst.BrUszSB, 
     *            media.cnst.BrUszSB,  media.cnst.BrES,
     *             3, 3,  us, ale, ans, error)
         Eg = exp(-ans*u)*Ee*vmax
      endif

      ok = Eein-Eg .ge. masele

      if(.not. ok) then
         count  = count + 1
         if(count .gt. 100 ) then
            call rndc(u)
            Eg = (Eein-masele)*u
            return  !  ******
         endif
         goto 10
      endif
      end
