      subroutine epNormLPMc(norm)
      implicit none
c           This normalization const should be used for
c       complete screening + LPM function normalization.
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmass.h"      
#include "Zmedia.h"
#include "ZBPgene.h"

      real*8  norm          ! output.  LPM function * norm 
                            !          becomes equal to complete
                            !          screening case.

      real*8 dsdxH, dsdxcs, dz

      real*8 epBremH, epCompScrBr

      real*8 xnorm/0.75d0/  ! normalization point
      integer i

c        normalize the cross-section at x=xnorm, Ee=EemaxL to the
c        complete screening case.

c      dz = media.Zeff
      dz = media.Z
c  ??????????
      call epBPZpartH(media)
c  ???????????
      
      dsdxH =  epBremH(media.cnst.BremEemaxL/masele, xnorm) 
      dsdxcs = 0.
      do i = 1, media.noOfElem
         dsdxcs = dsdxcs +
     *        epCompScrBr(media.elem(i).Z, xnorm) *
     *        media.No(i)
      enddo 
      norm = dsdxcs/dsdxH
      end
c     ***************************
      subroutine epNormLPMp(norm)
      implicit none
c           This normalization const should be used for
c       complete screening + LPM function normalization
c       of pair creation.
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmass.h"      
#include "Zmedia.h"
#include "ZBPgene.h"

      real*8  norm          ! output.  LPM function * norm 
                            !          becomes equal to complete
                            !          screening case.

      real*8 dsdxH, dsdxcs, dz

      real*8 epPairH, epCompScrPr

      real*8 xnorm/0.75d0/  ! normalization point
      integer i

c        normalize the cross-section at x=xnorm, Eg=EgmaxL to the
c        complete screening case.

c      dz = media.Zeff
      dz = media.Z

      dsdxH =  epPairH(media.cnst.PairEgmaxL/masele, xnorm) 
      dsdxcs = 0.
      do i = 1, media.noOfElem
         dsdxcs = dsdxcs +
     *        epCompScrPr(media.elem(i).Z, xnorm) *
     *        media.No(i)
      enddo 

      norm = dsdxcs/dsdxH
      end
c     **************************************************
      subroutine epNormLPMs(func, atx, norm)
      implicit none
c
c         This normalization should be used when partial
c         screening + LPM correction is needed.
c

#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmass.h"      
#include "Zmedia.h"
#include "ZBPgene.h"

      external func

      real*8 func           ! input. brems function name to which
                            ! the LPM is normalzied.  used as f(x).
      real*8 atx            ! input. x =  Eg/Ee  where the LPM function 
                            ! is normlized to func(x)
      real*8  norm          ! output.  LPM function * norm
                            !         becomes equal to f(x) at 'atx'
c
      real*8 epBremSH
      real*8 dsdxH, dsdxs
      
      dsdxH =  epBremSH(atx) 
      dsdxs = func(atx)
      norm = dsdxs/dsdxH
      end
