      implicit none
#include "Zmedia.h"
#include "Zmass.h"
c
c          test Moller scattering diff.  function.
c          as a function of recoil electron energy
c          at fixed electron energy
c 
      record /epmedia/media
      integer i, io, icon
      real*8 Ee, prob,  w, path, v, vm
      real*8 xm , epmollertx,  g, func, epMoller
      character*80 file

      io = 10
      
      call  cerrorMsg(
     * "Enter  electron energy(1. GeV),"//
     * " minimu recoil energy(200d-6 GeV)"//  
     * " and file path('../../Data/Media/BGO')", 1)
      Ee = 1.
      w = 200.0d-6
      file = '../../Data/Media/BGO'
      
      read(*, *)  Ee, w, file
      call cerrorMsg(file,  1)

      call copenf(io, file, icon)
      call epReadTab(io, media)
      close(io)
      call epGetEffZA(media)
      call epStern(w, media)
      vm =  1.01*w/((Ee-masele)/2)
      v = 0.5
      call epmollerp(media, Ee, w,  prob, path)
      g = Ee/masele
      do while ( v .gt. vm )
         func = epMoller(g, v)  ! bare Moller function
         write(*,'(3g12.4)') v,  func,
     *       func*media.sh.a/((g-1)*masele)/(1.-1./g/g)
         v = v/10.**0.02
      enddo
      end

      real*8 function epMoller(g, v)
      implicit none
c         gives diff. Moller xs= ds/dv (v=Ek/T0)
c     Ek; recoil  electron kinetic energy
      real*8 v
      real*8 g  ! incident electron gamma factor
c     T0:      its kinetic energy
c            
c        if this is multiplied by C/m(g-1), prob/(g/cm2)
c       is obtained.  C=0.153..Z/A/beta^2
c

      epMoller=((g-1)/g)**2 +(1./v-(2*g-1)/g**2)/v +
     *  (1./(1.-v) - (2*g-1.)/g**2)/(1.-v)
      end
