      subroutine epdeflection(icon)
      implicit none
#include "ZepTrackv.h"
#include "ZepTrackp.h"
c        All deflections are managed here:
c        Move.Track is assumed to be the streight extension 
c        of cTrack.  Here deviation from the initial Moved.Track
c        must be computed and  added to it successively.
c        However, if we compute magnetic deflection, we can
c        compute the end point coordinate and direction cosines
c        directly.  So we compute Magnetic def. first and
c        add other effect later.
c
c     1) magnetic deflection
c     2) electric deflection
c     3) multiple Coulomb scatteringc
      integer icon  ! output.  icon=1 when infinite loop or unchanged

      record /epmove/moveSave
      integer nx

c          save current Move
      moveSave.Track.pos = Move.Track.pos
      if(MagField .ne. 0) then
         if(Bfield.x .ne. 0. or. Bfield.y .ne. 0. .or.
     *      Bfield.z .ne. 0. ) then
            call epdefByB(icon)
         endif
      endif
      if(ElecField .ne. 0) then
         call epdefByE
      endif
      if(Media(MediaNo).name .ne. 'sp' .and.
     *     Media(MediaNo).name .ne. 'hollow') then
         call epdefByMScat
      endif

c       check if position moved to another component
c       due to scattering, if so, resotore the position
c       without  scattering/deflection
      if(.not. Move.Cross) then  ! ++++++++++
         call eppos2cn(Cn, Move.Track, nx)
         if(Cn .ne. nx) then
c           the new pos. dose not remain in the same component
c            no displacement due to scattering
            Move.Track.pos = moveSave.Track.pos
         endif
      endif
      end
c     ***********************
      subroutine epdefByMScat
c         deflection by Coulomb scattering
      implicit none
#include "ZepTrackv.h"
#include "ZepTrackp.h"

      record /epDirec/ dsa   ! dire ccos of scattering angle
      record /epDirec/ w
      real*8 theta, sint, cs, sn, tmp, avx, avy, disp
      real*8 r, dx, dy, g1, g2, gf1, gf2, beta2, tetarms

      call epmulScat(Media(MediaNo), theta) ! theta may > pi/2 for Moliere=T or >=2
      if(theta .lt. 0.3d0) then
c                 cos
         dsa.z = 1.-theta**2/2   ! 0.04 % error
         sint = (-theta**2/6.d0 +1.d0)*theta 
      else
         dsa.z = cos(theta)
         sint = sin(theta)
      endif
c        azimuthal angle
      call kcossn(cs, sn)
c
      dsa.x = sint * cs
      dsa.y = sint * sn

      if( ( ALateCor .eq. 2 .or.
c     *   (ALateCor .eq. 1 .and. .not. Moliere )) .and.
     *   (ALateCor .eq. 1 .and.  Moliere==0 )) .and.
     *        .not. Move.Cross) then  !+++++++++++++
c         sample displacement correlated to theta 
c                 this is the same as P.D.B though look like
c               diff.
         tmp = Move.dl/2.d0
         avx = tmp * dsa.x
         avy = tmp * dsa.y
c                dispersion
         gf1 = cTrack.p.fm.p(4)/cTrack.p.mass
         gf2 = Move.Track.p.fm.p(4)/cTrack.p.mass
         beta2 = 1.d0 - 1.d0/gf1/gf2
         if(beta2 .le. 0.) then
            disp = 0.d0
         else
            if(Move.dt .gt. 1.d-3) then
c              beta is considered later in disp
               tetarms = Escat/cTrack.p.fm.p(4)*abs(cTrack.p.charge)*
     *      sqrt(Move.dt)*(1.0 + 0.038*log(Move.dt))
c     *      sqrt(Move.dt)

            else
               tetarms = Escat/cTrack.p.fm.p(4)*abs(cTrack.p.charge)*
     *              sqrt(Move.dt)
            endif
            disp=tetarms/sqrt(6.d0*beta2)*Move.dl/2.d0
c               sample 2 independent gaussian variables
c             with mean 0 and var 1
         endif
         call kgauss2(0.d0, 1.0d0, g1, g2)
         dx = g1 * disp + avx
         dy = g2 * disp + avy

c                  displacement

         r=sqrt(dx*dx+dy*dy)
c              direction cos of vector r in original sys.
         if(r .ne. 0.) then
            w.x = dx/r
            w.y = dy/r
            w.z = 0.
c                 transform w1,w2,w3 to original sys.
            call eptransVect(cTrack.w, w, w)
c               r is already in cm.
c              add scattering effect.
c              r*w is displacement by scattering
            Move.Track.pos.x = r*w.x + Move.Track.pos.x
            Move.Track.pos.y = r*w.y + Move.Track.pos.y
            Move.Track.pos.z = r*w.z + Move.Track.pos.z
         endif
      endif
c        convert scattering angle at end of path to
c        original system
      call eptransVect(Move.Track.w, dsa, Move.Track.w)
      end
c     ********************
      subroutine epdefByB(icon)
#include "ZepTrackp.h"
#include "ZepTrackv.h"
       integer icon  ! output. =1 if infinite loop or unchaged
       record /ep3Vec/ dispmr
       record /epDirec/ dispmd
       real*8  norm
       real*8 path, radius, loop
       data   path/0./
       save   path, loop
c
c           trick to avoid semi-infinite loop in vaccum 
c
       if(Media(MediaNo).name .ne. 'sp' .and.
     *    Media(MediaNo).name .ne. 'hollow'  ) then
          pathInB = 0.
       endif
       if(pathInB .eq. 0.) then
          call epmagDefR(cTrack, Bfield, radius) ! rough radius
c                 if  a ptcl runs  SyncLoop times of cyclotron  radius
c                 discard it
          loop = SyncLoop * radius
       endif
       pathInB = pathInB + Move.dl
       if(pathInB .gt. loop) then
          Move.Trunc = .True.
          icon =1
          pathInB = 0.
       endif

       call epmagneticDef(cTrack, Bfield, Move.dl, dispmr, dispmd)
c
c         dispmr is
c         displacement to be added to cTrack. (not Move.Track)
c              ++++++++++++++
       if(.not. Move.Cross) then
          Move.Track.pos.x = cTrack.pos.x + dispmr.x
          Move.Track.pos.y = cTrack.pos.y + dispmr.y
          Move.Track.pos.z = cTrack.pos.z + dispmr.z
       endif
       Move.Track.w.x = dispmd.x
       Move.Track.w.y = dispmd.y
       Move.Track.w.z = dispmd.z
      end
      subroutine epdefByE
      end

c      Compute magnetic deflection (angle and displacement)
c      
c     ************************************************  
      subroutine epmagneticDef(aTrack, B, leng, dr,  dir)
c     ************************************************  
      implicit none
#include "ZepTrack.h"
#include "Zep3Vec.h"

      record /epTrack/ aTrack     ! input. a charged ptcl at initial pos.
      record /ep3Vec/ B            ! input. magnetic field vector. in T
                                  !  in local coordinate
      real*8  leng         ! input. length  travelled in cm
      record /ep3Vec/  dr  ! output. displacement vector in cm
      record /epDirec/dir  ! output.  new direction cos 
c    This is exact if B is const.
c   Note that:
c      dr must be added  as  newpos = oldpos +  dr
c      dir is the new direction cos.  These two are differenct
c      from the old version.
c

c
      record /epPos/ Tx, Ty, Tz, w, r

      real*8 Babs, sint, cost, rgt, sinl, cosl
      real*8   pabs, temp
c
c       get abs(B)
      Babs = sqrt( B.x**2 + B.y**2 + B.z**2 )
      if(Babs .gt. 0.) then
c            p in GeV
         pabs = sqrt(aTrack.p.fm.p(4)**2 - aTrack.p.mass**2)
         if(pabs .gt. 0.) then
c              gyroradius in cm. B in T, p in GeV
c              For negative charge, rgt < 0. This is o.k
c                 real radius is rgt*sintc

            rgt = 3.3358d2*pabs/aTrack.p.charge/Babs

            Tz.x = B.x/Babs
            Tz.y = B.y/Babs
            Tz.z = B.z/Babs

            call cscalerProd(aTrack.w, B, cost)
            cost =max( min(cost/Babs, 1.0d0), -1.d0)
            sint = sqrt(1.0d0-cost**2)
            if(abs(sint) .gt. 1.d-6) then            
               call cvecProd(aTrack.w, Tz, Tx)
               Tx.x = Tx.x/sint
               Tx.y = Tx.y/sint
               Tx.z = Tx.z/sint
               call cvecProd(Tz, Tx, Ty)
c////////////////
c               call checkuv('Tx', sint, Tx)
c               call checkuv('Ty', sint, Ty)
c               call checkuv('Tz', sint, Tz)
c               call checkorth('TxTy', sint, Tx, Ty)
c               call checkorth('TxTz', sint, Tx, Tz)
c//////////////////////               
            else
               Tx.x = 1.d0
               Tx.y = 0.
               Tx.z = 0.
               Ty.x = 0.
               Ty.y = 1.d0
               Ty.z = 0.
            endif
c            get wz0=wz
            call cscalerProd(Tz, aTrack.w, w.z)
            temp = leng/rgt
            sinl = sin(temp)         ! this may be < 0
            cosl = cos(temp)

            w.x = sint*sinl
            w.y = sint*cosl
c///////////
c            call checkuv('w ', sint, w)
c///////////
            r.x = - rgt*sint*(cosl - 1.d0)
            r.y = rgt*sint*sinl
            r.z = leng*w.z
c                convert to original system.
            dr.x =
     *          Tx.x*r.x + Ty.x*r.y + Tz.x*r.z
            dr.y =
     *          Tx.y*r.x + Ty.y*r.y + Tz.y*r.z
            dr.z =
     *          Tx.z*r.x + Ty.z*r.y + Tz.z*r.z
c                directon cos
            dir.x =
     *          Tx.x*w.x + Ty.x*w.y + Tz.x*w.z
            dir.y =
     *          Tx.y*w.x + Ty.y*w.y + Tz.y*w.z
            dir.z =
     *          Tx.z*w.x + Ty.z*w.y + Tz.z*w.z
         else
            dr.x = 0.
            dr.y = 0.
            dr.z = 0.
            dir = aTrack.w
         endif
      else
         dr.x = leng*aTrack.w.x
         dr.y = leng*aTrack.w.y
         dr.z = leng*aTrack.w.z
         dir = aTrack.w
      endif
      end
