	subroutine epUrban(urb, avededx, dx, aPtcl, de)
	implicit none
#include "Zptcl.h"
#include "Zurban.h"
c    By using Urban model, energy loss is calculated with 
c    full fluctuation; this is consistent with Landau/Vavilov/Gaussina
c    theory if the all delta ray is taken into account.  
c    ***************
c   This must be called after epsetUrban has been called to fix the 
c   medium consts. 
c
c   -----------------------------------------------------------
c   The cut-off energy of delta electron must be
c   lower than the maximum transferable energy to electrons.
c   -----------------------------------------------------------
c
c    ***************
	record /urban/urb ! input. Urban's const of the medium
	real*8 avededx  ! input. average dE/dx in GeV/cm.

	real*8 dx       ! input. pass length in cm for which energy loss
                        !        is to be sampled.
        record /ptcl/aPtcl ! input. mass and energy are used.
	real*8 de       ! output. sampled energy loss for pass dx in GeV.
              
	real*8 gamma, beta2, gbeta2
        integer i
        real*8 mgb2
	include "ZdEdxSpec.h"
c
c///////////////
c	write(0,*) ' entering urb: dx =', dx
c	write(0,*) ' code, sub, chg KE=', 
c     *   aPtcl.code,aPtcl.subcode,aPtcl.charge, aPtcl.fm.p(4)-aPtcl.mass
c	write(0,*) ' avededx=',avededx
c///////////////

	if(aPtcl.fm.p(4) - aPtcl.mass .le. 1.d-6 ) then
	   de = avededx*dx
        elseif( dx .le. 0.) then
	   de = 0.
	else
	   if( Tupper  .gt.  urb.EmaxN ) then
	      urb.Emax = urb.EmaxN
	      urb.EmaxI = urb.EmaxIN 
	      urb.IEmaxI = urb.IEmaxIN 
	      urb.EmaxByEmaxI = urb.EmaxByEmaxIN
	      urb.PreSigma3 =  urb.PreSigma3N
	   else
	      urb.Emax = Tupper
	      urb.EmaxI = urb.Emax + urb.AveIoniz
	      urb.IEmaxI = urb.AveIoniz * urb.EmaxI
	      urb.EmaxByEmaxI = urb.Emax/urb.EmaxI
	      urb.PreSigma3 = urb.EmaxByEmaxI /
     *         (urb.AveIoniz * log(urb.EmaxI/urb.AveIoniz) )
     *          *  urb.ExToIoniz
	   endif

	   gamma =aPtcl.fm.p(4)/aPtcl.mass
	   beta2 = 1.0d0 - 1./gamma**2
	   gbeta2 = gamma**2 * beta2
	   mgb2 = aPtcl.mass*gbeta2 * 2

	   do i = 1, 2
	      urb.MacroSigma(i) =
     *        avededx* urb.OscStr(i)/urb.ExcitErg(i) * 
     *        (  log(mgb2/urb.ExcitErg(i)) - beta2 ) /
     *        (  log(mgb2/urb.AveIoniz   ) - beta2 ) *
     *        (1.-urb.ExToIoniz)
	   enddo
	   urb.MacroSigma(3) = avededx * urb.PreSigma3
	   do i = 1, 3
	      urb.AveN(i) = urb.MacroSigma(i) * dx
	      if(urb.AveN(i) .le. 0.) then
		 urb.ElossTotal = avededx*dx
		 goto 100
	      endif
	   enddo	
c            very thin cases must be treated specially
c            by epUrbanThin below, 
	   if(urb.AveN(1)+ urb.AveN(2) + urb.AveN(3) .lt. 4.6) then
c               ! no energy loss probability is > 0.01. treat specially
	      call epUrbanThin(urb, avededx*dx)
	   else
	      call epUrbanNorm(urb)
	   endif
 100	      continue
	   de = urb.ElossTotal
	endif
c////////////
c	write(0,*) ' exiting urban'
c////////////
        end 
c       ------------------------------------------------
        subroutine epUrbanThin(urb, avede)
	implicit none
#include "Zurban.h"
	record /urban/urb
	real*8 avede  ! input. <dE/dX> *dX  GeV
c          very thin path case.
c          interaction is assumed to be with outer electrons only.
c          Their energy level is 10 eV.
        integer i
	real*8 u
c             original prescription
c	urb.AveNThin = avede/urb.EOuter
c
	urb.AveNThin = avede* (1./urb.EOuter - 1./urb.Emax)
     *    /log(urb.Emax/urb.EOuter)
	call kpoisn(urb.AveNThin, urb.NThin)
	urb.ElossTotal = 0.
	do i = 1, urb.NThin
	   call rndc(u)	
c            original     
c	   urb.ElossTotal = urb.ElossTotal + urb.EOuter/
c     *         (1. - u*urb.Emax/(urb.Emax + urb.EOuter))

	   urb.ElossTotal = urb.ElossTotal + urb.EOuter/
     *         (1. - u*(1.-urb.EOuter/urb.Emax))
        enddo
c           another method; but we need to know peak position
c          we use approximate Lanau distriubution as given
c           by ksplandau
c
c	real*8 b, c
c	c = avede/...
c	b = c*..
c	call ksplandau(b, c, urb.ElossTotal)

        end
c       --------------------------
        subroutine epUrbanNorm(urb)
	implicit none
#include "Zurban.h"
	record /urban/urb

	integer i
	real*8 u, logAlfa, temp


c          sample actual number of excitation and ionization.
        do i = 1, 3
   	    call kpoisn(urb.AveN(i), urb.Ncoll(i))
        enddo
c         energy loss due to exciteation.
        urb.ElossByExcit = urb.Ncoll(1) * urb.ExcitErg(1)  +  
     *                urb.Ncoll(2) * urb.ExcitErg(2)

c          now loss by ionization.

        if(urb.Ncoll(3) .lt. urb.LargeN3) then
	   urb.ElossByIoniz = 0.
	   do i = 1, urb.Ncoll(3)
	      call rndc(u)
	      urb.ElossByIoniz  = urb.ElossByIoniz +
     *          urb.AveIoniz/(1.0 - u *urb.EmaxByEmaxI)
	   enddo
        else
            urb.Alfa = (urb.Ncoll(3) + urb.Smallc2)*urb.EmaxI/
     *      (urb.Smallc2*urb.EmaxI+ urb.Ncoll(3)*urb.AveIoniz)

            logAlfa = log(urb.Alfa)

            urb.PAtype = urb.EmaxI*(urb.Alfa-1.)/urb.Emax/urb.Alfa

            urb.AveElossAtype = 
     *       urb.AveIoniz *urb.Alfa *logAlfa/(urb.Alfa -1.0)

            urb.SigmaElossA2 = urb.AveIoniz2 * urb.Alfa *
     *        (1. - urb.Alfa* (logAlfa/(urb.Alfa-1.0))**2 )

c             average number of A type col.
            urb.AveAtype = urb.Ncoll(3) * urb.PAtype
            urb.SigmaAtype =
     *      sqrt(max(urb.AveAtype * (1.0d0 - urb.PAtype), 0.d0) )

            call kgauss(urb.AveAtype, urb.SigmaAtype, temp)
	    urb.NAtype =max( temp + 0.5d0, 0.d0)
c             average energy loss by NAtype coll.
	    urb.AveElossByNAtype = urb.NAtype * urb.AveElossAtype
            urb.SigmaByNAtype = sqrt(urb.NAtype * urb.SigmaElossA2)
c              sample from Gaussian
            call kgauss(urb.AveElossByNAtype, urb.SigmaByNAtype, 
     *         urb.ElossByAtype)
	
            urb.ElossByBtype = 0.
	    urb.NBtype = urb.Ncoll(3) - urb.NAtype 
	    do i = 1, urb.NBtype
	       call rndc(u)
	       urb.ElossByBtype = urb.ElossByBtype + 
     *         urb.Alfa*urb.AveIoniz / 
     *         ( 1.0 - u *
     *         (urb.EmaxI - urb.Alfa*urb.AveIoniz)/urb.EmaxI)
            enddo
            urb.ElossByIoniz = urb.ElossByAtype + urb.ElossByBtype
        endif
 
	urb.ElossTotal = urb.ElossByExcit + urb.ElossByIoniz
c       /////////////////
c 	write(12, *)
c     * sngl(urb.ElossByIoniz*1.d3/dx), 
c     * sngl(urb.ElossByAtype*1.d3/dx), 
c     * sngl(urb.ElossByBtype*1.d3/dx),
c     * sngl(urb.ElossByExcit*1.d3/dx),
c       /////////////
        end
        subroutine epsetUrban(media, urb)
c
c          set Urban's consts. must be called after epStern has been called
c
        implicit none
#include "Zmedia.h"
        record /epmedia/media  ! input.  media
        record /urban/urb !  outupt. Urban's consts.    = media.urb
c
c       EmaxN, EmaxIN, IEmaxIN, EmaxByEmaxIN, PreSigma3N; these are
c         to replace Emax etc (those without N)
c
        urb.LargeN3 = 16
C	urb.ExToIoniz = 0.4
	urb.ExToIoniz = 0.5
        urb.EOuter = 10.d-9   ! 10 eV for outer electron ionization


c        urb.Zeff = media.Zeff
        urb.Zeff = media.Z
	urb.AveIoniz = media.I
	urb.AveIoniz2 = urb.AveIoniz**2

	urb.EmaxN = media.sh.tcut  ! in GeV unit
	urb.EmaxIN = urb.EmaxN + urb.AveIoniz
	urb.IEmaxIN = urb.AveIoniz * urb.EmaxIN
	urb.EmaxByEmaxIN = urb.EmaxN/urb.EmaxIN
	urb.PreSigma3N = urb.EmaxByEmaxIN /
     *  (urb.AveIoniz * log(urb.EmaxIN/urb.AveIoniz) ) *
     *   urb.ExToIoniz

	urb.Smallc2 = urb.LargeN3
	if(urb.Zeff .le. 2.) then
	    urb.OscStr(2) = 0.
	else	
	    urb.OscStr(2) = 2./urb.Zeff
        endif
	urb.OscStr(1) = 1. - urb.OscStr(2)
c        urb.ExcitErg(2) = 10.d-9 * media.Z2eff  ! approx K-shell energy in GeV
        urb.ExcitErg(2) = 10.d-9 * media.Z2  !  which is better ?
        urb.ExcitErg(1) = 
     *  (urb.AveIoniz/urb.ExcitErg(2)**urb.OscStr(2))
     *          **(1./urb.OscStr(1))
        urb.ExcitErg(1) = 
     *  (urb.AveIoniz*1.d9/(urb.ExcitErg(2)*1.d9)**urb.OscStr(2))
     *          **(1./urb.OscStr(1))*1.d-9


        end

