c     ****************************************************************
c     *                                                              *
c      brems and pair functions at high energies where the LPM
c           is effective.
c      before this used, epBPZpartH must be called.
c     ****************************************************************
c      cross-sections is given in mb/target.
c           ???    That is, compound or molecule is regarded as
c        one atom with some effective (A,Z).
c
c
      real*8 function epBremH(Eeme, vv)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmass.h"      
c
      real*8  Eeme ! input Ee/me
      real*8  vv   ! input. Eg/Ee

      common /landuc/  s1, alogs1, sconst, x0g, conv2mb
      real s1, alogs1, sconst, x0g, conv2mb

      real*8 Tomb   ! to mb conversion
      parameter (Tomb = 1.d27/N0)
c       The original LPM cross section is given in unit of prob/r.l,
c       With  N being the number density(/g),
c             L the length and S the cross-section
c       NLS=1.    
c       N =  N0/A (/g), 1/L (/r.l) = 1/( L*X0g) (/(g/cm^2))
c       so that
c       S = prob/r.l * (1/X0g) * A/N0  (X0g is the radiaiton length
c       in unit of (g/cm^2).  Since X0g is propotional to A we may
c       express X0g= A*x0g where x0g is the r.l for A=1 with the same
c       Z for X0g. Then
c       S= prob/r.l / (x0g * N0) (cm^2).  To get this in mb
c       10^27 must be multiplied.
c

      real er, eps
      real v, E, s,  smigb, gzai, gmigdl, psimig
      data er/1.e-4/, eps/1.e-4/
      
      
      v=vv

      E = Eeme *masele

      if(vv .ge. .99999d0) then
         epBremH = (v*v+2.*(1.+(1.-v)*(1.-v)))/v/3.
      elseif(v .eq. 0.) then  
         epBremH = 0.
      else

         s = 1.
c         s=sbrem2(v, E, s)
         s = smigb(v, E, s, er)
         if(s. gt. 1.0) then
            epBremH = (v*v+2.*(1.+(1.-v)*(1.-v)))/v/3.
         else
c            s = smigb(v, E, s, er)
            epBremH = 
     *       gzai(s)/v*(v*v*gmigdl(s,eps)+2.*(1.+(1.-v)*(1.-v))*
     *       psimig(s, eps))/3.
c
c           note that as v-->0, gzai(s) becomes 2 and
c           epBremH---> 2/v *( v*v*12pi*s**2 + 2*(1+(1-v)**2 )* 6 s) )/3
c           where s---> sqrt( sconst*v/2/e/(1-v))
c           so that epBremH--->8*sqrt(2*sconst/v/e)
         endif
      endif

cc     epBremH =  epBremH * Tomb/x0g 
      epBremH =  epBremH * conv2mb

      end
c     ***********
      real*8 function epPairH(Egme, vv)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"
#include "Zmass.h"
      real*8 Egme  ! input  Eg/me
      real*8 vv    ! input  Ee/Eg, Ee is the higher energy  of pair.


      common /landuc/  s1, alogs1, sconst, x0g, conv2mb
      real s1, alogs1, sconst, x0g, conv2mb


      real E, v, s, er, eps, gzai, gmigdl, psimig, smigp
      real*8 cmTomb
      parameter (cmTomb = 1.d27/N0)

      data er/1.e-4/, eps/1.e-4/

      E = Egme* masele

      v=vv
      if(vv .ge. 0.9999d0 .or. v .eq. 0.) then
         epPairH = (1.+2.*(v*v+(1.-v)*(1.-v)))/3.
      else
         s = 2.
c         s = spair2(v,E,s)

         s = smigp(v,E,s,er)
         if(s .gt. 1.) then
            epPairH = (1.+2.*(v*v+(1.-v)*(1.-v)))/3.
         else
c            s = smigp(v,E,s,er)
            epPairH = 
     *       gzai(s)/3.*(gmigdl(s,eps)+2.*(v*v+(1.-v)*(1.-v))*
     *       psimig(s, eps))
         endif

      endif
ccc      epPairH = epPairH * cmTomb/x0g
      epPairH = epPairH * conv2mb
      end
c     ****************************************************************
c     *                                                              *
c     * smigb:  get root s, from recursive relation                  *
c     *                                                              *
c     ****************************************************************
c
c
      real function smigb(v, e, s, er)
      implicit none
c
      real v, e, s, er
      real  ss, sbrem2 
c
    5 continue
      ss=sqrt(sbrem2(v,e,s))
      if(abs((s-ss)/ss).lt.er) goto 10
      s=ss
      goto 5
   10 continue
      smigb=ss
      end
c
c     ***********
      real function smigp(v, e, s, er)
c     ***********
      implicit none
c
      real v, e,  s, er,  spair2, ss 

   15 continue
      ss = sqrt( spair2(v, e, s)  )
      if(abs((s-ss)/ss).lt.er) go to 20
      s=ss
      go to 15
   20 continue
      smigp=ss
      end
c     ****************************************************************
c     *                                                              *
c     * sbrem2:  auxliary function for brem with landau effect       *
c     * spair2:  //                    pair                          *
c     *                                                              *
c     ****************************************************************
c
c
      real  function sbrem2(v,e,s)
      implicit none
c
c
c
c
      common /landuc/  s1, alogs1, sconst, x0g, conv2mb
      real s1, alogs1, sconst, x0g, conv2mb

c     
      real v, e,  s, tmp, gzai

      tmp=sconst*v
      sbrem2=tmp/(1.-v)/e/gzai(s)
      end

      real function  spair2(v,e,s)

      common /landuc/  s1, alogs1, sconst, x0g, conv2mb
      real s1, alogs1, sconst, x0g, conv2mb


      real  v, e,  s, tmp, gzai

      tmp=sconst/v
      spair2=tmp/(1.-v)/e/gzai(s)
      end
c     ****************************************************************
c     *                                                              *
c     * gzai:  gzai function which appear in ladanu effect           *
c     *                                                              *
c     ****************************************************************
c
c
      real function gzai(s)
      implicit none
c
c
c

      common /landuc/  s1, alogs1, sconst, x0g, conv2mb
      real s1, alogs1, sconst, x0g, conv2mb
      real s

      if(s .gt. 1.) then
         gzai=1.
      elseif(s. gt. s1) then
         gzai =  log(s)/alogs1+1.
      else
         gzai=2.
      endif
      end
c     ****************************************************************
c     *                                                              *
c     * gmigdl:  g(s) function which appear in landau effect         *
c     * psimig:  pis(s) //                                           *
c     *                                                              *
c     ****************************************************************
c
c             .... psiim is needed.....
c
      real function gmigdl(s,eps)
      implicit none
      real s, eps
      real pi12,  pi6,  psiim
c
c
      data pi12,pi6/37.699112,18.849556/
      gmigdl=(pi12*s-48.*s*s*psiim(s+0.5,s,0,eps))*s
      end
c
c     ************
      real function psimig(s,eps)
c     ************
      implicit none
      real s, eps
      real pi12, pi6,  psiim
c
      data pi12,pi6/37.699112,18.849556/
      psimig = ( (psiim(s,s,1,eps)*s*24.-pi6)*s+6.) *s
      end
c     ****************************************************************
c     *                                                              *
c     * epBPZpartH:  z-dependent part of brems and pair
c                    functions const with the LPM effect
c      For LPM, we use effective Z / media but not Z /atom or Z/molecule
c        ???
c 
c     ****************************************************************
c

c
      subroutine epBPZpartH(media)
      implicit  none
#include "Zmedia.h"      
#include "Zmass.h"      
c
      record /epmedia/media

      common /landuc/  s1, alogs1, sconst, x0g, conv2mb
      real s1, alogs1, sconst, x0g, conv2mb
      real*8 dx0g, dz
      real z

c

c      s1=    ( z**0.3333333/ 183 )**2
      s1 = media.s1
      alogs1 =  media.logs1
c      conv2mb = 1.d0/media.mbtoPX02  ! any. since normalization is done later
      conv2mb = 1.d0/media.mbtoPX0    ! any. since normalization is done later
c
c       compute radation length in g/cm2 for virutual matter: A = 1 and z
c       This x0g is used to convert the prob. / X0 into mb
c      (see note at the program top)
c        
c      z = media.Zeff
      z = media.Z
c      dz = media.Zeff
      dz = media.Z
      if(z .lt. 11.) then
c         call epX01(dz, 1.d0, dx0g)
c         call epX0(dz, 1.d0, dx0g)  ! should have been called aleady
c         x0g = dx0g
         x0g = media.X0g
      else
c         call epX0Old(z, 1., x0g)
         x0g = media.X0g
      endif
c
c         const in eq.60 of migdal's paper. phys. rev. vol 103 1956
c         energy is in gev
      sconst=( 1.37e3 ) **2 * media.X0 * masele

      end
