c 
c  gives mean -de/dx  (gev/(g/cm2)) for heavy particle (A,Z>1)
c      tested.
c
      subroutine epdedxhvy(media, aPtcl, dedt)
      implicit none
#include "Zmedia.h"
#include "Zptcl.h"
#include "Zcode.h"
#include "Zmass.h"


      record /epmedia/media       ! input. media.sh

      record /ptcl/aPtcl        ! input. a particle

      real*8 dedt               ! output. <Energy loss rate>  GeV / (g/cm2). 

      real*8  kepn
c           , dedtproton
      real*8  epdedxqeff

      character*80 msg

c      record /ptcl/ proton

      if(aPtcl.code .ne. kgnuc) then
         write(msg, *) ' ptcl code=',aPtcl.code,
     *     ' is not a heavy particle'
         call cerrorMsg(msg, 0)
      endif

c      call cmkptc(knuc, regptcl, 1, proton)
c      proton.fm.p(1)=0.
c      proton.fm.p(2)=0.
      kepn = (aPtcl.fm.p(4)-aPtcl.mass)/aPtcl.subcode  ! T/A
c      proton.fm.p(4)=kepn + proton.mass
c      proton.fm.p(3)=sqrt(proton.fm.p(4)**2 -proton.mass**2) 
c      call epdedxNone(sh, proton, dedtproton)
      call epdedxNone(media, aPtcl, dedt)
      if(kepn .gt. 0.7) then
c          dedt = dedtproton * aPtcl.charge**2
      else
c         dedt = dedtproton * epdedxqeff(aPtcl)**2
         dedt = dedt *( epdedxqeff(aPtcl)/aPtcl.charge)**2
      endif
      end
c     *********************************
      real*8 function epdedxqeff(aPtcl)
      implicit none
#include "Zptcl.h"
      record /ptcl/aPtcl        ! input. a particle

      real*8  gi, beta, x,  z23, qeff

c            compute effective charge         
c               get beta
      gi=aPtcl.mass/aPtcl.fm.p(4)
      if(gi .lt. 1.d-2) then
         beta = 1.d0 - gi**2/2.0
      else
         beta =sqrt(1.d0 - gi**2)
      endif

      z23 = aPtcl.charge**(0.666666)
      x = 121.414*beta/z23 + 0.0378*sin(190.72*beta/z23)
      qeff = aPtcl.charge * (1. -
     *        (1.034- 0.1777*exp(-0.0811*aPtcl.charge))*
     *        exp(-x) )
      qeff = max(qeff, 1.d-1)
      epdedxqeff = qeff
      end



       




